/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzclm;
import com.google.android.gms.nearby.messages.zza;
import java.util.Arrays;

public class Message
extends com.google.android.gms.common.internal.safeparcel.zza
implements ReflectedParcelable {
    public static final int MAX_CONTENT_SIZE_BYTES = 102400;
    public static final int MAX_TYPE_LENGTH = 32;
    public static final Parcelable.Creator<Message> CREATOR = new zza();
    private static final zzclm[] zzjdo = new zzclm[]{zzclm.zzjfh};
    public static final String MESSAGE_NAMESPACE_RESERVED = "__reserved_namespace";
    public static final String MESSAGE_TYPE_EDDYSTONE_UID = "__eddystone_uid";
    public static final String MESSAGE_TYPE_I_BEACON_ID = "__i_beacon_id";
    public static final String MESSAGE_TYPE_AUDIO_BYTES = "__audio_bytes";
    private int versionCode;
    private final byte[] content;
    private final String type;
    private final String zzjdp;
    @Deprecated
    private zzclm[] zzjdq;
    private final long zzjdr;

    Message(int n, @Nullable byte[] byArray, @Nullable String string, String string2, @Nullable zzclm[] zzclmArray, long l) {
        this.versionCode = n;
        this.type = (String)zzbp.zzu((Object)string2);
        this.zzjdp = string == null ? "" : string;
        this.zzjdr = 0L;
        zzbp.zzu((Object)byArray);
        zzbp.zzb((byArray.length <= 102400 ? 1 : 0) != 0, (String)"Content length(%d) must not exceed MAX_CONTENT_SIZE_BYTES(%d)", (Object[])new Object[]{byArray.length, 102400});
        this.content = byArray;
        if (zzclmArray == null || zzclmArray.length == 0) {
            zzclmArray = zzjdo;
        }
        this.zzjdq = zzclmArray;
        zzbp.zzb((string2.length() <= 32 ? 1 : 0) != 0, (String)"Type length(%d) must not exceed MAX_TYPE_LENGTH(%d)", (Object[])new Object[]{string2.length(), 32});
    }

    public final boolean zzkj(String string) {
        Message message = this;
        return MESSAGE_NAMESPACE_RESERVED.equals(message.getNamespace()) && string.equals(this.getType());
    }

    public Message(byte[] byArray) {
        this(byArray, "", "");
    }

    public Message(byte[] byArray, String string) {
        this(byArray, "", string);
    }

    public Message(byte[] byArray, String string, String string2) {
        this(byArray, string, string2, zzjdo);
    }

    private Message(byte[] byArray, String string, String string2, zzclm[] zzclmArray) {
        this(byArray, string, string2, zzclmArray, 0L);
    }

    private Message(byte[] byArray, String string, String string2, zzclm[] zzclmArray, long l) {
        this(2, byArray, string, string2, zzclmArray, 0L);
    }

    public String getType() {
        return this.type;
    }

    public String getNamespace() {
        return this.zzjdp;
    }

    public byte[] getContent() {
        return this.content;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Message message = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (byte[])message.getContent(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)2, (String)message.getType(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (String)message.getNamespace(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)4, (Parcelable[])message.zzjdq, (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)5, (long)0L);
        zzd.zzc((Parcel)parcel2, (int)1000, (int)message.versionCode);
        zzd.zzai((Parcel)parcel2, (int)n2);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzjdp, this.type, Arrays.hashCode(this.content), 0L});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Message)) {
            return false;
        }
        Message message = (Message)((Object)object);
        return TextUtils.equals((CharSequence)this.zzjdp, (CharSequence)message.zzjdp) && TextUtils.equals((CharSequence)this.type, (CharSequence)message.type) && Arrays.equals(this.content, message.content) && 0L == 0L;
    }

    public String toString() {
        String string = this.zzjdp;
        String string2 = this.type;
        int n = this.content == null ? 0 : this.content.length;
        return new StringBuilder(59 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Message{namespace='").append(string).append("', type='").append(string2).append("', content=[").append(n).append(" bytes]}").toString();
    }
}

