/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzbcc;
import com.google.android.gms.internal.zzbcf;
import com.google.android.gms.internal.zzclq;
import com.google.android.gms.internal.zzclu;
import com.google.android.gms.nearby.messages.internal.zzad;
import com.google.android.gms.nearby.messages.zzb;
import com.google.android.gms.nearby.messages.zzc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class MessageFilter
extends zzbcc {
    public static final Parcelable.Creator<MessageFilter> CREATOR = new zzc();
    public static final MessageFilter INCLUDE_ALL_MY_TYPES = new Builder().includeAllMyTypes().build();
    private int zzdxt;
    private final List<zzad> zzjds;
    private final List<zzclu> zzjdt;
    private final boolean zzjdu;
    private final List<zzclq> zzjdv;
    private final int zzjdw;

    MessageFilter(int n, List<zzad> list, List<zzclu> list2, boolean bl, List<zzclq> list3, int n2) {
        this.zzdxt = n;
        this.zzjds = Collections.unmodifiableList((List)zzbp.zzu(list));
        this.zzjdu = bl;
        if (list2 == null) {
            list2 = Collections.emptyList();
        }
        this.zzjdt = Collections.unmodifiableList(list2);
        if (list3 == null) {
            list3 = Collections.emptyList();
        }
        this.zzjdv = Collections.unmodifiableList(list3);
        this.zzjdw = n2;
    }

    private MessageFilter(List<zzad> list, List<zzclu> list2, boolean bl, List<zzclq> list3, int n) {
        this(2, list, list2, bl, list3, n);
    }

    public final List<zzad> zzbau() {
        return this.zzjds;
    }

    public final boolean zzbav() {
        return this.zzjdu;
    }

    final List<zzclu> zzbaw() {
        return this.zzjdt;
    }

    public final List<zzclq> zzbax() {
        return this.zzjdv;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        MessageFilter messageFilter = this;
        int n2 = zzbcf.zze((Parcel)parcel2);
        zzbcf.zzc((Parcel)parcel2, (int)1, messageFilter.zzjds, (boolean)false);
        zzbcf.zzc((Parcel)parcel2, (int)2, messageFilter.zzjdt, (boolean)false);
        zzbcf.zza((Parcel)parcel2, (int)3, (boolean)messageFilter.zzjdu);
        zzbcf.zzc((Parcel)parcel2, (int)4, messageFilter.zzjdv, (boolean)false);
        zzbcf.zzc((Parcel)parcel2, (int)5, (int)messageFilter.zzjdw);
        zzbcf.zzc((Parcel)parcel2, (int)1000, (int)messageFilter.zzdxt);
        zzbcf.zzai((Parcel)parcel2, (int)n2);
    }

    public String toString() {
        boolean bl = this.zzjdu;
        String string = String.valueOf(this.zzjds);
        return new StringBuilder(53 + String.valueOf(string).length()).append("MessageFilter{includeAllMyTypes=").append(bl).append(", messageTypes=").append(string).append("}").toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MessageFilter)) {
            return false;
        }
        MessageFilter messageFilter = (MessageFilter)((Object)object);
        return this.zzjdu == messageFilter.zzjdu && zzbf.equal(this.zzjds, messageFilter.zzjds) && zzbf.equal(this.zzjdt, messageFilter.zzjdt) && zzbf.equal(this.zzjdv, messageFilter.zzjdv);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzjds, this.zzjdt, this.zzjdu, this.zzjdv});
    }

    /* synthetic */ MessageFilter(List list, List list2, boolean bl, List list3, int n, zzb zzb2) {
        this(list, list2, bl, list3, n);
    }

    public static final class Builder {
        private final Set<zzad> zzjdx = new HashSet<zzad>();
        private final List<zzclu> zzjdt = new ArrayList<zzclu>();
        private final Set<zzclq> zzjdy = new HashSet<zzclq>();
        private boolean zzjdu;
        private int zzjdw = 0;

        public Builder() {
        }

        public final Builder includeAllMyTypes() {
            this.zzjdu = true;
            return this;
        }

        public final Builder includeNamespacedType(String string, String string2) {
            zzbp.zzb((string != null && !string.isEmpty() && !string.contains("*") ? 1 : 0) != 0, (String)"namespace(%s) cannot be null, empty or contain (*).", (Object[])new Object[]{string});
            zzbp.zzb((string2 != null && !string2.contains("*") ? 1 : 0) != 0, (String)"type(%s) cannot be null or contain (*).", (Object[])new Object[]{string2});
            return this.zzav(string, string2);
        }

        public final Builder includeFilter(MessageFilter messageFilter) {
            this.zzjdx.addAll(messageFilter.zzbau());
            this.zzjdt.addAll(messageFilter.zzbaw());
            this.zzjdy.addAll(messageFilter.zzbax());
            this.zzjdu |= messageFilter.zzbav();
            return this;
        }

        public final Builder includeEddystoneUids(String string, @Nullable String string2) {
            this.zzav("__reserved_namespace", "__eddystone_uid");
            this.zzjdt.add(zzclu.zzaw(string, string2));
            return this;
        }

        public final Builder includeIBeaconIds(UUID uUID, @Nullable Short s, @Nullable Short s2) {
            this.zzav("__reserved_namespace", "__i_beacon_id");
            this.zzjdt.add(zzclu.zza(uUID, s, s2));
            return this;
        }

        public final Builder includeAudioBytes(int n) {
            zzbp.zzb((this.zzjdw == 0 ? 1 : 0) != 0, (Object)"includeAudioBytes() can only be called once per MessageFilter instance.");
            zzbp.zzb((n > 0 ? 1 : 0) != 0, (Object)new StringBuilder(44).append("Invalid value for numAudioBytes: ").append(n).toString());
            zzbp.zzb((n <= 10 ? 1 : 0) != 0, (Object)"numAudioBytes is capped by AudioBytes.MAX_SIZE = 10");
            this.zzav("__reserved_namespace", "__audio_bytes");
            this.zzjdw = n;
            return this;
        }

        private final Builder zzav(String string, String string2) {
            this.zzjdx.add(new zzad(string, string2));
            return this;
        }

        public final MessageFilter build() {
            zzbp.zza((this.zzjdu || !this.zzjdx.isEmpty() ? 1 : 0) != 0, (Object)"At least one of the include methods must be called.");
            return new MessageFilter(new ArrayList<zzad>(this.zzjdx), this.zzjdt, this.zzjdu, new ArrayList<zzclq>(this.zzjdy), this.zzjdw, null);
        }
    }
}

