/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzbcc;
import com.google.android.gms.internal.zzbcf;
import com.google.android.gms.nearby.messages.zzg;
import java.util.ArrayList;

public class Strategy
extends zzbcc {
    public static final Parcelable.Creator<Strategy> CREATOR = new zzg();
    public static final int DISCOVERY_MODE_BROADCAST = 1;
    public static final int DISCOVERY_MODE_SCAN = 2;
    public static final int DISCOVERY_MODE_DEFAULT = 3;
    public static final int DISTANCE_TYPE_DEFAULT = 0;
    public static final int DISTANCE_TYPE_EARSHOT = 1;
    public static final int TTL_SECONDS_DEFAULT = 300;
    public static final int TTL_SECONDS_MAX = 86400;
    public static final int TTL_SECONDS_INFINITE = Integer.MAX_VALUE;
    public static final Strategy DEFAULT = new Builder().build();
    public static final Strategy BLE_ONLY;
    @Deprecated
    private static Strategy zzjeg;
    private int zzdxt;
    @Deprecated
    private int zzjeh;
    private int zzjei;
    private int zzjej;
    @Deprecated
    private boolean zzjek;
    private int zzjel;
    private int zzjem;
    private final int zzjen;

    Strategy(int n, int n2, int n3, int n4, boolean bl, int n5, int n6, int n7) {
        this.zzdxt = n;
        this.zzjeh = n2;
        if (n2 == 0) {
            this.zzjem = n6;
        } else {
            switch (n2) {
                case 2: {
                    this.zzjem = 1;
                    break;
                }
                case 3: {
                    this.zzjem = 2;
                    break;
                }
                default: {
                    this.zzjem = 3;
                }
            }
        }
        this.zzjej = n4;
        this.zzjek = bl;
        if (bl) {
            this.zzjel = 2;
            this.zzjei = Integer.MAX_VALUE;
        } else {
            this.zzjei = n3;
            switch (n5) {
                case -1: 
                case 0: 
                case 1: 
                case 6: {
                    this.zzjel = -1;
                    break;
                }
                default: {
                    this.zzjel = n5;
                }
            }
        }
        this.zzjen = n7;
    }

    public final int zzbay() {
        return this.zzjen;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Strategy strategy = this;
        int n2 = zzbcf.zze((Parcel)parcel2);
        zzbcf.zzc((Parcel)parcel2, (int)1, (int)strategy.zzjeh);
        zzbcf.zzc((Parcel)parcel2, (int)2, (int)strategy.zzjei);
        zzbcf.zzc((Parcel)parcel2, (int)3, (int)strategy.zzjej);
        zzbcf.zza((Parcel)parcel2, (int)4, (boolean)strategy.zzjek);
        zzbcf.zzc((Parcel)parcel2, (int)5, (int)strategy.zzjel);
        zzbcf.zzc((Parcel)parcel2, (int)6, (int)strategy.zzjem);
        zzbcf.zzc((Parcel)parcel2, (int)7, (int)strategy.zzjen);
        zzbcf.zzc((Parcel)parcel2, (int)1000, (int)strategy.zzdxt);
        zzbcf.zzai((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Strategy)) {
            return false;
        }
        Strategy strategy = (Strategy)((Object)object);
        return this.zzdxt == strategy.zzdxt && this.zzjem == strategy.zzjem && this.zzjei == strategy.zzjei && this.zzjej == strategy.zzjej && this.zzjel == strategy.zzjel;
    }

    public int hashCode() {
        int n = this.zzdxt;
        n = n * 31 + this.zzjem;
        n = n * 31 + this.zzjei;
        n = n * 31 + this.zzjej;
        return n * 31 + this.zzjel;
    }

    public String toString() {
        String string;
        String string2;
        ArrayList<String> arrayList;
        String string3;
        String string4;
        int n = this.zzjei;
        int n2 = this.zzjej;
        switch (n2) {
            case 0: {
                string4 = "DEFAULT";
                break;
            }
            case 1: {
                string4 = "EARSHOT";
                break;
            }
            default: {
                string4 = new StringBuilder(19).append("UNKNOWN:").append(n2).toString();
            }
        }
        String string5 = string4;
        n2 = this.zzjel;
        if (n2 == -1) {
            string3 = "DEFAULT";
        } else {
            arrayList = new ArrayList<String>();
            if ((n2 & 4) > 0) {
                arrayList.add("ULTRASOUND");
            }
            if ((n2 & 2) > 0) {
                arrayList.add("BLE");
            }
            string3 = arrayList.isEmpty() ? new StringBuilder(19).append("UNKNOWN:").append(n2).toString() : ((Object)arrayList).toString();
        }
        String string6 = string3;
        n2 = this.zzjem;
        if (n2 == 3) {
            string2 = "DEFAULT";
        } else {
            arrayList = new ArrayList();
            if ((n2 & 1) > 0) {
                arrayList.add("BROADCAST");
            }
            if ((n2 & 2) > 0) {
                arrayList.add("SCAN");
            }
            string2 = arrayList.isEmpty() ? new StringBuilder(19).append("UNKNOWN:").append(n2).toString() : ((Object)arrayList).toString();
        }
        String string7 = string2;
        n2 = this.zzjen;
        switch (n2) {
            case 0: {
                string = "DEFAULT";
                break;
            }
            case 1: {
                string = "ALWAYS_ON";
                break;
            }
            default: {
                string = new StringBuilder(20).append("UNKNOWN: ").append(n2).toString();
            }
        }
        String string8 = string;
        return new StringBuilder(102 + String.valueOf(string5).length() + String.valueOf(string6).length() + String.valueOf(string7).length() + String.valueOf(string8).length()).append("Strategy{ttlSeconds=").append(n).append(", distanceType=").append(string5).append(", discoveryMedium=").append(string6).append(", discoveryMode=").append(string7).append(", backgroundScanMode=").append(string8).append("}").toString();
    }

    static {
        zzjeg = BLE_ONLY = new Builder().zzdx(2).setTtlSeconds(Integer.MAX_VALUE).build();
    }

    public static class Builder {
        private int zzjeo = 3;
        private int zzjep = 300;
        private int zzjeq = 0;
        private int zzjer = -1;
        private int zzjes = 0;

        public Builder() {
        }

        public Builder setDiscoveryMode(int n) {
            this.zzjeo = n;
            return this;
        }

        public final Builder zzdx(int n) {
            this.zzjer = 2;
            return this;
        }

        public Builder setTtlSeconds(int n) {
            zzbp.zzb((n == Integer.MAX_VALUE || n > 0 && n <= 86400 ? 1 : 0) != 0, (String)"mTtlSeconds(%d) must either be TTL_SECONDS_INFINITE, or it must be between 1 and TTL_SECONDS_MAX(%d) inclusive", (Object[])new Object[]{n, 86400});
            this.zzjep = n;
            return this;
        }

        public Builder setDistanceType(int n) {
            this.zzjeq = n;
            return this;
        }

        public Strategy build() {
            if (this.zzjer == 2 && this.zzjeq == 1) {
                throw new IllegalStateException("Cannot set EARSHOT with BLE only mode.");
            }
            return new Strategy(2, 0, this.zzjep, this.zzjeq, false, this.zzjer, this.zzjeo, 0);
        }
    }
}

