/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbcn;
import com.google.android.gms.internal.zzclv;
import com.google.android.gms.internal.zzclz;
import com.google.android.gms.nearby.messages.internal.zzad;
import com.google.android.gms.nearby.messages.zzb;
import com.google.android.gms.nearby.messages.zzc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class MessageFilter
extends zzbck {
    public static final Parcelable.Creator<MessageFilter> CREATOR = new zzc();
    public static final MessageFilter INCLUDE_ALL_MY_TYPES = new Builder().includeAllMyTypes().build();
    private int zzdxr;
    private final List<zzad> zzjeb;
    private final List<zzclz> zzjec;
    private final boolean zzjed;
    private final List<zzclv> zzjee;
    private final int zzjef;

    MessageFilter(int n, List<zzad> list, List<zzclz> list2, boolean bl, List<zzclv> list3, int n2) {
        this.zzdxr = n;
        this.zzjeb = Collections.unmodifiableList((List)zzbp.zzu(list));
        this.zzjed = bl;
        if (list2 == null) {
            list2 = Collections.emptyList();
        }
        this.zzjec = Collections.unmodifiableList(list2);
        if (list3 == null) {
            list3 = Collections.emptyList();
        }
        this.zzjee = Collections.unmodifiableList(list3);
        this.zzjef = n2;
    }

    private MessageFilter(List<zzad> list, List<zzclz> list2, boolean bl, List<zzclv> list3, int n) {
        this(2, list, list2, bl, list3, n);
    }

    public final List<zzad> zzbax() {
        return this.zzjeb;
    }

    public final boolean zzbay() {
        return this.zzjed;
    }

    final List<zzclz> zzbaz() {
        return this.zzjec;
    }

    public final List<zzclv> zzbba() {
        return this.zzjee;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        MessageFilter messageFilter = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zzc((Parcel)parcel2, (int)1, messageFilter.zzjeb, (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)2, messageFilter.zzjec, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)3, (boolean)messageFilter.zzjed);
        zzbcn.zzc((Parcel)parcel2, (int)4, messageFilter.zzjee, (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)5, (int)messageFilter.zzjef);
        zzbcn.zzc((Parcel)parcel2, (int)1000, (int)messageFilter.zzdxr);
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }

    public String toString() {
        boolean bl = this.zzjed;
        String string = String.valueOf(this.zzjeb);
        return new StringBuilder(53 + String.valueOf(string).length()).append("MessageFilter{includeAllMyTypes=").append(bl).append(", messageTypes=").append(string).append("}").toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MessageFilter)) {
            return false;
        }
        MessageFilter messageFilter = (MessageFilter)((Object)object);
        return this.zzjed == messageFilter.zzjed && zzbf.equal(this.zzjeb, messageFilter.zzjeb) && zzbf.equal(this.zzjec, messageFilter.zzjec) && zzbf.equal(this.zzjee, messageFilter.zzjee);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzjeb, this.zzjec, this.zzjed, this.zzjee});
    }

    /* synthetic */ MessageFilter(List list, List list2, boolean bl, List list3, int n, zzb zzb2) {
        this(list, list2, bl, list3, n);
    }

    public static final class Builder {
        private final Set<zzad> zzjeg = new HashSet<zzad>();
        private final List<zzclz> zzjec = new ArrayList<zzclz>();
        private final Set<zzclv> zzjeh = new HashSet<zzclv>();
        private boolean zzjed;
        private int zzjef = 0;

        public Builder() {
        }

        public final Builder includeAllMyTypes() {
            this.zzjed = true;
            return this;
        }

        public final Builder includeNamespacedType(String string, String string2) {
            zzbp.zzb((string != null && !string.isEmpty() && !string.contains("*") ? 1 : 0) != 0, (String)"namespace(%s) cannot be null, empty or contain (*).", (Object[])new Object[]{string});
            zzbp.zzb((string2 != null && !string2.contains("*") ? 1 : 0) != 0, (String)"type(%s) cannot be null or contain (*).", (Object[])new Object[]{string2});
            return this.zzat(string, string2);
        }

        public final Builder includeFilter(MessageFilter messageFilter) {
            this.zzjeg.addAll(messageFilter.zzbax());
            this.zzjec.addAll(messageFilter.zzbaz());
            this.zzjeh.addAll(messageFilter.zzbba());
            this.zzjed |= messageFilter.zzbay();
            return this;
        }

        public final Builder includeEddystoneUids(String string, @Nullable String string2) {
            this.zzat("__reserved_namespace", "__eddystone_uid");
            this.zzjec.add(zzclz.zzau(string, string2));
            return this;
        }

        public final Builder includeIBeaconIds(UUID uUID, @Nullable Short s, @Nullable Short s2) {
            this.zzat("__reserved_namespace", "__i_beacon_id");
            this.zzjec.add(zzclz.zza(uUID, s, s2));
            return this;
        }

        public final Builder includeAudioBytes(int n) {
            zzbp.zzb((this.zzjef == 0 ? 1 : 0) != 0, (Object)"includeAudioBytes() can only be called once per MessageFilter instance.");
            zzbp.zzb((n > 0 ? 1 : 0) != 0, (Object)new StringBuilder(44).append("Invalid value for numAudioBytes: ").append(n).toString());
            zzbp.zzb((n <= 10 ? 1 : 0) != 0, (Object)"numAudioBytes is capped by AudioBytes.MAX_SIZE = 10");
            this.zzat("__reserved_namespace", "__audio_bytes");
            this.zzjef = n;
            return this;
        }

        private final Builder zzat(String string, String string2) {
            this.zzjeg.add(new zzad(string, string2));
            return this;
        }

        public final MessageFilter build() {
            zzbp.zza((this.zzjed || !this.zzjeg.isEmpty() ? 1 : 0) != 0, (Object)"At least one of the include methods must be called.");
            return new MessageFilter(new ArrayList<zzad>(this.zzjeg), this.zzjec, this.zzjed, new ArrayList<zzclv>(this.zzjeh), this.zzjef, null);
        }
    }
}

