/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbcn;
import com.google.android.gms.nearby.messages.zzg;
import java.util.ArrayList;

public class Strategy
extends zzbck {
    public static final Parcelable.Creator<Strategy> CREATOR = new zzg();
    public static final int DISCOVERY_MODE_BROADCAST = 1;
    public static final int DISCOVERY_MODE_SCAN = 2;
    public static final int DISCOVERY_MODE_DEFAULT = 3;
    public static final int DISTANCE_TYPE_DEFAULT = 0;
    public static final int DISTANCE_TYPE_EARSHOT = 1;
    public static final int TTL_SECONDS_DEFAULT = 300;
    public static final int TTL_SECONDS_MAX = 86400;
    public static final int TTL_SECONDS_INFINITE = Integer.MAX_VALUE;
    public static final Strategy DEFAULT = new Builder().build();
    public static final Strategy BLE_ONLY;
    @Deprecated
    private static Strategy zzjep;
    private int zzdxr;
    @Deprecated
    private int zzjeq;
    private int zzjer;
    private int zzjes;
    @Deprecated
    private boolean zzjet;
    private int zzjeu;
    private int zzjev;
    private final int zzjew;

    Strategy(int n, int n2, int n3, int n4, boolean bl, int n5, int n6, int n7) {
        this.zzdxr = n;
        this.zzjeq = n2;
        if (n2 == 0) {
            this.zzjev = n6;
        } else {
            switch (n2) {
                case 2: {
                    this.zzjev = 1;
                    break;
                }
                case 3: {
                    this.zzjev = 2;
                    break;
                }
                default: {
                    this.zzjev = 3;
                }
            }
        }
        this.zzjes = n4;
        this.zzjet = bl;
        if (bl) {
            this.zzjeu = 2;
            this.zzjer = Integer.MAX_VALUE;
        } else {
            this.zzjer = n3;
            switch (n5) {
                case -1: 
                case 0: 
                case 1: 
                case 6: {
                    this.zzjeu = -1;
                    break;
                }
                default: {
                    this.zzjeu = n5;
                }
            }
        }
        this.zzjew = n7;
    }

    public final int zzbbb() {
        return this.zzjew;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Strategy strategy = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zzc((Parcel)parcel2, (int)1, (int)strategy.zzjeq);
        zzbcn.zzc((Parcel)parcel2, (int)2, (int)strategy.zzjer);
        zzbcn.zzc((Parcel)parcel2, (int)3, (int)strategy.zzjes);
        zzbcn.zza((Parcel)parcel2, (int)4, (boolean)strategy.zzjet);
        zzbcn.zzc((Parcel)parcel2, (int)5, (int)strategy.zzjeu);
        zzbcn.zzc((Parcel)parcel2, (int)6, (int)strategy.zzjev);
        zzbcn.zzc((Parcel)parcel2, (int)7, (int)strategy.zzjew);
        zzbcn.zzc((Parcel)parcel2, (int)1000, (int)strategy.zzdxr);
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Strategy)) {
            return false;
        }
        Strategy strategy = (Strategy)((Object)object);
        return this.zzdxr == strategy.zzdxr && this.zzjev == strategy.zzjev && this.zzjer == strategy.zzjer && this.zzjes == strategy.zzjes && this.zzjeu == strategy.zzjeu && this.zzjew == strategy.zzjew;
    }

    public int hashCode() {
        int n = this.zzdxr;
        n = n * 31 + this.zzjev;
        n = n * 31 + this.zzjer;
        n = n * 31 + this.zzjes;
        n = n * 31 + this.zzjeu;
        return n * 31 + this.zzjew;
    }

    public String toString() {
        String string;
        String string2;
        ArrayList<String> arrayList;
        String string3;
        String string4;
        int n = this.zzjer;
        int n2 = this.zzjes;
        switch (n2) {
            case 0: {
                string4 = "DEFAULT";
                break;
            }
            case 1: {
                string4 = "EARSHOT";
                break;
            }
            default: {
                string4 = new StringBuilder(19).append("UNKNOWN:").append(n2).toString();
            }
        }
        String string5 = string4;
        n2 = this.zzjeu;
        if (n2 == -1) {
            string3 = "DEFAULT";
        } else {
            arrayList = new ArrayList<String>();
            if ((n2 & 4) > 0) {
                arrayList.add("ULTRASOUND");
            }
            if ((n2 & 2) > 0) {
                arrayList.add("BLE");
            }
            string3 = arrayList.isEmpty() ? new StringBuilder(19).append("UNKNOWN:").append(n2).toString() : ((Object)arrayList).toString();
        }
        String string6 = string3;
        n2 = this.zzjev;
        if (n2 == 3) {
            string2 = "DEFAULT";
        } else {
            arrayList = new ArrayList();
            if ((n2 & 1) > 0) {
                arrayList.add("BROADCAST");
            }
            if ((n2 & 2) > 0) {
                arrayList.add("SCAN");
            }
            string2 = arrayList.isEmpty() ? new StringBuilder(19).append("UNKNOWN:").append(n2).toString() : ((Object)arrayList).toString();
        }
        String string7 = string2;
        n2 = this.zzjew;
        switch (n2) {
            case 0: {
                string = "DEFAULT";
                break;
            }
            case 1: {
                string = "ALWAYS_ON";
                break;
            }
            default: {
                string = new StringBuilder(20).append("UNKNOWN: ").append(n2).toString();
            }
        }
        String string8 = string;
        return new StringBuilder(102 + String.valueOf(string5).length() + String.valueOf(string6).length() + String.valueOf(string7).length() + String.valueOf(string8).length()).append("Strategy{ttlSeconds=").append(n).append(", distanceType=").append(string5).append(", discoveryMedium=").append(string6).append(", discoveryMode=").append(string7).append(", backgroundScanMode=").append(string8).append("}").toString();
    }

    static {
        zzjep = BLE_ONLY = new Builder().zzdy(2).setTtlSeconds(Integer.MAX_VALUE).build();
    }

    public static class Builder {
        private int zzjex = 3;
        private int zzjey = 300;
        private int zzjez = 0;
        private int zzjfa = -1;
        private int zzjfb = 0;

        public Builder() {
        }

        public Builder setDiscoveryMode(int n) {
            this.zzjex = n;
            return this;
        }

        public final Builder zzdy(int n) {
            this.zzjfa = 2;
            return this;
        }

        public Builder setTtlSeconds(int n) {
            zzbp.zzb((n == Integer.MAX_VALUE || n > 0 && n <= 86400 ? 1 : 0) != 0, (String)"mTtlSeconds(%d) must either be TTL_SECONDS_INFINITE, or it must be between 1 and TTL_SECONDS_MAX(%d) inclusive", (Object[])new Object[]{n, 86400});
            this.zzjey = n;
            return this;
        }

        public Builder setDistanceType(int n) {
            this.zzjez = n;
            return this;
        }

        public Strategy build() {
            if (this.zzjfa == 2 && this.zzjez == 1) {
                throw new IllegalStateException("Cannot set EARSHOT with BLE only mode.");
            }
            return new Strategy(2, 0, this.zzjey, this.zzjez, false, this.zzjfa, this.zzjex, 0);
        }
    }
}

