/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages.internal;

import android.app.PendingIntent;
import android.content.Intent;
import android.os.Bundle;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzcj;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzclx;
import com.google.android.gms.nearby.messages.Message;
import com.google.android.gms.nearby.messages.MessageListener;
import com.google.android.gms.nearby.messages.Messages;
import com.google.android.gms.nearby.messages.MessagesOptions;
import com.google.android.gms.nearby.messages.PublishCallback;
import com.google.android.gms.nearby.messages.PublishOptions;
import com.google.android.gms.nearby.messages.StatusCallback;
import com.google.android.gms.nearby.messages.SubscribeCallback;
import com.google.android.gms.nearby.messages.SubscribeOptions;
import com.google.android.gms.nearby.messages.internal.Update;
import com.google.android.gms.nearby.messages.internal.zzah;
import com.google.android.gms.nearby.messages.internal.zzal;
import com.google.android.gms.nearby.messages.internal.zzam;
import com.google.android.gms.nearby.messages.internal.zzan;
import com.google.android.gms.nearby.messages.internal.zzao;
import com.google.android.gms.nearby.messages.internal.zzap;
import com.google.android.gms.nearby.messages.internal.zzaq;
import com.google.android.gms.nearby.messages.internal.zzar;
import com.google.android.gms.nearby.messages.internal.zzas;
import com.google.android.gms.nearby.messages.internal.zzat;
import com.google.android.gms.nearby.messages.internal.zzau;
import com.google.android.gms.nearby.messages.internal.zzav;
import com.google.android.gms.nearby.messages.internal.zzay;
import java.util.Collections;

public final class zzak
implements Messages {
    public static final zzak zzjgm = new zzak();
    public static final Api.zzf<zzah> zzdwo = new Api.zzf();
    public static final Api.zza<zzah, MessagesOptions> zzdwp = new zzal();

    private zzak() {
    }

    @Override
    public final PendingResult<Status> publish(GoogleApiClient googleApiClient, Message message, PublishOptions publishOptions) {
        zzbp.zzu((Object)((Object)message));
        zzbp.zzu((Object)publishOptions);
        zzcj zzcj2 = publishOptions.getCallback() == null ? null : googleApiClient.zzp((Object)publishOptions.getCallback());
        zzav zzav2 = zzcj2 == null ? null : new zzav((zzcj<PublishCallback>)zzcj2);
        return googleApiClient.zze((zzm)new zzan(this, googleApiClient, message, zzav2, publishOptions));
    }

    @Override
    public final PendingResult<Status> publish(GoogleApiClient googleApiClient, Message message) {
        return this.publish(googleApiClient, message, PublishOptions.DEFAULT);
    }

    @Override
    public final PendingResult<Status> unpublish(GoogleApiClient googleApiClient, Message message) {
        zzbp.zzu((Object)((Object)message));
        return googleApiClient.zze((zzm)new zzao(this, googleApiClient, message));
    }

    @Override
    public final PendingResult<Status> subscribe(GoogleApiClient googleApiClient, MessageListener messageListener, SubscribeOptions subscribeOptions) {
        zzbp.zzu((Object)messageListener);
        zzbp.zzu((Object)subscribeOptions);
        zzbp.zzb((subscribeOptions.getStrategy().zzbbb() == 0 ? 1 : 0) != 0, (Object)"Strategy.setBackgroundScanMode() is only supported by background subscribe (the version which takes a PendingIntent).");
        zzcj zzcj2 = googleApiClient.zzp((Object)messageListener);
        zzcj zzcj3 = subscribeOptions.getCallback() == null ? null : googleApiClient.zzp((Object)subscribeOptions.getCallback());
        zzay zzay2 = zzcj3 == null ? null : new zzay((zzcj<SubscribeCallback>)zzcj3);
        return googleApiClient.zze((zzm)new zzap(this, googleApiClient, zzcj2, zzay2, subscribeOptions));
    }

    @Override
    public final PendingResult<Status> subscribe(GoogleApiClient googleApiClient, MessageListener messageListener) {
        return this.subscribe(googleApiClient, messageListener, SubscribeOptions.DEFAULT);
    }

    @Override
    public final PendingResult<Status> subscribe(GoogleApiClient googleApiClient, PendingIntent pendingIntent, SubscribeOptions subscribeOptions) {
        zzbp.zzu((Object)pendingIntent);
        zzbp.zzu((Object)subscribeOptions);
        zzcj zzcj2 = subscribeOptions.getCallback() == null ? null : googleApiClient.zzp((Object)subscribeOptions.getCallback());
        zzay zzay2 = zzcj2 == null ? null : new zzay((zzcj<SubscribeCallback>)zzcj2);
        return googleApiClient.zze((zzm)new zzaq(this, googleApiClient, pendingIntent, zzay2, subscribeOptions));
    }

    @Override
    public final PendingResult<Status> subscribe(GoogleApiClient googleApiClient, PendingIntent pendingIntent) {
        return this.subscribe(googleApiClient, pendingIntent, SubscribeOptions.DEFAULT);
    }

    @Override
    public final PendingResult<Status> unsubscribe(GoogleApiClient googleApiClient, MessageListener messageListener) {
        zzbp.zzu((Object)messageListener);
        zzcj zzcj2 = googleApiClient.zzp((Object)messageListener);
        return googleApiClient.zze((zzm)new zzar(this, googleApiClient, zzcj2));
    }

    @Override
    public final PendingResult<Status> unsubscribe(GoogleApiClient googleApiClient, PendingIntent pendingIntent) {
        zzbp.zzu((Object)pendingIntent);
        return googleApiClient.zze((zzm)new zzas(this, googleApiClient, pendingIntent));
    }

    @Override
    public final void handleIntent(Intent intent, MessageListener messageListener) {
        String string = "com.google.android.gms.nearby.messages.UPDATES";
        Bundle bundle = intent.getBundleExtra("com.google.android.gms.nearby.messages.UPDATES");
        zzak.zza(bundle == null ? Collections.emptyList() : bundle.getParcelableArrayList(string), messageListener);
    }

    public static void zza(Iterable<Update> iterable, MessageListener messageListener) {
        for (Update update : iterable) {
            if (update.zzea(1)) {
                messageListener.onFound(update.zzjgh);
            }
            if (update.zzea(2)) {
                messageListener.onLost(update.zzjgh);
            }
            if (update.zzea(4)) {
                messageListener.onDistanceChanged(update.zzjgh, update.zzjhi);
            }
            if (update.zzea(8)) {
                messageListener.onBleSignalChanged(update.zzjgh, update.zzjhj);
            }
            if (!update.zzea(16)) continue;
            Message cfr_ignored_0 = update.zzjgh;
            zzclx cfr_ignored_1 = update.zzjhk;
        }
    }

    @Override
    public final PendingResult<Status> getPermissionStatus(GoogleApiClient googleApiClient) {
        return googleApiClient.zze((zzm)new zzat(this, googleApiClient));
    }

    @Override
    public final PendingResult<Status> registerStatusCallback(GoogleApiClient googleApiClient, StatusCallback statusCallback) {
        zzbp.zzu((Object)statusCallback);
        zzcj zzcj2 = googleApiClient.zzp((Object)statusCallback);
        return googleApiClient.zze((zzm)new zzau(this, googleApiClient, zzcj2));
    }

    @Override
    public final PendingResult<Status> unregisterStatusCallback(GoogleApiClient googleApiClient, StatusCallback statusCallback) {
        zzbp.zzu((Object)statusCallback);
        zzcj zzcj2 = googleApiClient.zzp((Object)statusCallback);
        return googleApiClient.zze((zzm)new zzam(this, googleApiClient, zzcj2));
    }
}

