/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzcj;
import com.google.android.gms.common.api.internal.zzcl;
import com.google.android.gms.common.api.internal.zzn;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.internal.zzcmb;
import com.google.android.gms.internal.zzcmd;
import com.google.android.gms.internal.zzcmg;
import com.google.android.gms.internal.zzcmi;
import com.google.android.gms.nearby.messages.MessageListener;
import com.google.android.gms.nearby.messages.MessagesOptions;
import com.google.android.gms.nearby.messages.PublishOptions;
import com.google.android.gms.nearby.messages.StatusCallback;
import com.google.android.gms.nearby.messages.SubscribeOptions;
import com.google.android.gms.nearby.messages.internal.ClientAppContext;
import com.google.android.gms.nearby.messages.internal.SubscribeRequest;
import com.google.android.gms.nearby.messages.internal.zzab;
import com.google.android.gms.nearby.messages.internal.zzaf;
import com.google.android.gms.nearby.messages.internal.zzaj;
import com.google.android.gms.nearby.messages.internal.zzbb;
import com.google.android.gms.nearby.messages.internal.zzbd;
import com.google.android.gms.nearby.messages.internal.zzbg;
import com.google.android.gms.nearby.messages.internal.zzbi;
import com.google.android.gms.nearby.messages.internal.zzj;
import com.google.android.gms.nearby.messages.internal.zzs;
import com.google.android.gms.nearby.messages.internal.zzt;
import com.google.android.gms.nearby.messages.internal.zzv;

final class zzah
extends zzaa<zzs> {
    private final zzcmi<zzcl, IBinder> zzjgi = new zzcmi();
    private final ClientAppContext zzjgj;
    private final int zzjem;

    @TargetApi(value=14)
    zzah(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, zzq zzq2, MessagesOptions messagesOptions) {
        super(context, looper, 62, zzq2, connectionCallbacks, onConnectionFailedListener);
        int n;
        String string = zzq2.zzaju();
        Context context2 = context;
        int n2 = context2 instanceof Activity ? 1 : (context2 instanceof Application ? 2 : (n = context2 instanceof Service ? 3 : 0));
        if (messagesOptions != null) {
            this.zzjgj = new ClientAppContext(string, null, false, null, n);
            this.zzjem = messagesOptions.zzjek;
        } else {
            this.zzjgj = new ClientAppContext(string, null, false, null, n);
            this.zzjem = -1;
        }
        if (n == 1) {
            Activity activity = (Activity)context;
            Log.v((String)"NearbyMessagesClient", (String)String.format("Registering ClientLifecycleSafetyNet's ActivityLifecycleCallbacks for %s", activity.getPackageName()));
            activity.getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new zzaj(activity, this, null));
        }
    }

    @NonNull
    protected final Bundle zzzu() {
        Bundle bundle = super.zzzu();
        bundle.putInt("NearbyPermissions", this.zzjem);
        bundle.putParcelable("ClientAppContext", (Parcelable)this.zzjgj);
        return bundle;
    }

    @NonNull
    protected final String zzhc() {
        return "com.google.android.gms.nearby.messages.service.NearbyMessagesService.START";
    }

    @NonNull
    protected final String zzhd() {
        return "com.google.android.gms.nearby.messages.internal.INearbyMessagesService";
    }

    public final void disconnect() {
        try {
            this.zzdz(2);
        }
        catch (RemoteException remoteException) {
            Log.v((String)"NearbyMessagesClient", (String)String.format("Failed to emit CLIENT_DISCONNECTED from override of GmsClient#disconnect(): %s", new Object[]{remoteException}));
        }
        this.zzjgi.clear();
        super.disconnect();
    }

    final void zza(zzcj<zzn<Status>> zzcj2, zzaf zzaf2, @Nullable zzv zzv2, PublishOptions publishOptions) throws RemoteException {
        zzbb zzbb2 = new zzbb(zzaf2, publishOptions.getStrategy(), (IBinder)new zzcmd(zzcj2), (IBinder)zzv2, this.zzjgj.zzjgc);
        ((zzs)this.zzajj()).zza(zzbb2);
    }

    final void zza(zzcj<zzn<Status>> zzcj2, zzaf zzaf2) throws RemoteException {
        zzbg zzbg2 = new zzbg(zzaf2, (IBinder)new zzcmd(zzcj2), this.zzjgj);
        ((zzs)this.zzajj()).zza(zzbg2);
    }

    final void zza(zzcj<zzn<Status>> zzcj2, zzcj<MessageListener> zzcj3, @Nullable zzab zzab2, SubscribeOptions subscribeOptions, @Nullable byte[] byArray) throws RemoteException {
        if (!this.zzjgi.containsKey(zzcj3.zzaik())) {
            this.zzjgi.zzf(zzcj3.zzaik(), (IBinder)new zzcmb(zzcj3));
        }
        SubscribeRequest subscribeRequest = new SubscribeRequest(this.zzjgi.get(zzcj3.zzaik()), subscribeOptions.getStrategy(), (IBinder)new zzcmd(zzcj2), subscribeOptions.getFilter(), null, null, (IBinder)zzab2, subscribeOptions.zzjfe, this.zzjgj.zzjgc);
        ((zzs)this.zzajj()).zza(subscribeRequest);
    }

    final void zza(zzcj<zzn<Status>> zzcj2, PendingIntent pendingIntent, @Nullable zzab zzab2, SubscribeOptions subscribeOptions) throws RemoteException {
        SubscribeRequest subscribeRequest = new SubscribeRequest(null, subscribeOptions.getStrategy(), (IBinder)new zzcmd(zzcj2), subscribeOptions.getFilter(), pendingIntent, null, (IBinder)zzab2, subscribeOptions.zzjfe, subscribeOptions.zzjff, this.zzjgj.zzjgc);
        ((zzs)this.zzajj()).zza(subscribeRequest);
    }

    final void zza(zzcj<zzn<Status>> zzcj2, zzcj<MessageListener> zzcj3) throws RemoteException {
        zzcmd zzcmd2 = new zzcmd(zzcj2);
        if (!this.zzjgi.containsKey(zzcj3.zzaik())) {
            zzcmd2.zzag(new Status(0));
            return;
        }
        zzbi zzbi2 = new zzbi(this.zzjgi.get(zzcj3.zzaik()), (IBinder)zzcmd2, null);
        ((zzs)this.zzajj()).zza(zzbi2);
        this.zzjgi.remove(zzcj3.zzaik());
    }

    final void zzb(zzcj<zzn<Status>> zzcj2, zzcj<StatusCallback> zzcj3) throws RemoteException {
        if (!this.zzjgi.containsKey(zzcj3.zzaik())) {
            this.zzjgi.zzf(zzcj3.zzaik(), (IBinder)new zzcmg(zzcj3));
        }
        zzbd zzbd2 = new zzbd((IBinder)new zzcmd(zzcj2), this.zzjgi.get(zzcj3.zzaik()));
        new zzbd((IBinder)new zzcmd(zzcj2), this.zzjgi.get(zzcj3.zzaik())).zzjhb = true;
        ((zzs)this.zzajj()).zza(zzbd2);
    }

    final void zzc(zzcj<zzn<Status>> zzcj2, zzcj<StatusCallback> zzcj3) throws RemoteException {
        zzcmd zzcmd2 = new zzcmd(zzcj2);
        if (!this.zzjgi.containsKey(zzcj3.zzaik())) {
            zzcmd2.zzag(new Status(0));
            return;
        }
        zzbd zzbd2 = new zzbd((IBinder)zzcmd2, this.zzjgi.get(zzcj3.zzaik()));
        new zzbd((IBinder)zzcmd2, this.zzjgi.get(zzcj3.zzaik())).zzjhb = false;
        ((zzs)this.zzajj()).zza(zzbd2);
        this.zzjgi.remove(zzcj3.zzaik());
    }

    final void zzdz(int n) throws RemoteException {
        String string;
        switch (n) {
            case 1: {
                string = "ACTIVITY_STOPPED";
                break;
            }
            case 2: {
                string = "CLIENT_DISCONNECTED";
                break;
            }
            default: {
                Log.w((String)"NearbyMessagesClient", (String)String.format("Received unknown/unforeseen client lifecycle event %d, can't do anything with it.", n));
                return;
            }
        }
        if (this.isConnected()) {
            zzj zzj2 = new zzj(n);
            Log.d((String)"NearbyMessagesClient", (String)String.format("Emitting client lifecycle event %s", string));
            ((zzs)this.zzajj()).zza(zzj2);
            return;
        }
        Log.d((String)"NearbyMessagesClient", (String)String.format("Failed to emit client lifecycle event %s due to GmsClient being disconnected", string));
    }

    protected final /* synthetic */ IInterface zzd(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.nearby.messages.internal.INearbyMessagesService");
        if (iInterface instanceof zzs) {
            return (zzs)iInterface;
        }
        return new zzt(iBinder2);
    }
}

