/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzcl;
import com.google.android.gms.common.api.internal.zzn;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.internal.zzclk;
import com.google.android.gms.internal.zzclm;
import com.google.android.gms.internal.zzclo;
import com.google.android.gms.internal.zzcls;
import com.google.android.gms.internal.zzcmd;
import com.google.android.gms.internal.zzcmo;
import com.google.android.gms.internal.zzcmr;
import com.google.android.gms.internal.zzcmt;
import com.google.android.gms.internal.zzcoq;
import com.google.android.gms.internal.zzcpj;
import com.google.android.gms.internal.zzcpk;
import com.google.android.gms.internal.zzcqu;
import com.google.android.gms.internal.zzcqw;
import com.google.android.gms.internal.zzcqy;
import com.google.android.gms.internal.zzcrb;
import com.google.android.gms.internal.zzcrd;
import com.google.android.gms.internal.zzcrf;
import com.google.android.gms.internal.zzcrh;
import com.google.android.gms.internal.zzcrj;
import com.google.android.gms.internal.zzcrl;
import com.google.android.gms.internal.zzcrn;
import com.google.android.gms.internal.zzcrp;
import com.google.android.gms.internal.zzee;
import com.google.android.gms.nearby.connection.AdvertisingOptions;
import com.google.android.gms.nearby.connection.ConnectionLifecycleCallback;
import com.google.android.gms.nearby.connection.Connections;
import com.google.android.gms.nearby.connection.ConnectionsStatusCodes;
import com.google.android.gms.nearby.connection.DiscoveryOptions;
import com.google.android.gms.nearby.connection.EndpointDiscoveryCallback;
import com.google.android.gms.nearby.connection.Payload;
import com.google.android.gms.nearby.connection.PayloadCallback;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class zzclq
extends zzab<zzcpj> {
    private final long zzjll;
    private final Set<zzcmd> zzjlm = new HashSet<zzcmd>();
    private final Set<zzcls> zzjln = new HashSet<zzcls>();
    private zzcqu zzjlo;

    public zzclq(Context context, Looper looper, zzr zzr2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 54, zzr2, connectionCallbacks, onConnectionFailedListener);
        this.zzjll = ((Object)((Object)this)).hashCode();
    }

    protected final Bundle zzaae() {
        Bundle bundle = new Bundle();
        bundle.putLong("clientId", this.zzjll);
        return bundle;
    }

    protected final String zzhf() {
        return "com.google.android.gms.nearby.connection.service.START";
    }

    protected final String zzhg() {
        return "com.google.android.gms.nearby.internal.connection.INearbyConnectionService";
    }

    public final void disconnect() {
        if (this.isConnected()) {
            try {
                ((zzcpj)this.zzakc()).zza(new zzclo());
            }
            catch (RemoteException remoteException) {
                Log.w((String)"NearbyConnectionsClient", (String)"Failed to notify client disconnect.", (Throwable)remoteException);
            }
        }
        this.reset();
        super.disconnect();
    }

    public final void onConnectionSuspended(int n) {
        if (n == 1) {
            this.reset();
        }
        super.onConnectionSuspended(n);
    }

    private final void reset() {
        Iterator<zzee> iterator = this.zzjlm.iterator();
        while (iterator.hasNext()) {
            iterator.next().shutdown();
        }
        iterator = this.zzjln.iterator();
        while (iterator.hasNext()) {
            ((zzcls)iterator.next()).shutdown();
        }
        this.zzjlm.clear();
        this.zzjln.clear();
        if (this.zzjlo != null) {
            this.zzjlo.shutdown();
            this.zzjlo = null;
        }
    }

    public final void zza(zzn<Connections.StartAdvertisingResult> zzn2, String string, String string2, zzcl<ConnectionLifecycleCallback> zzcl2, AdvertisingOptions advertisingOptions) throws RemoteException {
        zzcls zzcls2 = new zzcls(zzcl2);
        this.zzjln.add(zzcls2);
        ((zzcpj)this.zzakc()).zza(new zzcrh(new zzcmt(zzn2).asBinder(), null, string, string2, 0L, advertisingOptions, zzcls2.asBinder()));
    }

    public final void stopAdvertising() throws RemoteException {
        ((zzcpj)this.zzakc()).zza(new zzcrl());
    }

    public final void zza(zzn<Status> zzn2, String string, zzcl<EndpointDiscoveryCallback> zzcl2, DiscoveryOptions discoveryOptions) throws RemoteException {
        zzcmd zzcmd2 = new zzcmd(zzcl2);
        this.zzjlm.add(zzcmd2);
        ((zzcpj)this.zzakc()).zza(new zzcrj(new zzcmr(zzn2).asBinder(), null, string, 0L, discoveryOptions, zzcmd2.asBinder()));
    }

    public final void stopDiscovery() throws RemoteException {
        ((zzcpj)this.zzakc()).zza(new zzcrp());
    }

    public final void zza(zzn<Status> zzn2, @Nullable String string, String string2, zzcl<ConnectionLifecycleCallback> zzcl2) throws RemoteException {
        zzcls zzcls2 = new zzcls(zzcl2);
        this.zzjln.add(zzcls2);
        ((zzcpj)this.zzakc()).zza(new zzcrd(new zzcmr(zzn2).asBinder(), null, null, string, string2, null, zzcls2.asBinder()));
    }

    public final void zza(zzn<Status> zzn2, String string, zzcl<PayloadCallback> zzcl2) throws RemoteException {
        ((zzcpj)this.zzakc()).zza(new zzclk(new zzcmr(zzn2).asBinder(), null, string, null, new zzcmo(zzcl2).asBinder()));
    }

    public final void zzj(zzn<Status> zzn2, String string) throws RemoteException {
        ((zzcpj)this.zzakc()).zza(new zzcrb(new zzcmr(zzn2).asBinder(), string));
    }

    public final void zza(zzn<Status> zzn2, String[] stringArray, Payload payload, boolean bl) throws RemoteException {
        Pair<zzcqw, Pair<ParcelFileDescriptor, ParcelFileDescriptor>> pair;
        try {
            pair = zzcqy.zza(payload);
        }
        catch (IOException iOException) {
            zzn2.setResult((Object)zzclq.zzco(8013));
            return;
        }
        ((zzcpj)this.zzakc()).zza(new zzcrf(new zzcmr(zzn2).asBinder(), stringArray, (zzcqw)((Object)pair.first), bl));
        if (pair.second != null) {
            Pair pair2 = (Pair)pair.second;
            this.zzjlo.zza(payload.asStream().asInputStream(), (OutputStream)new ParcelFileDescriptor.AutoCloseOutputStream((ParcelFileDescriptor)pair2.first), (OutputStream)new ParcelFileDescriptor.AutoCloseOutputStream((ParcelFileDescriptor)pair2.second), payload.getId());
        }
    }

    public final void zza(zzn<Status> zzn2, long l) throws RemoteException {
        ((zzcpj)this.zzakc()).zza(new zzclm(new zzcmr(zzn2).asBinder(), l));
    }

    public final void disconnectFromEndpoint(String string) throws RemoteException {
        ((zzcpj)this.zzakc()).zza(new zzcoq(string));
    }

    public final void stopAllEndpoints() throws RemoteException {
        ((zzcpj)this.zzakc()).zza(new zzcrn());
    }

    private static Status zzco(int n) {
        return new Status(n, ConnectionsStatusCodes.getStatusCodeString(n));
    }

    protected final /* synthetic */ void zza(@NonNull IInterface iInterface) {
        zzcpj zzcpj2 = (zzcpj)iInterface;
        zzclq zzclq2 = this;
        super.zza((IInterface)zzcpj2);
        zzclq2.zzjlo = new zzcqu();
    }

    protected final /* synthetic */ IInterface zzd(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.nearby.internal.connection.INearbyConnectionService");
        if (iInterface instanceof zzcpj) {
            return (zzcpj)iInterface;
        }
        return new zzcpk(iBinder2);
    }

    static /* synthetic */ Status zzed(int n) {
        return zzclq.zzco(n);
    }
}

