/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.internal.zzbem;
import com.google.android.gms.nearby.messages.zzg;
import java.util.ArrayList;

public class Strategy
extends zzbej {
    public static final Parcelable.Creator<Strategy> CREATOR = new zzg();
    public static final int DISCOVERY_MODE_BROADCAST = 1;
    public static final int DISCOVERY_MODE_SCAN = 2;
    public static final int DISCOVERY_MODE_DEFAULT = 3;
    public static final int DISTANCE_TYPE_DEFAULT = 0;
    public static final int DISTANCE_TYPE_EARSHOT = 1;
    public static final int TTL_SECONDS_DEFAULT = 300;
    public static final int TTL_SECONDS_MAX = 86400;
    public static final int TTL_SECONDS_INFINITE = Integer.MAX_VALUE;
    public static final Strategy DEFAULT = new Builder().build();
    public static final Strategy BLE_ONLY;
    @Deprecated
    private static Strategy zzjpo;
    private int zzdzm;
    @Deprecated
    private int zzjpp;
    private int zzjpq;
    private int zzjpr;
    @Deprecated
    private boolean zzjps;
    private int zzjpt;
    private int zzjpu;
    private final int zzjpv;

    Strategy(int n, int n2, int n3, int n4, boolean bl, int n5, int n6, int n7) {
        this.zzdzm = n;
        this.zzjpp = n2;
        if (n2 == 0) {
            this.zzjpu = n6;
        } else {
            switch (n2) {
                case 2: {
                    this.zzjpu = 1;
                    break;
                }
                case 3: {
                    this.zzjpu = 2;
                    break;
                }
                default: {
                    this.zzjpu = 3;
                }
            }
        }
        this.zzjpr = n4;
        this.zzjps = bl;
        if (bl) {
            this.zzjpt = 2;
            this.zzjpq = Integer.MAX_VALUE;
        } else {
            this.zzjpq = n3;
            switch (n5) {
                case -1: 
                case 0: 
                case 1: 
                case 6: {
                    this.zzjpt = -1;
                    break;
                }
                default: {
                    this.zzjpt = n5;
                }
            }
        }
        this.zzjpv = n7;
    }

    public final int zzbbr() {
        return this.zzjpv;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Strategy strategy = this;
        int n2 = zzbem.zze((Parcel)parcel2);
        zzbem.zzc((Parcel)parcel2, (int)1, (int)strategy.zzjpp);
        zzbem.zzc((Parcel)parcel2, (int)2, (int)strategy.zzjpq);
        zzbem.zzc((Parcel)parcel2, (int)3, (int)strategy.zzjpr);
        zzbem.zza((Parcel)parcel2, (int)4, (boolean)strategy.zzjps);
        zzbem.zzc((Parcel)parcel2, (int)5, (int)strategy.zzjpt);
        zzbem.zzc((Parcel)parcel2, (int)6, (int)strategy.zzjpu);
        zzbem.zzc((Parcel)parcel2, (int)7, (int)strategy.zzjpv);
        zzbem.zzc((Parcel)parcel2, (int)1000, (int)strategy.zzdzm);
        zzbem.zzai((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Strategy)) {
            return false;
        }
        Strategy strategy = (Strategy)((Object)object);
        return this.zzdzm == strategy.zzdzm && this.zzjpu == strategy.zzjpu && this.zzjpq == strategy.zzjpq && this.zzjpr == strategy.zzjpr && this.zzjpt == strategy.zzjpt && this.zzjpv == strategy.zzjpv;
    }

    public int hashCode() {
        int n = this.zzdzm;
        n = n * 31 + this.zzjpu;
        n = n * 31 + this.zzjpq;
        n = n * 31 + this.zzjpr;
        n = n * 31 + this.zzjpt;
        return n * 31 + this.zzjpv;
    }

    public String toString() {
        String string;
        String string2;
        ArrayList<String> arrayList;
        String string3;
        String string4;
        int n = this.zzjpq;
        int n2 = this.zzjpr;
        switch (n2) {
            case 0: {
                string4 = "DEFAULT";
                break;
            }
            case 1: {
                string4 = "EARSHOT";
                break;
            }
            default: {
                string4 = new StringBuilder(19).append("UNKNOWN:").append(n2).toString();
            }
        }
        String string5 = string4;
        n2 = this.zzjpt;
        if (n2 == -1) {
            string3 = "DEFAULT";
        } else {
            arrayList = new ArrayList<String>();
            if ((n2 & 4) > 0) {
                arrayList.add("ULTRASOUND");
            }
            if ((n2 & 2) > 0) {
                arrayList.add("BLE");
            }
            string3 = arrayList.isEmpty() ? new StringBuilder(19).append("UNKNOWN:").append(n2).toString() : ((Object)arrayList).toString();
        }
        String string6 = string3;
        n2 = this.zzjpu;
        if (n2 == 3) {
            string2 = "DEFAULT";
        } else {
            arrayList = new ArrayList();
            if ((n2 & 1) > 0) {
                arrayList.add("BROADCAST");
            }
            if ((n2 & 2) > 0) {
                arrayList.add("SCAN");
            }
            string2 = arrayList.isEmpty() ? new StringBuilder(19).append("UNKNOWN:").append(n2).toString() : ((Object)arrayList).toString();
        }
        String string7 = string2;
        n2 = this.zzjpv;
        switch (n2) {
            case 0: {
                string = "DEFAULT";
                break;
            }
            case 1: {
                string = "ALWAYS_ON";
                break;
            }
            default: {
                string = new StringBuilder(20).append("UNKNOWN: ").append(n2).toString();
            }
        }
        String string8 = string;
        return new StringBuilder(102 + String.valueOf(string5).length() + String.valueOf(string6).length() + String.valueOf(string7).length() + String.valueOf(string8).length()).append("Strategy{ttlSeconds=").append(n).append(", distanceType=").append(string5).append(", discoveryMedium=").append(string6).append(", discoveryMode=").append(string7).append(", backgroundScanMode=").append(string8).append("}").toString();
    }

    static {
        zzjpo = BLE_ONLY = new Builder().zzef(2).setTtlSeconds(Integer.MAX_VALUE).build();
    }

    public static class Builder {
        private int zzjpw = 3;
        private int zzjpx = 300;
        private int zzjpy = 0;
        private int zzjpz = -1;
        private int zzjqa = 0;

        public Builder() {
        }

        public Builder setDiscoveryMode(int n) {
            this.zzjpw = n;
            return this;
        }

        public final Builder zzef(int n) {
            this.zzjpz = 2;
            return this;
        }

        public Builder setTtlSeconds(int n) {
            zzbq.zzb((n == Integer.MAX_VALUE || n > 0 && n <= 86400 ? 1 : 0) != 0, (String)"mTtlSeconds(%d) must either be TTL_SECONDS_INFINITE, or it must be between 1 and TTL_SECONDS_MAX(%d) inclusive", (Object[])new Object[]{n, 86400});
            this.zzjpx = n;
            return this;
        }

        public Builder setDistanceType(int n) {
            this.zzjpy = n;
            return this;
        }

        public Strategy build() {
            if (this.zzjpz == 2 && this.zzjpy == 1) {
                throw new IllegalStateException("Cannot set EARSHOT with BLE only mode.");
            }
            return new Strategy(2, 0, this.zzjpx, this.zzjpy, false, this.zzjpz, this.zzjpw, 0);
        }
    }
}

