/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.internal.zzbem;
import com.google.android.gms.internal.zzcrt;
import com.google.android.gms.nearby.messages.zza;
import java.util.Arrays;

public class Message
extends zzbej
implements ReflectedParcelable {
    public static final int MAX_CONTENT_SIZE_BYTES = 102400;
    public static final int MAX_TYPE_LENGTH = 32;
    public static final Parcelable.Creator<Message> CREATOR = new zza();
    private static final zzcrt[] zzjom = new zzcrt[]{zzcrt.zzjqf};
    public static final String MESSAGE_NAMESPACE_RESERVED = "__reserved_namespace";
    public static final String MESSAGE_TYPE_EDDYSTONE_UID = "__eddystone_uid";
    public static final String MESSAGE_TYPE_I_BEACON_ID = "__i_beacon_id";
    public static final String MESSAGE_TYPE_AUDIO_BYTES = "__audio_bytes";
    private int versionCode;
    private final byte[] content;
    private final String type;
    private final String zzjon;
    @Deprecated
    private zzcrt[] zzjoo;
    private final long zzjop;

    Message(int n, @Nullable byte[] byArray, @Nullable String string, String string2, @Nullable zzcrt[] zzcrtArray, long l) {
        this.versionCode = n;
        this.type = (String)zzbq.checkNotNull((Object)string2);
        this.zzjon = string == null ? "" : string;
        this.zzjop = 0L;
        zzbq.checkNotNull((Object)byArray);
        zzbq.zzb((byArray.length <= 102400 ? 1 : 0) != 0, (String)"Content length(%d) must not exceed MAX_CONTENT_SIZE_BYTES(%d)", (Object[])new Object[]{byArray.length, 102400});
        this.content = byArray;
        if (zzcrtArray == null || zzcrtArray.length == 0) {
            zzcrtArray = zzjom;
        }
        this.zzjoo = zzcrtArray;
        zzbq.zzb((string2.length() <= 32 ? 1 : 0) != 0, (String)"Type length(%d) must not exceed MAX_TYPE_LENGTH(%d)", (Object[])new Object[]{string2.length(), 32});
    }

    public final boolean zzkk(String string) {
        Message message = this;
        return MESSAGE_NAMESPACE_RESERVED.equals(message.getNamespace()) && string.equals(this.getType());
    }

    public Message(byte[] byArray) {
        this(byArray, "", "");
    }

    public Message(byte[] byArray, String string) {
        this(byArray, "", string);
    }

    public Message(byte[] byArray, String string, String string2) {
        this(byArray, string, string2, zzjom);
    }

    private Message(byte[] byArray, String string, String string2, zzcrt[] zzcrtArray) {
        this(byArray, string, string2, zzcrtArray, 0L);
    }

    private Message(byte[] byArray, String string, String string2, zzcrt[] zzcrtArray, long l) {
        this(2, byArray, string, string2, zzcrtArray, 0L);
    }

    public String getType() {
        return this.type;
    }

    public String getNamespace() {
        return this.zzjon;
    }

    public byte[] getContent() {
        return this.content;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Message message = this;
        int n2 = zzbem.zze((Parcel)parcel2);
        zzbem.zza((Parcel)parcel2, (int)1, (byte[])message.getContent(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)2, (String)message.getType(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)3, (String)message.getNamespace(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)4, (Parcelable[])message.zzjoo, (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)5, (long)0L);
        zzbem.zzc((Parcel)parcel2, (int)1000, (int)message.versionCode);
        zzbem.zzai((Parcel)parcel2, (int)n2);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzjon, this.type, Arrays.hashCode(this.content), 0L});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Message)) {
            return false;
        }
        Message message = (Message)((Object)object);
        return TextUtils.equals((CharSequence)this.zzjon, (CharSequence)message.zzjon) && TextUtils.equals((CharSequence)this.type, (CharSequence)message.type) && Arrays.equals(this.content, message.content) && 0L == 0L;
    }

    public String toString() {
        String string = this.zzjon;
        String string2 = this.type;
        int n = this.content == null ? 0 : this.content.length;
        return new StringBuilder(59 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Message{namespace='").append(string).append("', type='").append(string2).append("', content=[").append(n).append(" bytes]}").toString();
    }
}

