/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzcl;
import com.google.android.gms.common.api.internal.zzcn;
import com.google.android.gms.common.api.internal.zzn;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.internal.zzcrx;
import com.google.android.gms.internal.zzcrz;
import com.google.android.gms.internal.zzcsc;
import com.google.android.gms.internal.zzcse;
import com.google.android.gms.nearby.messages.MessageListener;
import com.google.android.gms.nearby.messages.MessagesOptions;
import com.google.android.gms.nearby.messages.PublishOptions;
import com.google.android.gms.nearby.messages.StatusCallback;
import com.google.android.gms.nearby.messages.SubscribeOptions;
import com.google.android.gms.nearby.messages.internal.ClientAppContext;
import com.google.android.gms.nearby.messages.internal.SubscribeRequest;
import com.google.android.gms.nearby.messages.internal.zzab;
import com.google.android.gms.nearby.messages.internal.zzaf;
import com.google.android.gms.nearby.messages.internal.zzaj;
import com.google.android.gms.nearby.messages.internal.zzbz;
import com.google.android.gms.nearby.messages.internal.zzcb;
import com.google.android.gms.nearby.messages.internal.zzce;
import com.google.android.gms.nearby.messages.internal.zzcg;
import com.google.android.gms.nearby.messages.internal.zzj;
import com.google.android.gms.nearby.messages.internal.zzs;
import com.google.android.gms.nearby.messages.internal.zzt;
import com.google.android.gms.nearby.messages.internal.zzv;

public final class zzah
extends com.google.android.gms.common.internal.zzab<zzs> {
    private final zzcse<zzcn, IBinder> zzjqx = new zzcse();
    private final ClientAppContext zzjqy;
    private final int zzjpb;

    static int zzdv(Context context) {
        if (context instanceof Activity) {
            return 1;
        }
        if (context instanceof Application) {
            return 2;
        }
        if (context instanceof Service) {
            return 3;
        }
        return 0;
    }

    @TargetApi(value=14)
    zzah(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, zzr zzr2, MessagesOptions messagesOptions) {
        super(context, looper, 62, zzr2, connectionCallbacks, onConnectionFailedListener);
        String string = zzr2.zzakm();
        int n = zzah.zzdv(context);
        if (messagesOptions != null) {
            this.zzjqy = new ClientAppContext(string, null, false, null, n);
            this.zzjpb = messagesOptions.zzjoz;
        } else {
            this.zzjqy = new ClientAppContext(string, null, false, null, n);
            this.zzjpb = -1;
        }
        if (n == 1) {
            Activity activity = (Activity)context;
            Log.v((String)"NearbyMessagesClient", (String)String.format("Registering ClientLifecycleSafetyNet's ActivityLifecycleCallbacks for %s", activity.getPackageName()));
            activity.getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new zzaj(activity, this, null));
        }
    }

    @NonNull
    protected final Bundle zzaae() {
        Bundle bundle = super.zzaae();
        bundle.putInt("NearbyPermissions", this.zzjpb);
        bundle.putParcelable("ClientAppContext", (Parcelable)this.zzjqy);
        return bundle;
    }

    @NonNull
    protected final String zzhf() {
        return "com.google.android.gms.nearby.messages.service.NearbyMessagesService.START";
    }

    @NonNull
    protected final String zzhg() {
        return "com.google.android.gms.nearby.messages.internal.INearbyMessagesService";
    }

    public final void disconnect() {
        try {
            this.zzef(2);
        }
        catch (RemoteException remoteException) {
            Log.v((String)"NearbyMessagesClient", (String)String.format("Failed to emit CLIENT_DISCONNECTED from override of GmsClient#disconnect(): %s", new Object[]{remoteException}));
        }
        this.zzjqx.clear();
        super.disconnect();
    }

    final void zza(zzcl<zzn<Status>> zzcl2, zzaf zzaf2, @Nullable zzv zzv2, PublishOptions publishOptions, int n) throws RemoteException {
        zzbz zzbz2 = new zzbz(zzaf2, publishOptions.getStrategy(), (IBinder)new zzcrz(zzcl2), (IBinder)zzv2, n);
        ((zzs)this.zzakb()).zza(zzbz2);
    }

    @Deprecated
    final void zza(zzcl<zzn<Status>> zzcl2, zzaf zzaf2, @Nullable zzv zzv2, PublishOptions publishOptions) throws RemoteException {
        this.zza(zzcl2, zzaf2, zzv2, publishOptions, this.zzjqy.zzjqr);
    }

    final void zza(zzcl<zzn<Status>> zzcl2, zzaf zzaf2) throws RemoteException {
        zzce zzce2 = new zzce(zzaf2, (IBinder)new zzcrz(zzcl2));
        ((zzs)this.zzakb()).zza(zzce2);
    }

    final void zza(zzcl<zzn<Status>> zzcl2, zzcl<MessageListener> zzcl3, @Nullable zzab zzab2, SubscribeOptions subscribeOptions, @Nullable byte[] byArray, int n) throws RemoteException {
        if (!this.zzjqx.containsKey(zzcl3.zzajc())) {
            this.zzjqx.zze(zzcl3.zzajc(), (IBinder)new zzcrx(zzcl3));
        }
        SubscribeRequest subscribeRequest = new SubscribeRequest(this.zzjqx.get(zzcl3.zzajc()), subscribeOptions.getStrategy(), (IBinder)new zzcrz(zzcl2), subscribeOptions.getFilter(), null, null, (IBinder)zzab2, subscribeOptions.zzjpt, n);
        ((zzs)this.zzakb()).zza(subscribeRequest);
    }

    @Deprecated
    final void zza(zzcl<zzn<Status>> zzcl2, zzcl<MessageListener> zzcl3, @Nullable zzab zzab2, SubscribeOptions subscribeOptions, @Nullable byte[] byArray) throws RemoteException {
        this.zza(zzcl2, zzcl3, zzab2, subscribeOptions, null, this.zzjqy.zzjqr);
    }

    final void zza(zzcl<zzn<Status>> zzcl2, PendingIntent pendingIntent, @Nullable zzab zzab2, SubscribeOptions subscribeOptions, int n) throws RemoteException {
        SubscribeRequest subscribeRequest = new SubscribeRequest(null, subscribeOptions.getStrategy(), (IBinder)new zzcrz(zzcl2), subscribeOptions.getFilter(), pendingIntent, null, (IBinder)zzab2, subscribeOptions.zzjpt, subscribeOptions.zzjpu, this.zzjqy.zzjqr);
        ((zzs)this.zzakb()).zza(subscribeRequest);
    }

    @Deprecated
    final void zza(zzcl<zzn<Status>> zzcl2, PendingIntent pendingIntent, @Nullable zzab zzab2, SubscribeOptions subscribeOptions) throws RemoteException {
        this.zza(zzcl2, pendingIntent, zzab2, subscribeOptions, this.zzjqy.zzjqr);
    }

    final void zza(zzcl<zzn<Status>> zzcl2, zzcl<MessageListener> zzcl3) throws RemoteException {
        zzcrz zzcrz2 = new zzcrz(zzcl2);
        if (!this.zzjqx.containsKey(zzcl3.zzajc())) {
            zzcrz2.zzak(new Status(0));
            return;
        }
        zzcg zzcg2 = new zzcg(this.zzjqx.get(zzcl3.zzajc()), (IBinder)zzcrz2, null);
        ((zzs)this.zzakb()).zza(zzcg2);
        this.zzjqx.remove(zzcl3.zzajc());
    }

    final void zza(zzcl<zzn<Status>> zzcl2, PendingIntent pendingIntent) throws RemoteException {
        zzcg zzcg2 = new zzcg(null, (IBinder)new zzcrz(zzcl2), pendingIntent);
        ((zzs)this.zzakb()).zza(zzcg2);
    }

    final void zzb(zzcl<zzn<Status>> zzcl2, zzcl<StatusCallback> zzcl3) throws RemoteException {
        if (!this.zzjqx.containsKey(zzcl3.zzajc())) {
            this.zzjqx.zze(zzcl3.zzajc(), (IBinder)new zzcsc(zzcl3));
        }
        zzcb zzcb2 = new zzcb((IBinder)new zzcrz(zzcl2), this.zzjqx.get(zzcl3.zzajc()));
        new zzcb((IBinder)new zzcrz(zzcl2), this.zzjqx.get(zzcl3.zzajc())).zzjsf = true;
        ((zzs)this.zzakb()).zza(zzcb2);
    }

    final void zzc(zzcl<zzn<Status>> zzcl2, zzcl<StatusCallback> zzcl3) throws RemoteException {
        zzcrz zzcrz2 = new zzcrz(zzcl2);
        if (!this.zzjqx.containsKey(zzcl3.zzajc())) {
            zzcrz2.zzak(new Status(0));
            return;
        }
        zzcb zzcb2 = new zzcb((IBinder)zzcrz2, this.zzjqx.get(zzcl3.zzajc()));
        new zzcb((IBinder)zzcrz2, this.zzjqx.get(zzcl3.zzajc())).zzjsf = false;
        ((zzs)this.zzakb()).zza(zzcb2);
        this.zzjqx.remove(zzcl3.zzajc());
    }

    final void zzef(int n) throws RemoteException {
        String string;
        switch (n) {
            case 1: {
                string = "ACTIVITY_STOPPED";
                break;
            }
            case 2: {
                string = "CLIENT_DISCONNECTED";
                break;
            }
            default: {
                Log.w((String)"NearbyMessagesClient", (String)String.format("Received unknown/unforeseen client lifecycle event %d, can't do anything with it.", n));
                return;
            }
        }
        if (this.isConnected()) {
            zzj zzj2 = new zzj(n);
            Log.d((String)"NearbyMessagesClient", (String)String.format("Emitting client lifecycle event %s", string));
            ((zzs)this.zzakb()).zza(zzj2);
            return;
        }
        Log.d((String)"NearbyMessagesClient", (String)String.format("Failed to emit client lifecycle event %s due to GmsClient being disconnected", string));
    }

    protected final /* synthetic */ IInterface zzd(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.nearby.messages.internal.INearbyMessagesService");
        if (iInterface instanceof zzs) {
            return (zzs)iInterface;
        }
        return new zzt(iBinder2);
    }
}

