/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import com.google.android.gms.internal.zzcsu;
import com.google.android.gms.internal.zzcsy;
import com.google.android.gms.nearby.messages.internal.zzad;
import com.google.android.gms.nearby.messages.zzb;
import com.google.android.gms.nearby.messages.zzc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class MessageFilter
extends zzbfm {
    public static final Parcelable.Creator<MessageFilter> CREATOR = new zzc();
    public static final MessageFilter INCLUDE_ALL_MY_TYPES = new Builder().includeAllMyTypes().build();
    private int zzeck;
    private final List<zzad> zzjrj;
    private final List<zzcsy> zzjrk;
    private final boolean zzjrl;
    private final List<zzcsu> zzjrm;
    private final int zzjrn;

    MessageFilter(int n, List<zzad> list, List<zzcsy> list2, boolean bl, List<zzcsu> list3, int n2) {
        this.zzeck = n;
        this.zzjrj = Collections.unmodifiableList((List)zzbq.checkNotNull(list));
        this.zzjrl = bl;
        if (list2 == null) {
            list2 = Collections.emptyList();
        }
        this.zzjrk = Collections.unmodifiableList(list2);
        if (list3 == null) {
            list3 = Collections.emptyList();
        }
        this.zzjrm = Collections.unmodifiableList(list3);
        this.zzjrn = n2;
    }

    private MessageFilter(List<zzad> list, List<zzcsy> list2, boolean bl, List<zzcsu> list3, int n) {
        this(2, list, list2, bl, list3, n);
    }

    public final List<zzad> zzbby() {
        return this.zzjrj;
    }

    public final boolean zzbbz() {
        return this.zzjrl;
    }

    final List<zzcsy> zzbca() {
        return this.zzjrk;
    }

    public final List<zzcsu> zzbcb() {
        return this.zzjrm;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        MessageFilter messageFilter = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zzc((Parcel)parcel2, (int)1, messageFilter.zzjrj, (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)2, messageFilter.zzjrk, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)3, (boolean)messageFilter.zzjrl);
        zzbfp.zzc((Parcel)parcel2, (int)4, messageFilter.zzjrm, (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)5, (int)messageFilter.zzjrn);
        zzbfp.zzc((Parcel)parcel2, (int)1000, (int)messageFilter.zzeck);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    public String toString() {
        boolean bl = this.zzjrl;
        String string = String.valueOf(this.zzjrj);
        return new StringBuilder(53 + String.valueOf(string).length()).append("MessageFilter{includeAllMyTypes=").append(bl).append(", messageTypes=").append(string).append("}").toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MessageFilter)) {
            return false;
        }
        MessageFilter messageFilter = (MessageFilter)((Object)object);
        return this.zzjrl == messageFilter.zzjrl && zzbg.equal(this.zzjrj, messageFilter.zzjrj) && zzbg.equal(this.zzjrk, messageFilter.zzjrk) && zzbg.equal(this.zzjrm, messageFilter.zzjrm);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzjrj, this.zzjrk, this.zzjrl, this.zzjrm});
    }

    /* synthetic */ MessageFilter(List list, List list2, boolean bl, List list3, int n, zzb zzb2) {
        this(list, list2, bl, list3, n);
    }

    public static final class Builder {
        private final Set<zzad> zzjro = new HashSet<zzad>();
        private final List<zzcsy> zzjrk = new ArrayList<zzcsy>();
        private final Set<zzcsu> zzjrp = new HashSet<zzcsu>();
        private boolean zzjrl;
        private int zzjrn = 0;

        public Builder() {
        }

        public final Builder includeAllMyTypes() {
            this.zzjrl = true;
            return this;
        }

        public final Builder includeNamespacedType(String string, String string2) {
            zzbq.zzb((string != null && !string.isEmpty() && !string.contains("*") ? 1 : 0) != 0, (String)"namespace(%s) cannot be null, empty or contain (*).", (Object[])new Object[]{string});
            zzbq.zzb((string2 != null && !string2.contains("*") ? 1 : 0) != 0, (String)"type(%s) cannot be null or contain (*).", (Object[])new Object[]{string2});
            return this.zzat(string, string2);
        }

        public final Builder includeFilter(MessageFilter messageFilter) {
            this.zzjro.addAll(messageFilter.zzbby());
            this.zzjrk.addAll(messageFilter.zzbca());
            this.zzjrp.addAll(messageFilter.zzbcb());
            this.zzjrl |= messageFilter.zzbbz();
            return this;
        }

        public final Builder includeEddystoneUids(String string, @Nullable String string2) {
            this.zzat("__reserved_namespace", "__eddystone_uid");
            this.zzjrk.add(zzcsy.zzau(string, string2));
            return this;
        }

        public final Builder includeIBeaconIds(UUID uUID, @Nullable Short s, @Nullable Short s2) {
            this.zzat("__reserved_namespace", "__i_beacon_id");
            this.zzjrk.add(zzcsy.zza(uUID, s, s2));
            return this;
        }

        public final Builder includeAudioBytes(int n) {
            zzbq.checkArgument((this.zzjrn == 0 ? 1 : 0) != 0, (Object)"includeAudioBytes() can only be called once per MessageFilter instance.");
            zzbq.checkArgument((n > 0 ? 1 : 0) != 0, (Object)new StringBuilder(44).append("Invalid value for numAudioBytes: ").append(n).toString());
            zzbq.checkArgument((n <= 10 ? 1 : 0) != 0, (Object)"numAudioBytes is capped by AudioBytes.MAX_SIZE = 10");
            this.zzat("__reserved_namespace", "__audio_bytes");
            this.zzjrn = n;
            return this;
        }

        private final Builder zzat(String string, String string2) {
            this.zzjro.add(new zzad(string, string2));
            return this;
        }

        public final MessageFilter build() {
            zzbq.zza((this.zzjrl || !this.zzjro.isEmpty() ? 1 : 0) != 0, (Object)"At least one of the include methods must be called.");
            return new MessageFilter(new ArrayList<zzad>(this.zzjro), this.zzjrk, this.zzjrl, new ArrayList<zzcsu>(this.zzjrp), this.zzjrn, null);
        }
    }
}

