/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzci;
import com.google.android.gms.common.api.internal.zzck;
import com.google.android.gms.common.api.internal.zzn;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.internal.zzcta;
import com.google.android.gms.internal.zzctc;
import com.google.android.gms.internal.zzctf;
import com.google.android.gms.internal.zzcth;
import com.google.android.gms.nearby.messages.MessageListener;
import com.google.android.gms.nearby.messages.MessagesOptions;
import com.google.android.gms.nearby.messages.PublishOptions;
import com.google.android.gms.nearby.messages.StatusCallback;
import com.google.android.gms.nearby.messages.SubscribeOptions;
import com.google.android.gms.nearby.messages.internal.ClientAppContext;
import com.google.android.gms.nearby.messages.internal.SubscribeRequest;
import com.google.android.gms.nearby.messages.internal.zzab;
import com.google.android.gms.nearby.messages.internal.zzaf;
import com.google.android.gms.nearby.messages.internal.zzaj;
import com.google.android.gms.nearby.messages.internal.zzbz;
import com.google.android.gms.nearby.messages.internal.zzcb;
import com.google.android.gms.nearby.messages.internal.zzce;
import com.google.android.gms.nearby.messages.internal.zzcg;
import com.google.android.gms.nearby.messages.internal.zzj;
import com.google.android.gms.nearby.messages.internal.zzs;
import com.google.android.gms.nearby.messages.internal.zzt;
import com.google.android.gms.nearby.messages.internal.zzv;

public final class zzah
extends com.google.android.gms.common.internal.zzab<zzs> {
    private final zzcth<zzck, IBinder> zzjtq = new zzcth();
    private final ClientAppContext zzjtr;
    private final int zzjru;

    static int zzdy(Context context) {
        if (context instanceof Activity) {
            return 1;
        }
        if (context instanceof Application) {
            return 2;
        }
        if (context instanceof Service) {
            return 3;
        }
        return 0;
    }

    @TargetApi(value=14)
    zzah(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, zzr zzr2, MessagesOptions messagesOptions) {
        super(context, looper, 62, zzr2, connectionCallbacks, onConnectionFailedListener);
        String string = zzr2.zzaky();
        int n = zzah.zzdy(context);
        if (messagesOptions != null) {
            this.zzjtr = new ClientAppContext(string, null, false, null, n);
            this.zzjru = messagesOptions.zzjrs;
        } else {
            this.zzjtr = new ClientAppContext(string, null, false, null, n);
            this.zzjru = -1;
        }
        if (n == 1) {
            Activity activity = (Activity)context;
            Log.v((String)"NearbyMessagesClient", (String)String.format("Registering ClientLifecycleSafetyNet's ActivityLifecycleCallbacks for %s", activity.getPackageName()));
            activity.getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new zzaj(activity, this, null));
        }
    }

    @NonNull
    protected final Bundle zzaap() {
        Bundle bundle = super.zzaap();
        bundle.putInt("NearbyPermissions", this.zzjru);
        bundle.putParcelable("ClientAppContext", (Parcelable)this.zzjtr);
        return bundle;
    }

    @NonNull
    protected final String zzhi() {
        return "com.google.android.gms.nearby.messages.service.NearbyMessagesService.START";
    }

    @NonNull
    protected final String zzhj() {
        return "com.google.android.gms.nearby.messages.internal.INearbyMessagesService";
    }

    public final void disconnect() {
        try {
            this.zzef(2);
        }
        catch (RemoteException remoteException) {
            Log.v((String)"NearbyMessagesClient", (String)String.format("Failed to emit CLIENT_DISCONNECTED from override of GmsClient#disconnect(): %s", new Object[]{remoteException}));
        }
        this.zzjtq.clear();
        super.disconnect();
    }

    final void zza(zzci<zzn<Status>> zzci2, zzaf zzaf2, @Nullable zzv zzv2, PublishOptions publishOptions, int n) throws RemoteException {
        zzbz zzbz2 = new zzbz(zzaf2, publishOptions.getStrategy(), (IBinder)new zzctc(zzci2), (IBinder)zzv2, n);
        ((zzs)this.zzakn()).zza(zzbz2);
    }

    @Deprecated
    final void zza(zzci<zzn<Status>> zzci2, zzaf zzaf2, @Nullable zzv zzv2, PublishOptions publishOptions) throws RemoteException {
        this.zza(zzci2, zzaf2, zzv2, publishOptions, this.zzjtr.zzjtk);
    }

    final void zza(zzci<zzn<Status>> zzci2, zzaf zzaf2) throws RemoteException {
        zzce zzce2 = new zzce(zzaf2, (IBinder)new zzctc(zzci2));
        ((zzs)this.zzakn()).zza(zzce2);
    }

    final void zza(zzci<zzn<Status>> zzci2, zzci<MessageListener> zzci3, @Nullable zzab zzab2, SubscribeOptions subscribeOptions, @Nullable byte[] byArray, int n) throws RemoteException {
        if (!this.zzjtq.containsKey(zzci3.zzajo())) {
            this.zzjtq.zzf(zzci3.zzajo(), (IBinder)new zzcta(zzci3));
        }
        SubscribeRequest subscribeRequest = new SubscribeRequest(this.zzjtq.get(zzci3.zzajo()), subscribeOptions.getStrategy(), (IBinder)new zzctc(zzci2), subscribeOptions.getFilter(), null, null, (IBinder)zzab2, subscribeOptions.zzjsm, n);
        ((zzs)this.zzakn()).zza(subscribeRequest);
    }

    @Deprecated
    final void zza(zzci<zzn<Status>> zzci2, zzci<MessageListener> zzci3, @Nullable zzab zzab2, SubscribeOptions subscribeOptions, @Nullable byte[] byArray) throws RemoteException {
        this.zza(zzci2, zzci3, zzab2, subscribeOptions, null, this.zzjtr.zzjtk);
    }

    final void zza(zzci<zzn<Status>> zzci2, PendingIntent pendingIntent, @Nullable zzab zzab2, SubscribeOptions subscribeOptions, int n) throws RemoteException {
        SubscribeRequest subscribeRequest = new SubscribeRequest(null, subscribeOptions.getStrategy(), (IBinder)new zzctc(zzci2), subscribeOptions.getFilter(), pendingIntent, null, (IBinder)zzab2, subscribeOptions.zzjsm, subscribeOptions.zzjsn, this.zzjtr.zzjtk);
        ((zzs)this.zzakn()).zza(subscribeRequest);
    }

    @Deprecated
    final void zza(zzci<zzn<Status>> zzci2, PendingIntent pendingIntent, @Nullable zzab zzab2, SubscribeOptions subscribeOptions) throws RemoteException {
        this.zza(zzci2, pendingIntent, zzab2, subscribeOptions, this.zzjtr.zzjtk);
    }

    final void zza(zzci<zzn<Status>> zzci2, zzci<MessageListener> zzci3) throws RemoteException {
        zzctc zzctc2 = new zzctc(zzci2);
        if (!this.zzjtq.containsKey(zzci3.zzajo())) {
            zzctc2.zzak(new Status(0));
            return;
        }
        zzcg zzcg2 = new zzcg(this.zzjtq.get(zzci3.zzajo()), (IBinder)zzctc2, null);
        ((zzs)this.zzakn()).zza(zzcg2);
        this.zzjtq.remove(zzci3.zzajo());
    }

    final void zza(zzci<zzn<Status>> zzci2, PendingIntent pendingIntent) throws RemoteException {
        zzcg zzcg2 = new zzcg(null, (IBinder)new zzctc(zzci2), pendingIntent);
        ((zzs)this.zzakn()).zza(zzcg2);
    }

    final void zzb(zzci<zzn<Status>> zzci2, zzci<StatusCallback> zzci3) throws RemoteException {
        if (!this.zzjtq.containsKey(zzci3.zzajo())) {
            this.zzjtq.zzf(zzci3.zzajo(), (IBinder)new zzctf(zzci3));
        }
        zzcb zzcb2 = new zzcb((IBinder)new zzctc(zzci2), this.zzjtq.get(zzci3.zzajo()));
        new zzcb((IBinder)new zzctc(zzci2), this.zzjtq.get(zzci3.zzajo())).zzjux = true;
        ((zzs)this.zzakn()).zza(zzcb2);
    }

    final void zzc(zzci<zzn<Status>> zzci2, zzci<StatusCallback> zzci3) throws RemoteException {
        zzctc zzctc2 = new zzctc(zzci2);
        if (!this.zzjtq.containsKey(zzci3.zzajo())) {
            zzctc2.zzak(new Status(0));
            return;
        }
        zzcb zzcb2 = new zzcb((IBinder)zzctc2, this.zzjtq.get(zzci3.zzajo()));
        new zzcb((IBinder)zzctc2, this.zzjtq.get(zzci3.zzajo())).zzjux = false;
        ((zzs)this.zzakn()).zza(zzcb2);
        this.zzjtq.remove(zzci3.zzajo());
    }

    final void zzef(int n) throws RemoteException {
        String string;
        switch (n) {
            case 1: {
                string = "ACTIVITY_STOPPED";
                break;
            }
            case 2: {
                string = "CLIENT_DISCONNECTED";
                break;
            }
            default: {
                Log.w((String)"NearbyMessagesClient", (String)String.format("Received unknown/unforeseen client lifecycle event %d, can't do anything with it.", n));
                return;
            }
        }
        if (this.isConnected()) {
            zzj zzj2 = new zzj(n);
            Log.d((String)"NearbyMessagesClient", (String)String.format("Emitting client lifecycle event %s", string));
            ((zzs)this.zzakn()).zza(zzj2);
            return;
        }
        Log.d((String)"NearbyMessagesClient", (String)String.format("Failed to emit client lifecycle event %s due to GmsClient being disconnected", string));
    }

    protected final /* synthetic */ IInterface zzd(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.nearby.messages.internal.INearbyMessagesService");
        if (iInterface instanceof zzs) {
            return (zzs)iInterface;
        }
        return new zzt(iBinder2);
    }
}

