/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.ParcelUuid;
import android.support.annotation.Nullable;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.util.zzm;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@Hide
public final class zzcuw {
    private static final ParcelUuid zza = ParcelUuid.fromString((String)"00000000-0000-1000-8000-00805F9B34FB");
    private final int zzb;
    @Nullable
    private final List<ParcelUuid> zzc;
    @Nullable
    private final SparseArray<byte[]> zzd;
    @Nullable
    private final Map<ParcelUuid, byte[]> zze;
    private final int zzf;
    @Nullable
    private final String zzg;
    private final byte[] zzh;

    private zzcuw(@Nullable List<ParcelUuid> list, @Nullable SparseArray<byte[]> sparseArray, @Nullable Map<ParcelUuid, byte[]> map, int n, int n2, @Nullable String string, byte[] byArray) {
        this.zzc = list;
        this.zzd = sparseArray;
        this.zze = map;
        this.zzg = string;
        this.zzb = n;
        this.zzf = n2;
        this.zzh = byArray;
    }

    @Hide
    public static zzcuw zza(@Nullable byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        int n = -1;
        ArrayList<ParcelUuid> arrayList = new ArrayList<ParcelUuid>();
        String string = null;
        int n2 = Integer.MIN_VALUE;
        SparseArray sparseArray = new SparseArray();
        HashMap<ParcelUuid, byte[]> hashMap = new HashMap<ParcelUuid, byte[]>();
        try {
            int n3;
            int n4;
            block12: for (int i = 0; i < byArray.length && (n3 = byArray[i++] & 0xFF) != 0; i += n4) {
                n4 = n3 - 1;
                switch (byArray[i++] & 0xFF) {
                    case 1: {
                        n = byArray[i] & 0xFF;
                        continue block12;
                    }
                    case 2: 
                    case 3: {
                        zzcuw.zza(byArray, i, n4, 2, arrayList);
                        continue block12;
                    }
                    case 4: 
                    case 5: {
                        zzcuw.zza(byArray, i, n4, 4, arrayList);
                        continue block12;
                    }
                    case 6: 
                    case 7: {
                        zzcuw.zza(byArray, i, n4, 16, arrayList);
                        continue block12;
                    }
                    case 8: 
                    case 9: {
                        string = new String(zzcuw.zza(byArray, i, n4));
                        continue block12;
                    }
                    case 10: {
                        n2 = byArray[i];
                        continue block12;
                    }
                    case 22: {
                        ParcelUuid parcelUuid = zzcuw.zzb(zzcuw.zza(byArray, i, 2));
                        byte[] byArray2 = zzcuw.zza(byArray, i + 2, n4 - 2);
                        hashMap.put(parcelUuid, byArray2);
                        continue block12;
                    }
                    case 255: {
                        int n5 = ((byArray[i + 1] & 0xFF) << 8) + (byArray[i] & 0xFF);
                        byte[] byArray3 = zzcuw.zza(byArray, i + 2, n4 - 2);
                        sparseArray.put(n5, (Object)byArray3);
                    }
                }
            }
            if (arrayList.isEmpty()) {
                arrayList = null;
            }
            return new zzcuw(arrayList, (SparseArray<byte[]>)sparseArray, hashMap, n, n2, string, byArray);
        }
        catch (Exception exception) {
            String string2 = String.valueOf(Arrays.toString(byArray));
            Log.w((String)"BleRecord", (String)(string2.length() != 0 ? "Unable to parse scan record: ".concat(string2) : new String("Unable to parse scan record: ")), (Throwable)exception);
            return null;
        }
    }

    private static int zza(byte[] byArray, int n, int n2, int n3, List<ParcelUuid> list) {
        while (n2 > 0) {
            byte[] byArray2 = zzcuw.zza(byArray, n, n3);
            list.add(zzcuw.zzb(byArray2));
            n2 -= n3;
            n += n3;
        }
        return n;
    }

    private static byte[] zza(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    public final String toString() {
        String string;
        int n = this.zzb;
        String string2 = String.valueOf(this.zzc);
        SparseArray<byte[]> sparseArray = this.zzd;
        StringBuilder stringBuilder = new StringBuilder();
        if (sparseArray.size() <= 0) {
            string = "{}";
        } else {
            stringBuilder.append('{');
            for (int i = 0; i < sparseArray.size(); ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                int n2 = sparseArray.keyAt(i);
                byte[] byArray = (byte[])sparseArray.valueAt(i);
                stringBuilder.append(n2);
                stringBuilder.append('=');
                stringBuilder.append(byArray == null ? null : zzm.zza((byte[])byArray));
            }
            stringBuilder.append('}');
            string = stringBuilder.toString();
        }
        String string3 = string;
        String string4 = zzcuw.zza(this.zze);
        int n3 = this.zzf;
        String string5 = this.zzg;
        return new StringBuilder(139 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length()).append("BleRecord [mAdvertiseFlags=").append(n).append(", mServiceUuids=").append(string2).append(", mManufacturerSpecificData=").append(string3).append(", mServiceData=").append(string4).append(", mTxPowerLevel=").append(n3).append(", mDeviceName=").append(string5).append("]").toString();
    }

    private static <T> String zza(Map<T, byte[]> map) {
        StringBuilder stringBuilder = new StringBuilder();
        if (map.keySet().size() <= 0) {
            return "{}";
        }
        stringBuilder.append('{');
        int n = 0;
        for (Map.Entry<T, byte[]> entry : map.entrySet()) {
            if (n > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(entry.getKey());
            stringBuilder.append('=');
            byte[] byArray = entry.getValue();
            stringBuilder.append(byArray == null ? null : zzm.zza((byte[])byArray));
            ++n;
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof zzcuw)) {
            return false;
        }
        zzcuw zzcuw2 = (zzcuw)object;
        return Arrays.equals(this.zzh, zzcuw2.zzh);
    }

    public final int hashCode() {
        return Arrays.hashCode(this.zzh);
    }

    private static ParcelUuid zzb(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("uuidBytes cannot be null");
        }
        int n = byArray.length;
        if (n != 2 && n != 4 && n != 16) {
            throw new IllegalArgumentException(new StringBuilder(38).append("uuidBytes length invalid - ").append(n).toString());
        }
        if (n == 16) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
            long l = byteBuffer.getLong(8);
            long l2 = byteBuffer.getLong(0);
            return new ParcelUuid(new UUID(l, l2));
        }
        long l = n == 2 ? (long)(byArray[0] & 0xFF) + (long)((byArray[1] & 0xFF) << 8) : (long)(byArray[0] & 0xFF) + (long)((byArray[1] & 0xFF) << 8) + (long)((byArray[2] & 0xFF) << 16) + (long)((byArray[3] & 0xFF) << 24);
        long l3 = zza.getUuid().getMostSignificantBits() + (l << 32);
        long l4 = zza.getUuid().getLeastSignificantBits();
        return new ParcelUuid(new UUID(l3, l4));
    }
}

