/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzcux;
import com.google.android.gms.nearby.messages.zza;
import java.util.Arrays;

public class Message
extends zzbgl
implements ReflectedParcelable {
    public static final int MAX_CONTENT_SIZE_BYTES = 102400;
    public static final int MAX_TYPE_LENGTH = 32;
    public static final Parcelable.Creator<Message> CREATOR = new zza();
    private static final zzcux[] zza = new zzcux[]{zzcux.zza};
    public static final String MESSAGE_NAMESPACE_RESERVED = "__reserved_namespace";
    public static final String MESSAGE_TYPE_EDDYSTONE_UID = "__eddystone_uid";
    public static final String MESSAGE_TYPE_I_BEACON_ID = "__i_beacon_id";
    public static final String MESSAGE_TYPE_AUDIO_BYTES = "__audio_bytes";
    private int zzb;
    private final byte[] zzc;
    private final String zzd;
    private final String zze;
    @Deprecated
    private zzcux[] zzf;
    private final long zzg;

    Message(int n, @Nullable byte[] byArray, @Nullable String string, String string2, @Nullable zzcux[] zzcuxArray, long l) {
        this.zzb = n;
        this.zzd = (String)zzbq.zza((Object)string2);
        this.zze = string == null ? "" : string;
        this.zzg = l;
        zzbq.zza((Object)byArray);
        zzbq.zzb((byArray.length <= 102400 ? 1 : 0) != 0, (String)"Content length(%d) must not exceed MAX_CONTENT_SIZE_BYTES(%d)", (Object[])new Object[]{byArray.length, 102400});
        this.zzc = byArray;
        if (zzcuxArray == null || zzcuxArray.length == 0) {
            zzcuxArray = zza;
        }
        this.zzf = zzcuxArray;
        zzbq.zzb((string2.length() <= 32 ? 1 : 0) != 0, (String)"Type length(%d) must not exceed MAX_TYPE_LENGTH(%d)", (Object[])new Object[]{string2.length(), 32});
    }

    @Hide
    public final boolean zza(String string) {
        Message message = this;
        return MESSAGE_NAMESPACE_RESERVED.equals(message.getNamespace()) && string.equals(this.getType());
    }

    public Message(byte[] byArray) {
        this(byArray, "", "");
    }

    public Message(byte[] byArray, String string) {
        this(byArray, "", string);
    }

    @Hide
    public Message(byte[] byArray, String string, String string2) {
        this(byArray, string, string2, zza);
    }

    @Hide
    private Message(byte[] byArray, String string, String string2, zzcux[] zzcuxArray) {
        this(byArray, string, string2, zzcuxArray, 0L);
    }

    @Hide
    private Message(byte[] byArray, String string, String string2, zzcux[] zzcuxArray, long l) {
        this(2, byArray, string, string2, zzcuxArray, 0L);
    }

    public String getType() {
        return this.zzd;
    }

    public String getNamespace() {
        return this.zze;
    }

    public byte[] getContent() {
        return this.zzc;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Message message = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (byte[])message.getContent(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)2, (String)message.getType(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (String)message.getNamespace(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (Parcelable[])message.zzf, (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)5, (long)message.zzg);
        zzbgo.zza((Parcel)parcel2, (int)1000, (int)message.zzb);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zze, this.zzd, Arrays.hashCode(this.zzc), this.zzg});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Message)) {
            return false;
        }
        Message message = (Message)((Object)object);
        return TextUtils.equals((CharSequence)this.zze, (CharSequence)message.zze) && TextUtils.equals((CharSequence)this.zzd, (CharSequence)message.zzd) && Arrays.equals(this.zzc, message.zzc) && this.zzg == message.zzg;
    }

    public String toString() {
        String string = this.zze;
        String string2 = this.zzd;
        int n = this.zzc == null ? 0 : this.zzc.length;
        return new StringBuilder(59 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Message{namespace='").append(string).append("', type='").append(string2).append("', content=[").append(n).append(" bytes]}").toString();
    }
}

