/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.connection;

import android.os.ParcelFileDescriptor;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.UUID;

public class Payload {
    private final long zza;
    @Type
    private final int zzb;
    @Nullable
    private final byte[] zzc;
    @Nullable
    private final File zzd;
    @Nullable
    private final Stream zze;

    public static Payload fromBytes(byte[] byArray) {
        zzbq.zza((Object)byArray, (Object)"Cannot create a Payload from null bytes.");
        return Payload.zza(byArray, UUID.randomUUID().getLeastSignificantBits());
    }

    @Hide
    public static Payload zza(byte[] byArray, long l) {
        return new Payload(l, 1, byArray, null, null);
    }

    public static Payload fromFile(java.io.File file) throws FileNotFoundException {
        return Payload.zza(File.zza(file, file.length()), UUID.randomUUID().getLeastSignificantBits());
    }

    public static Payload fromFile(ParcelFileDescriptor parcelFileDescriptor) {
        return Payload.zza(File.zza(parcelFileDescriptor), UUID.randomUUID().getLeastSignificantBits());
    }

    @Hide
    public static Payload zza(File file, long l) {
        return new Payload(l, 2, null, file, null);
    }

    public static Payload fromStream(InputStream inputStream) {
        return Payload.zza(Stream.zza(inputStream), UUID.randomUUID().getLeastSignificantBits());
    }

    public static Payload fromStream(ParcelFileDescriptor parcelFileDescriptor) {
        return Payload.zza(Stream.zza(parcelFileDescriptor), UUID.randomUUID().getLeastSignificantBits());
    }

    @Hide
    public static Payload zza(Stream stream, long l) {
        return new Payload(l, 3, null, null, stream);
    }

    private Payload(long l, int n, @Nullable byte[] byArray, @Nullable File file, @Nullable Stream stream) {
        this.zza = l;
        this.zzb = n;
        this.zzc = byArray;
        this.zzd = file;
        this.zze = stream;
    }

    public long getId() {
        return this.zza;
    }

    @Type
    public int getType() {
        return this.zzb;
    }

    @Nullable
    public byte[] asBytes() {
        return this.zzc;
    }

    @Nullable
    public File asFile() {
        return this.zzd;
    }

    @Nullable
    public Stream asStream() {
        return this.zze;
    }

    public static @interface Type {
        public static final int BYTES = 1;
        public static final int FILE = 2;
        public static final int STREAM = 3;
    }

    public static class Stream {
        @Nullable
        private final ParcelFileDescriptor zza;
        @Nullable
        private InputStream zzb;

        @Hide
        public static Stream zza(InputStream inputStream) {
            zzbq.zza((Object)inputStream, (Object)"Cannot create Payload.Stream from null InputStream.");
            return new Stream(null, inputStream);
        }

        @Hide
        public static Stream zza(ParcelFileDescriptor parcelFileDescriptor) {
            zzbq.zza((Object)parcelFileDescriptor, (Object)"Cannot create Payload.Stream from null ParcelFileDescriptor.");
            return new Stream(parcelFileDescriptor, null);
        }

        private Stream(@Nullable ParcelFileDescriptor parcelFileDescriptor, @Nullable InputStream inputStream) {
            this.zza = parcelFileDescriptor;
            this.zzb = inputStream;
        }

        @NonNull
        public InputStream asInputStream() {
            if (this.zzb == null) {
                this.zzb = new ParcelFileDescriptor.AutoCloseInputStream(this.zza);
            }
            return this.zzb;
        }

        @Nullable
        public ParcelFileDescriptor asParcelFileDescriptor() {
            return this.zza;
        }
    }

    public static class File {
        @Nullable
        private final java.io.File zza;
        private final ParcelFileDescriptor zzb;
        private final long zzc;

        @Hide
        public static File zza(java.io.File file, long l) throws FileNotFoundException {
            return new File((java.io.File)zzbq.zza((Object)file, (Object)"Cannot create Payload.File from null java.io.File."), ParcelFileDescriptor.open((java.io.File)file, (int)0x10000000), l);
        }

        @Hide
        public static File zza(ParcelFileDescriptor parcelFileDescriptor) {
            return new File(null, (ParcelFileDescriptor)zzbq.zza((Object)parcelFileDescriptor, (Object)"Cannot create Payload.File from null ParcelFileDescriptor."), parcelFileDescriptor.getStatSize());
        }

        private File(@Nullable java.io.File file, ParcelFileDescriptor parcelFileDescriptor, long l) {
            this.zza = file;
            this.zzb = parcelFileDescriptor;
            this.zzc = l;
        }

        @Nullable
        public java.io.File asJavaFile() {
            return this.zza;
        }

        @NonNull
        public ParcelFileDescriptor asParcelFileDescriptor() {
            return this.zzb;
        }

        public long getSize() {
            return this.zzc;
        }
    }
}

