/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.nearby.messages.Message;
import com.google.android.gms.nearby.messages.internal.zzc;
import com.google.android.gms.nearby.messages.internal.zzg;
import java.util.Arrays;

public class EddystoneUid {
    public static final int LENGTH = 16;
    public static final int NAMESPACE_LENGTH = 10;
    public static final int INSTANCE_LENGTH = 6;
    private final zzg zzkai;

    @Hide
    private EddystoneUid(byte[] byArray) {
        byte[] byArray2 = byArray;
        zzbq.checkArgument((byArray.length == 16 ? 1 : 0) != 0, (Object)"Bytes must be a namespace plus instance (16 bytes).");
        this.zzkai = new zzg(byArray2);
    }

    public EddystoneUid(String string) {
        this(zzc.zzky(string));
    }

    public EddystoneUid(String string, String string2) {
        this.zzkai = new zzg(string, string2);
    }

    public static EddystoneUid from(Message message) {
        String string = message.getType();
        zzbq.checkArgument((boolean)message.zzkx("__eddystone_uid"), (Object)new StringBuilder(58 + String.valueOf(string).length()).append("Message type '").append(string).append("' is not Message.MESSAGE_TYPE_EDDYSTONE_UID.").toString());
        return new EddystoneUid(message.getContent());
    }

    public String getNamespace() {
        return zzc.zzw(Arrays.copyOfRange(this.zzkai.getBytes(), 0, 10));
    }

    public String getInstance() {
        byte[] byArray = this.zzkai.getBytes();
        if (byArray.length < 16) {
            return null;
        }
        return zzc.zzw(Arrays.copyOfRange(byArray, 10, 16));
    }

    public String getHex() {
        return this.zzkai.getHex();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof EddystoneUid)) {
            return false;
        }
        EddystoneUid eddystoneUid = (EddystoneUid)object;
        return zzbg.equal((Object)this.zzkai, (Object)eddystoneUid.zzkai);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzkai});
    }

    public String toString() {
        String string = this.getHex();
        return new StringBuilder(17 + String.valueOf(string).length()).append("EddystoneUid{id=").append(string).append('}').toString();
    }
}

