/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzcuu;
import com.google.android.gms.internal.zzcuz;
import com.google.android.gms.nearby.messages.internal.zzad;
import com.google.android.gms.nearby.messages.zzb;
import com.google.android.gms.nearby.messages.zzc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class MessageFilter
extends zzbgl {
    public static final Parcelable.Creator<MessageFilter> CREATOR = new zzc();
    public static final MessageFilter INCLUDE_ALL_MY_TYPES = new Builder().includeAllMyTypes().build();
    private int zzehz;
    private final List<zzad> zzkao;
    private final List<zzcuz> zzkap;
    private final boolean zzkaq;
    private final List<zzcuu> zzkar;
    private final int zzkas;

    MessageFilter(int n, List<zzad> list, List<zzcuz> list2, boolean bl, List<zzcuu> list3, int n2) {
        this.zzehz = n;
        this.zzkao = Collections.unmodifiableList((List)zzbq.checkNotNull(list));
        this.zzkaq = bl;
        if (list2 == null) {
            list2 = Collections.emptyList();
        }
        this.zzkap = Collections.unmodifiableList(list2);
        if (list3 == null) {
            list3 = Collections.emptyList();
        }
        this.zzkar = Collections.unmodifiableList(list3);
        this.zzkas = n2;
    }

    private MessageFilter(List<zzad> list, List<zzcuz> list2, boolean bl, List<zzcuu> list3, int n) {
        this(2, list, list2, bl, list3, n);
    }

    @Hide
    public final List<zzad> zzbdq() {
        return this.zzkao;
    }

    @Hide
    public final boolean zzbdr() {
        return this.zzkaq;
    }

    @Hide
    final List<zzcuz> zzbds() {
        return this.zzkap;
    }

    @Hide
    public final List<zzcuu> zzbdt() {
        return this.zzkar;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        MessageFilter messageFilter = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zzc((Parcel)parcel2, (int)1, messageFilter.zzkao, (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)2, messageFilter.zzkap, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (boolean)messageFilter.zzkaq);
        zzbgo.zzc((Parcel)parcel2, (int)4, messageFilter.zzkar, (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)5, (int)messageFilter.zzkas);
        zzbgo.zzc((Parcel)parcel2, (int)1000, (int)messageFilter.zzehz);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    public String toString() {
        boolean bl = this.zzkaq;
        String string = String.valueOf(this.zzkao);
        return new StringBuilder(53 + String.valueOf(string).length()).append("MessageFilter{includeAllMyTypes=").append(bl).append(", messageTypes=").append(string).append("}").toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MessageFilter)) {
            return false;
        }
        MessageFilter messageFilter = (MessageFilter)((Object)object);
        return this.zzkaq == messageFilter.zzkaq && zzbg.equal(this.zzkao, messageFilter.zzkao) && zzbg.equal(this.zzkap, messageFilter.zzkap) && zzbg.equal(this.zzkar, messageFilter.zzkar);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzkao, this.zzkap, this.zzkaq, this.zzkar});
    }

    /* synthetic */ MessageFilter(List list, List list2, boolean bl, List list3, int n, zzb zzb2) {
        this(list, list2, bl, list3, n);
    }

    public static final class Builder {
        private final Set<zzad> zzkat = new HashSet<zzad>();
        private final List<zzcuz> zzkap = new ArrayList<zzcuz>();
        private final Set<zzcuu> zzkau = new HashSet<zzcuu>();
        private boolean zzkaq;
        private int zzkas = 0;

        public Builder() {
        }

        public final Builder includeAllMyTypes() {
            this.zzkaq = true;
            return this;
        }

        public final Builder includeNamespacedType(String string, String string2) {
            zzbq.zzb((string != null && !string.isEmpty() && !string.contains("*") ? 1 : 0) != 0, (String)"namespace(%s) cannot be null, empty or contain (*).", (Object[])new Object[]{string});
            zzbq.zzb((string2 != null && !string2.contains("*") ? 1 : 0) != 0, (String)"type(%s) cannot be null or contain (*).", (Object[])new Object[]{string2});
            return this.zzat(string, string2);
        }

        public final Builder includeFilter(MessageFilter messageFilter) {
            this.zzkat.addAll(messageFilter.zzbdq());
            this.zzkap.addAll(messageFilter.zzbds());
            this.zzkau.addAll(messageFilter.zzbdt());
            this.zzkaq |= messageFilter.zzbdr();
            return this;
        }

        public final Builder includeEddystoneUids(String string, @Nullable String string2) {
            this.zzat("__reserved_namespace", "__eddystone_uid");
            this.zzkap.add(zzcuz.zzau(string, string2));
            return this;
        }

        public final Builder includeIBeaconIds(UUID uUID, @Nullable Short s, @Nullable Short s2) {
            this.zzat("__reserved_namespace", "__i_beacon_id");
            this.zzkap.add(zzcuz.zza(uUID, s, s2));
            return this;
        }

        public final Builder includeAudioBytes(int n) {
            zzbq.checkArgument((this.zzkas == 0 ? 1 : 0) != 0, (Object)"includeAudioBytes() can only be called once per MessageFilter instance.");
            zzbq.checkArgument((n > 0 ? 1 : 0) != 0, (Object)new StringBuilder(44).append("Invalid value for numAudioBytes: ").append(n).toString());
            zzbq.checkArgument((n <= 10 ? 1 : 0) != 0, (Object)"numAudioBytes is capped by AudioBytes.MAX_SIZE = 10");
            this.zzat("__reserved_namespace", "__audio_bytes");
            this.zzkas = n;
            return this;
        }

        private final Builder zzat(String string, String string2) {
            this.zzkat.add(new zzad(string, string2));
            return this;
        }

        public final MessageFilter build() {
            zzbq.zza((this.zzkaq || !this.zzkat.isEmpty() ? 1 : 0) != 0, (Object)"At least one of the include methods must be called.");
            return new MessageFilter(new ArrayList<zzad>(this.zzkat), this.zzkap, this.zzkaq, new ArrayList<zzcuu>(this.zzkau), this.zzkas, null);
        }
    }
}

