/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.nearby.messages.zzg;
import java.util.ArrayList;

public class Strategy
extends zzbgl {
    public static final Parcelable.Creator<Strategy> CREATOR = new zzg();
    public static final int DISCOVERY_MODE_BROADCAST = 1;
    public static final int DISCOVERY_MODE_SCAN = 2;
    public static final int DISCOVERY_MODE_DEFAULT = 3;
    public static final int DISTANCE_TYPE_DEFAULT = 0;
    public static final int DISTANCE_TYPE_EARSHOT = 1;
    public static final int TTL_SECONDS_DEFAULT = 300;
    public static final int TTL_SECONDS_MAX = 86400;
    public static final int TTL_SECONDS_INFINITE = Integer.MAX_VALUE;
    public static final Strategy DEFAULT = new Builder().build();
    public static final Strategy BLE_ONLY;
    @Deprecated
    @Hide
    private static Strategy zzkbc;
    private int zzehz;
    @Deprecated
    @Hide
    private int zzkbd;
    private int zzkbe;
    private int zzkbf;
    @Deprecated
    @Hide
    private boolean zzkbg;
    @Hide
    private int zzkbh;
    private int zzkbi;
    private final int zzkbj;

    Strategy(int n, int n2, int n3, int n4, boolean bl, int n5, int n6, int n7) {
        this.zzehz = n;
        this.zzkbd = n2;
        if (n2 == 0) {
            this.zzkbi = n6;
        } else {
            switch (n2) {
                case 2: {
                    this.zzkbi = 1;
                    break;
                }
                case 3: {
                    this.zzkbi = 2;
                    break;
                }
                default: {
                    this.zzkbi = 3;
                }
            }
        }
        this.zzkbf = n4;
        this.zzkbg = bl;
        if (bl) {
            this.zzkbh = 2;
            this.zzkbe = Integer.MAX_VALUE;
        } else {
            this.zzkbe = n3;
            switch (n5) {
                case -1: 
                case 0: 
                case 1: 
                case 6: {
                    this.zzkbh = -1;
                    break;
                }
                default: {
                    this.zzkbh = n5;
                }
            }
        }
        this.zzkbj = n7;
    }

    @Hide
    public final int zzbdu() {
        return this.zzkbj;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Strategy strategy = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zzc((Parcel)parcel2, (int)1, (int)strategy.zzkbd);
        zzbgo.zzc((Parcel)parcel2, (int)2, (int)strategy.zzkbe);
        zzbgo.zzc((Parcel)parcel2, (int)3, (int)strategy.zzkbf);
        zzbgo.zza((Parcel)parcel2, (int)4, (boolean)strategy.zzkbg);
        zzbgo.zzc((Parcel)parcel2, (int)5, (int)strategy.zzkbh);
        zzbgo.zzc((Parcel)parcel2, (int)6, (int)strategy.zzkbi);
        zzbgo.zzc((Parcel)parcel2, (int)7, (int)strategy.zzkbj);
        zzbgo.zzc((Parcel)parcel2, (int)1000, (int)strategy.zzehz);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Strategy)) {
            return false;
        }
        Strategy strategy = (Strategy)((Object)object);
        return this.zzehz == strategy.zzehz && this.zzkbi == strategy.zzkbi && this.zzkbe == strategy.zzkbe && this.zzkbf == strategy.zzkbf && this.zzkbh == strategy.zzkbh && this.zzkbj == strategy.zzkbj;
    }

    public int hashCode() {
        int n = this.zzehz;
        n = n * 31 + this.zzkbi;
        n = n * 31 + this.zzkbe;
        n = n * 31 + this.zzkbf;
        n = n * 31 + this.zzkbh;
        return n * 31 + this.zzkbj;
    }

    public String toString() {
        String string;
        String string2;
        ArrayList<String> arrayList;
        String string3;
        String string4;
        int n = this.zzkbe;
        int n2 = this.zzkbf;
        switch (n2) {
            case 0: {
                string4 = "DEFAULT";
                break;
            }
            case 1: {
                string4 = "EARSHOT";
                break;
            }
            default: {
                string4 = new StringBuilder(19).append("UNKNOWN:").append(n2).toString();
            }
        }
        String string5 = string4;
        n2 = this.zzkbh;
        if (n2 == -1) {
            string3 = "DEFAULT";
        } else {
            arrayList = new ArrayList<String>();
            if ((n2 & 4) > 0) {
                arrayList.add("ULTRASOUND");
            }
            if ((n2 & 2) > 0) {
                arrayList.add("BLE");
            }
            string3 = arrayList.isEmpty() ? new StringBuilder(19).append("UNKNOWN:").append(n2).toString() : ((Object)arrayList).toString();
        }
        String string6 = string3;
        n2 = this.zzkbi;
        if (n2 == 3) {
            string2 = "DEFAULT";
        } else {
            arrayList = new ArrayList();
            if ((n2 & 1) > 0) {
                arrayList.add("BROADCAST");
            }
            if ((n2 & 2) > 0) {
                arrayList.add("SCAN");
            }
            string2 = arrayList.isEmpty() ? new StringBuilder(19).append("UNKNOWN:").append(n2).toString() : ((Object)arrayList).toString();
        }
        String string7 = string2;
        n2 = this.zzkbj;
        switch (n2) {
            case 0: {
                string = "DEFAULT";
                break;
            }
            case 1: {
                string = "ALWAYS_ON";
                break;
            }
            default: {
                string = new StringBuilder(20).append("UNKNOWN: ").append(n2).toString();
            }
        }
        String string8 = string;
        return new StringBuilder(102 + String.valueOf(string5).length() + String.valueOf(string6).length() + String.valueOf(string7).length() + String.valueOf(string8).length()).append("Strategy{ttlSeconds=").append(n).append(", distanceType=").append(string5).append(", discoveryMedium=").append(string6).append(", discoveryMode=").append(string7).append(", backgroundScanMode=").append(string8).append('}').toString();
    }

    static {
        zzkbc = BLE_ONLY = new Builder().zzes(2).setTtlSeconds(Integer.MAX_VALUE).build();
    }

    public static class Builder {
        private int zzkbk = 3;
        private int zzkbl = 300;
        private int zzkbm = 0;
        private int zzkbn = -1;
        private int zzkbo = 0;

        public Builder() {
        }

        public Builder setDiscoveryMode(int n) {
            this.zzkbk = n;
            return this;
        }

        @Hide
        public final Builder zzes(int n) {
            this.zzkbn = 2;
            return this;
        }

        public Builder setTtlSeconds(int n) {
            zzbq.zzb((n == Integer.MAX_VALUE || n > 0 && n <= 86400 ? 1 : 0) != 0, (String)"mTtlSeconds(%d) must either be TTL_SECONDS_INFINITE, or it must be between 1 and TTL_SECONDS_MAX(%d) inclusive", (Object[])new Object[]{n, 86400});
            this.zzkbl = n;
            return this;
        }

        public Builder setDistanceType(int n) {
            this.zzkbm = n;
            return this;
        }

        public Strategy build() {
            if (this.zzkbn == 2 && this.zzkbm == 1) {
                throw new IllegalStateException("Cannot set EARSHOT with BLE only mode.");
            }
            return new Strategy(2, 0, this.zzkbl, this.zzkbm, false, this.zzkbn, this.zzkbk, 0);
        }
    }
}

