/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.connection;

import android.os.ParcelFileDescriptor;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.UUID;

public class Payload {
    private final long id;
    @Type
    private final int type;
    @Nullable
    private final byte[] zzjwl;
    @Nullable
    private final File zzjwm;
    @Nullable
    private final Stream zzjwn;

    public static Payload fromBytes(byte[] byArray) {
        zzbq.checkNotNull((Object)byArray, (Object)"Cannot create a Payload from null bytes.");
        return Payload.zza(byArray, UUID.randomUUID().getLeastSignificantBits());
    }

    @Hide
    public static Payload zza(byte[] byArray, long l) {
        return new Payload(l, 1, byArray, null, null);
    }

    public static Payload fromFile(java.io.File file) throws FileNotFoundException {
        return Payload.zza(File.zza(file, file.length()), UUID.randomUUID().getLeastSignificantBits());
    }

    public static Payload fromFile(ParcelFileDescriptor parcelFileDescriptor) {
        return Payload.zza(File.zzb(parcelFileDescriptor), UUID.randomUUID().getLeastSignificantBits());
    }

    @Hide
    public static Payload zza(File file, long l) {
        return new Payload(l, 2, null, file, null);
    }

    public static Payload fromStream(InputStream inputStream) {
        return Payload.zza(Stream.zzf(inputStream), UUID.randomUUID().getLeastSignificantBits());
    }

    public static Payload fromStream(ParcelFileDescriptor parcelFileDescriptor) {
        return Payload.zza(Stream.zzc(parcelFileDescriptor), UUID.randomUUID().getLeastSignificantBits());
    }

    @Hide
    public static Payload zza(Stream stream, long l) {
        return new Payload(l, 3, null, null, stream);
    }

    private Payload(long l, int n, @Nullable byte[] byArray, @Nullable File file, @Nullable Stream stream) {
        this.id = l;
        this.type = n;
        this.zzjwl = byArray;
        this.zzjwm = file;
        this.zzjwn = stream;
    }

    public long getId() {
        return this.id;
    }

    @Type
    public int getType() {
        return this.type;
    }

    @Nullable
    public byte[] asBytes() {
        return this.zzjwl;
    }

    @Nullable
    public File asFile() {
        return this.zzjwm;
    }

    @Nullable
    public Stream asStream() {
        return this.zzjwn;
    }

    public static @interface Type {
        public static final int BYTES = 1;
        public static final int FILE = 2;
        public static final int STREAM = 3;
    }

    public static class Stream {
        @Nullable
        private final ParcelFileDescriptor zzjwp;
        @Nullable
        private InputStream zzjwq;

        @Hide
        public static Stream zzf(InputStream inputStream) {
            zzbq.checkNotNull((Object)inputStream, (Object)"Cannot create Payload.Stream from null InputStream.");
            return new Stream(null, inputStream);
        }

        @Hide
        public static Stream zzc(ParcelFileDescriptor parcelFileDescriptor) {
            zzbq.checkNotNull((Object)parcelFileDescriptor, (Object)"Cannot create Payload.Stream from null ParcelFileDescriptor.");
            return new Stream(parcelFileDescriptor, null);
        }

        private Stream(@Nullable ParcelFileDescriptor parcelFileDescriptor, @Nullable InputStream inputStream) {
            this.zzjwp = parcelFileDescriptor;
            this.zzjwq = inputStream;
        }

        @NonNull
        public InputStream asInputStream() {
            if (this.zzjwq == null) {
                this.zzjwq = new ParcelFileDescriptor.AutoCloseInputStream(this.zzjwp);
            }
            return this.zzjwq;
        }

        @Nullable
        public ParcelFileDescriptor asParcelFileDescriptor() {
            return this.zzjwp;
        }
    }

    public static class File {
        @Nullable
        private final java.io.File zzjwo;
        private final ParcelFileDescriptor zzjwp;
        private final long zziql;

        @Hide
        public static File zza(java.io.File file, long l) throws FileNotFoundException {
            return new File((java.io.File)zzbq.checkNotNull((Object)file, (Object)"Cannot create Payload.File from null java.io.File."), ParcelFileDescriptor.open((java.io.File)file, (int)0x10000000), l);
        }

        @Hide
        public static File zzb(ParcelFileDescriptor parcelFileDescriptor) {
            return new File(null, (ParcelFileDescriptor)zzbq.checkNotNull((Object)parcelFileDescriptor, (Object)"Cannot create Payload.File from null ParcelFileDescriptor."), parcelFileDescriptor.getStatSize());
        }

        private File(@Nullable java.io.File file, ParcelFileDescriptor parcelFileDescriptor, long l) {
            this.zzjwo = file;
            this.zzjwp = parcelFileDescriptor;
            this.zziql = l;
        }

        @Nullable
        public java.io.File asJavaFile() {
            return this.zzjwo;
        }

        @NonNull
        public ParcelFileDescriptor asParcelFileDescriptor() {
            return this.zzjwp;
        }

        public long getSize() {
            return this.zziql;
        }
    }
}

