/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Looper;
import android.os.RemoteException;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.api.zzi;
import com.google.android.gms.common.internal.zze;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.internal.zzla;
import com.google.android.gms.nearby.Nearby;
import com.google.android.gms.nearby.connection.AppMetadata;
import com.google.android.gms.nearby.connection.Connections;
import java.util.List;

public final class zzlb
implements Connections {
    public static final Api.zzc<zzla> zzKh = new Api.zzc();
    public static final Api.zzb<zzla, Api.ApiOptions.NoOptions> zzKi = new Api.zzb<zzla, Api.ApiOptions.NoOptions>(){

        public zzla zzl(Context context, Looper looper, zze zze2, Api.ApiOptions.NoOptions noOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return new zzla(context, looper, connectionCallbacks, onConnectionFailedListener);
        }

        public int getPriority() {
            return Integer.MAX_VALUE;
        }

        public /* synthetic */ Api.zza zza(Context context, Looper looper, zze zze2, Object object, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return this.zzl(context, looper, zze2, (Api.ApiOptions.NoOptions)object, connectionCallbacks, onConnectionFailedListener);
        }
    };

    public static zzla zzd(GoogleApiClient googleApiClient, boolean bl) {
        zzv.zzb((googleApiClient != null ? 1 : 0) != 0, (Object)"GoogleApiClient parameter is required.");
        zzv.zza((boolean)googleApiClient.isConnected(), (Object)"GoogleApiClient must be connected.");
        return zzlb.zze(googleApiClient, bl);
    }

    public static zzla zze(GoogleApiClient googleApiClient, boolean bl) {
        zzv.zza((boolean)googleApiClient.zza(Nearby.CONNECTIONS_API), (Object)"GoogleApiClient is not configured to use the Nearby Connections Api. Pass Nearby.CONNECTIONS_API into GoogleApiClient.Builder#addApi() to use this feature.");
        boolean bl2 = googleApiClient.hasConnectedApi(Nearby.CONNECTIONS_API);
        if (bl && !bl2) {
            throw new IllegalStateException("GoogleApiClient has an optional Nearby.CONNECTIONS_API and is not connected to Nearby Connections. Use GoogleApiClient.hasConnectedApi(Nearby.CONNECTIONS_API) to guard this call.");
        }
        return bl2 ? (zzla)googleApiClient.zza(zzKh) : null;
    }

    @Override
    public String getLocalEndpointId(GoogleApiClient apiClient) {
        return zzlb.zzd(apiClient, true).zzuU();
    }

    @Override
    public String getLocalDeviceId(GoogleApiClient apiClient) {
        return zzlb.zzd(apiClient, true).zzuV();
    }

    @Override
    public PendingResult<Connections.StartAdvertisingResult> startAdvertising(GoogleApiClient apiClient, final String name, final AppMetadata appMetadata, final long durationMillis, Connections.ConnectionRequestListener connectionRequestListener) {
        final zzi zzi2 = apiClient.zzl((Object)connectionRequestListener);
        return apiClient.zzb((zza.zza)new zzb(apiClient){

            protected void zza(zzla zzla2) throws RemoteException {
                zzla2.zza((zza.zzb<Connections.StartAdvertisingResult>)this, name, appMetadata, durationMillis, (zzi<Connections.ConnectionRequestListener>)zzi2);
            }
        });
    }

    @Override
    public void stopAdvertising(GoogleApiClient apiClient) {
        zzlb.zzd(apiClient, false).zzuW();
    }

    @Override
    public PendingResult<Status> startDiscovery(GoogleApiClient apiClient, final String serviceId, final long durationMillis, Connections.EndpointDiscoveryListener listener) {
        final zzi zzi2 = apiClient.zzl((Object)listener);
        return apiClient.zzb((zza.zza)new zzc(apiClient){

            protected void zza(zzla zzla2) throws RemoteException {
                zzla2.zza((zza.zzb<Status>)this, serviceId, durationMillis, (zzi<Connections.EndpointDiscoveryListener>)zzi2);
            }
        });
    }

    @Override
    public void stopDiscovery(GoogleApiClient apiClient, String serviceId) {
        zzlb.zzd(apiClient, false).zzdj(serviceId);
    }

    @Override
    public PendingResult<Status> sendConnectionRequest(GoogleApiClient apiClient, final String name, final String remoteEndpointId, final byte[] payload, Connections.ConnectionResponseCallback connectionResponseCallback, Connections.MessageListener messageListener) {
        final zzi zzi2 = apiClient.zzl((Object)connectionResponseCallback);
        final zzi zzi3 = apiClient.zzl((Object)messageListener);
        return apiClient.zzb((zza.zza)new zzc(apiClient){

            protected void zza(zzla zzla2) throws RemoteException {
                zzla2.zza((zza.zzb<Status>)this, name, remoteEndpointId, payload, (zzi<Connections.ConnectionResponseCallback>)zzi2, (zzi<Connections.MessageListener>)zzi3);
            }
        });
    }

    @Override
    public PendingResult<Status> acceptConnectionRequest(GoogleApiClient apiClient, final String remoteEndpointId, final byte[] payload, Connections.MessageListener messageListener) {
        final zzi zzi2 = apiClient.zzl((Object)messageListener);
        return apiClient.zzb((zza.zza)new zzc(apiClient){

            protected void zza(zzla zzla2) throws RemoteException {
                zzla2.zza((zza.zzb<Status>)this, remoteEndpointId, payload, (zzi<Connections.MessageListener>)zzi2);
            }
        });
    }

    @Override
    public PendingResult<Status> rejectConnectionRequest(GoogleApiClient apiClient, final String remoteEndpointId) {
        return apiClient.zzb((zza.zza)new zzc(apiClient){

            protected void zza(zzla zzla2) throws RemoteException {
                zzla2.zzq((zza.zzb<Status>)this, remoteEndpointId);
            }
        });
    }

    @Override
    public void sendReliableMessage(GoogleApiClient apiClient, String remoteEndpointId, byte[] payload) {
        zzlb.zzd(apiClient, false).zza(new String[]{remoteEndpointId}, payload);
    }

    @Override
    public void sendReliableMessage(GoogleApiClient apiClient, List<String> remoteEndpointIds, byte[] payload) {
        zzlb.zzd(apiClient, false).zza(remoteEndpointIds.toArray(new String[remoteEndpointIds.size()]), payload);
    }

    @Override
    public void sendUnreliableMessage(GoogleApiClient apiClient, String remoteEndpointId, byte[] payload) {
        zzlb.zzd(apiClient, false).zzb(new String[]{remoteEndpointId}, payload);
    }

    @Override
    public void sendUnreliableMessage(GoogleApiClient apiClient, List<String> remoteEndpointIds, byte[] payload) {
        zzlb.zzd(apiClient, false).zzb(remoteEndpointIds.toArray(new String[remoteEndpointIds.size()]), payload);
    }

    @Override
    public void disconnectFromEndpoint(GoogleApiClient apiClient, String remoteEndpointId) {
        zzlb.zzd(apiClient, false).zzdk(remoteEndpointId);
    }

    @Override
    public void stopAllEndpoints(GoogleApiClient apiClient) {
        zzlb.zzd(apiClient, false).zzuX();
    }

    private static abstract class zzc
    extends zza<Status> {
        private zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Status zzb(Status status) {
            return status;
        }

        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzb(x0);
        }
    }

    private static abstract class zzb
    extends zza<Connections.StartAdvertisingResult> {
        private zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Connections.StartAdvertisingResult zzaF(final Status status) {
            return new Connections.StartAdvertisingResult(){

                @Override
                public String getLocalEndpointName() {
                    return null;
                }

                public Status getStatus() {
                    return status;
                }
            };
        }

        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzaF(x0);
        }
    }

    private static abstract class zza<R extends Result>
    extends zza.zza<R, zzla> {
        public zza(GoogleApiClient googleApiClient) {
            super(zzKh, googleApiClient);
        }
    }
}

