/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Looper;
import android.os.RemoteException;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.api.zzi;
import com.google.android.gms.common.internal.zze;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.internal.zzop;
import com.google.android.gms.nearby.Nearby;
import com.google.android.gms.nearby.connection.AppMetadata;
import com.google.android.gms.nearby.connection.Connections;
import java.util.List;

public final class zzoq
implements Connections {
    public static final Api.ClientKey<zzop> zzNX = new Api.ClientKey();
    public static final Api.zza<zzop, Api.ApiOptions.NoOptions> zzNY = new Api.zza<zzop, Api.ApiOptions.NoOptions>(){

        public zzop zzq(Context context, Looper looper, zze zze2, Api.ApiOptions.NoOptions noOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return new zzop(context, looper, connectionCallbacks, onConnectionFailedListener);
        }

        public int getPriority() {
            return Integer.MAX_VALUE;
        }

        public /* synthetic */ Api.Client zza(Context context, Looper looper, zze zze2, Object object, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return this.zzq(context, looper, zze2, (Api.ApiOptions.NoOptions)object, connectionCallbacks, onConnectionFailedListener);
        }
    };

    public static zzop zzd(GoogleApiClient googleApiClient, boolean bl) {
        zzu.zzb((googleApiClient != null ? 1 : 0) != 0, (Object)"GoogleApiClient parameter is required.");
        zzu.zza((boolean)googleApiClient.isConnected(), (Object)"GoogleApiClient must be connected.");
        return zzoq.zze(googleApiClient, bl);
    }

    public static zzop zze(GoogleApiClient googleApiClient, boolean bl) {
        zzu.zza((boolean)googleApiClient.zza(Nearby.CONNECTIONS_API), (Object)"GoogleApiClient is not configured to use the Nearby Connections Api. Pass Nearby.CONNECTIONS_API into GoogleApiClient.Builder#addApi() to use this feature.");
        boolean bl2 = googleApiClient.hasConnectedApi(Nearby.CONNECTIONS_API);
        if (bl && !bl2) {
            throw new IllegalStateException("GoogleApiClient has an optional Nearby.CONNECTIONS_API and is not connected to Nearby Connections. Use GoogleApiClient.hasConnectedApi(Nearby.CONNECTIONS_API) to guard this call.");
        }
        return bl2 ? (zzop)googleApiClient.zza(zzNX) : null;
    }

    @Override
    public String getLocalEndpointId(GoogleApiClient apiClient) {
        return zzoq.zzd(apiClient, true).zzwR();
    }

    @Override
    public String getLocalDeviceId(GoogleApiClient apiClient) {
        return zzoq.zzd(apiClient, true).zzwS();
    }

    @Override
    public PendingResult<Connections.StartAdvertisingResult> startAdvertising(GoogleApiClient apiClient, final String name, final AppMetadata appMetadata, final long durationMillis, Connections.ConnectionRequestListener connectionRequestListener) {
        final zzi zzi2 = apiClient.zzo((Object)connectionRequestListener);
        return apiClient.zzb((zza.zza)new zzb(apiClient){

            protected void zza(zzop zzop2) throws RemoteException {
                zzop2.zza((zza.zzb<Connections.StartAdvertisingResult>)this, name, appMetadata, durationMillis, (zzi<Connections.ConnectionRequestListener>)zzi2);
            }
        });
    }

    @Override
    public void stopAdvertising(GoogleApiClient apiClient) {
        zzoq.zzd(apiClient, false).zzwT();
    }

    @Override
    public PendingResult<Status> startDiscovery(GoogleApiClient apiClient, final String serviceId, final long durationMillis, Connections.EndpointDiscoveryListener listener) {
        final zzi zzi2 = apiClient.zzo((Object)listener);
        return apiClient.zzb((zza.zza)new zzc(apiClient){

            protected void zza(zzop zzop2) throws RemoteException {
                zzop2.zza((zza.zzb<Status>)this, serviceId, durationMillis, (zzi<Connections.EndpointDiscoveryListener>)zzi2);
            }
        });
    }

    @Override
    public void stopDiscovery(GoogleApiClient apiClient, String serviceId) {
        zzoq.zzd(apiClient, false).zzdQ(serviceId);
    }

    @Override
    public PendingResult<Status> sendConnectionRequest(GoogleApiClient apiClient, final String name, final String remoteEndpointId, final byte[] payload, Connections.ConnectionResponseCallback connectionResponseCallback, Connections.MessageListener messageListener) {
        final zzi zzi2 = apiClient.zzo((Object)connectionResponseCallback);
        final zzi zzi3 = apiClient.zzo((Object)messageListener);
        return apiClient.zzb((zza.zza)new zzc(apiClient){

            protected void zza(zzop zzop2) throws RemoteException {
                zzop2.zza((zza.zzb<Status>)this, name, remoteEndpointId, payload, (zzi<Connections.ConnectionResponseCallback>)zzi2, (zzi<Connections.MessageListener>)zzi3);
            }
        });
    }

    @Override
    public PendingResult<Status> acceptConnectionRequest(GoogleApiClient apiClient, final String remoteEndpointId, final byte[] payload, Connections.MessageListener messageListener) {
        final zzi zzi2 = apiClient.zzo((Object)messageListener);
        return apiClient.zzb((zza.zza)new zzc(apiClient){

            protected void zza(zzop zzop2) throws RemoteException {
                zzop2.zza((zza.zzb<Status>)this, remoteEndpointId, payload, (zzi<Connections.MessageListener>)zzi2);
            }
        });
    }

    @Override
    public PendingResult<Status> rejectConnectionRequest(GoogleApiClient apiClient, final String remoteEndpointId) {
        return apiClient.zzb((zza.zza)new zzc(apiClient){

            protected void zza(zzop zzop2) throws RemoteException {
                zzop2.zzp((zza.zzb<Status>)this, remoteEndpointId);
            }
        });
    }

    @Override
    public void sendReliableMessage(GoogleApiClient apiClient, String remoteEndpointId, byte[] payload) {
        zzoq.zzd(apiClient, false).zza(new String[]{remoteEndpointId}, payload);
    }

    @Override
    public void sendReliableMessage(GoogleApiClient apiClient, List<String> remoteEndpointIds, byte[] payload) {
        zzoq.zzd(apiClient, false).zza(remoteEndpointIds.toArray(new String[remoteEndpointIds.size()]), payload);
    }

    @Override
    public void sendUnreliableMessage(GoogleApiClient apiClient, String remoteEndpointId, byte[] payload) {
        zzoq.zzd(apiClient, false).zzb(new String[]{remoteEndpointId}, payload);
    }

    @Override
    public void sendUnreliableMessage(GoogleApiClient apiClient, List<String> remoteEndpointIds, byte[] payload) {
        zzoq.zzd(apiClient, false).zzb(remoteEndpointIds.toArray(new String[remoteEndpointIds.size()]), payload);
    }

    @Override
    public void disconnectFromEndpoint(GoogleApiClient apiClient, String remoteEndpointId) {
        zzoq.zzd(apiClient, false).zzdR(remoteEndpointId);
    }

    @Override
    public void stopAllEndpoints(GoogleApiClient apiClient) {
        zzoq.zzd(apiClient, false).zzwU();
    }

    private static abstract class zzc
    extends zza<Status> {
        private zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Status zzb(Status status) {
            return status;
        }

        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzb(x0);
        }
    }

    private static abstract class zzb
    extends zza<Connections.StartAdvertisingResult> {
        private zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Connections.StartAdvertisingResult zzaM(final Status status) {
            return new Connections.StartAdvertisingResult(){

                @Override
                public String getLocalEndpointName() {
                    return null;
                }

                public Status getStatus() {
                    return status;
                }
            };
        }

        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzaM(x0);
        }
    }

    private static abstract class zza<R extends Result>
    extends zza.zza<R, zzop> {
        public zza(GoogleApiClient googleApiClient) {
            super(zzNX, googleApiClient);
        }
    }
}

