/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.nearby.messages.zzd;

public class Strategy
implements SafeParcelable {
    public static final Parcelable.Creator<Strategy> CREATOR = new zzd();
    public static final int DISCOVERY_MODE_BROADCAST = 1;
    public static final int DISCOVERY_MODE_SCAN = 2;
    public static final int DISCOVERY_MODE_DEFAULT = 3;
    public static final int DISTANCE_TYPE_DEFAULT = 0;
    public static final int DISTANCE_TYPE_EARSHOT = 1;
    public static final int TTL_SECONDS_DEFAULT = 300;
    public static final int TTL_SECONDS_MAX = 86400;
    public static final int TTL_SECONDS_INFINITE = Integer.MAX_VALUE;
    public static final Strategy DEFAULT = new Builder().build();
    public static final Strategy BLE_ONLY;
    @Deprecated
    public static final Strategy zzaJK;
    final int versionCode;
    @Deprecated
    final int zzaJL;
    final int zzaJM;
    final int zzaJN;
    @Deprecated
    final boolean zzaJO;
    final int zzaJP;
    final int zzaJQ;

    Strategy(int versionCode, int broadcastScanStrategy, int ttlSeconds, int distanceType, boolean isBleBeaconStrategy, int discoveryMedium, int discoveryMode) {
        this.versionCode = versionCode;
        this.zzaJL = broadcastScanStrategy;
        if (broadcastScanStrategy == 0) {
            this.zzaJQ = discoveryMode;
        } else {
            switch (broadcastScanStrategy) {
                case 2: {
                    this.zzaJQ = 1;
                    break;
                }
                case 3: {
                    this.zzaJQ = 2;
                    break;
                }
                default: {
                    this.zzaJQ = 3;
                }
            }
        }
        this.zzaJN = distanceType;
        this.zzaJO = isBleBeaconStrategy;
        if (isBleBeaconStrategy) {
            this.zzaJP = 2;
            this.zzaJM = Integer.MAX_VALUE;
        } else if (discoveryMedium == 0) {
            this.zzaJP = 1;
            this.zzaJM = ttlSeconds;
        } else {
            this.zzaJP = discoveryMedium;
            this.zzaJM = ttlSeconds;
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzd.zza(this, out, flags);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Strategy)) {
            return false;
        }
        Strategy strategy = (Strategy)other;
        return this.versionCode == strategy.versionCode && this.zzaJQ == strategy.zzaJQ && this.zzaJM == strategy.zzaJM && this.zzaJN == strategy.zzaJN && this.zzaJP == strategy.zzaJP;
    }

    public int hashCode() {
        int n = this.versionCode;
        n = 31 * n + this.zzaJQ;
        n = 31 * n + this.zzaJM;
        n = 31 * n + this.zzaJN;
        n = 31 * n + this.zzaJP;
        return n;
    }

    static {
        zzaJK = BLE_ONLY = new Builder().zzim(2).setTtlSeconds(Integer.MAX_VALUE).build();
    }

    public static class Builder {
        private int zzaJQ = 3;
        private int zzaJM = 300;
        private int zzaJN = 0;
        private int zzaJP = 1;

        public Builder setDiscoveryMode(int discoveryMode) {
            this.zzaJQ = discoveryMode;
            return this;
        }

        public Builder zzim(int n) {
            this.zzaJP = n;
            return this;
        }

        public Builder setTtlSeconds(int ttlSeconds) {
            zzx.zzb((ttlSeconds == Integer.MAX_VALUE || ttlSeconds > 0 && ttlSeconds <= 86400 ? 1 : 0) != 0, (String)"ttlSeconds(%d) must either be TTL_SECONDS_INFINITE, or it must be between 1 and TTL_SECONDS_MAX(%d) inclusive", (Object[])new Object[]{ttlSeconds, 86400});
            this.zzaJM = ttlSeconds;
            return this;
        }

        public Builder setDistanceType(int distanceType) {
            this.zzaJN = distanceType;
            return this;
        }

        public Strategy build() {
            if (this.zzaJP == 2) {
                if (this.zzaJQ != 3) {
                    throw new IllegalStateException("Discovery mode must be DISCOVERY_MODE_DEFAULT.");
                }
                if (this.zzaJN == 1) {
                    throw new IllegalStateException("Cannot set EARSHOT with BLE only mode.");
                }
            }
            return new Strategy(2, 0, this.zzaJM, this.zzaJN, false, this.zzaJP, this.zzaJQ);
        }
    }
}

