/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Looper;
import android.os.RemoteException;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzlx;
import com.google.android.gms.internal.zzmn;
import com.google.android.gms.internal.zzqz;
import com.google.android.gms.nearby.Nearby;
import com.google.android.gms.nearby.connection.AppMetadata;
import com.google.android.gms.nearby.connection.Connections;
import java.util.List;

public final class zzra
implements Connections {
    public static final Api.zzc<zzqz> zzTo = new Api.zzc();
    public static final Api.zza<zzqz, Api.ApiOptions.NoOptions> zzTp = new Api.zza<zzqz, Api.ApiOptions.NoOptions>(){

        public zzqz zzp(Context context, Looper looper, zzf zzf2, Api.ApiOptions.NoOptions noOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return new zzqz(context, looper, zzf2, connectionCallbacks, onConnectionFailedListener);
        }

        public /* synthetic */ Api.zzb zza(Context context, Looper looper, zzf zzf2, Object object, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return this.zzp(context, looper, zzf2, (Api.ApiOptions.NoOptions)object, connectionCallbacks, onConnectionFailedListener);
        }
    };

    public static zzqz zzd(GoogleApiClient googleApiClient, boolean bl) {
        zzx.zzb((googleApiClient != null ? 1 : 0) != 0, (Object)"GoogleApiClient parameter is required.");
        zzx.zza((boolean)googleApiClient.isConnected(), (Object)"GoogleApiClient must be connected.");
        return zzra.zze(googleApiClient, bl);
    }

    public static zzqz zze(GoogleApiClient googleApiClient, boolean bl) {
        zzx.zza((boolean)googleApiClient.zza(Nearby.CONNECTIONS_API), (Object)"GoogleApiClient is not configured to use the Nearby Connections Api. Pass Nearby.CONNECTIONS_API into GoogleApiClient.Builder#addApi() to use this feature.");
        boolean bl2 = googleApiClient.hasConnectedApi(Nearby.CONNECTIONS_API);
        if (bl && !bl2) {
            throw new IllegalStateException("GoogleApiClient has an optional Nearby.CONNECTIONS_API and is not connected to Nearby Connections. Use GoogleApiClient.hasConnectedApi(Nearby.CONNECTIONS_API) to guard this call.");
        }
        return bl2 ? (zzqz)googleApiClient.zza(zzTo) : null;
    }

    @Override
    public String getLocalEndpointId(GoogleApiClient apiClient) {
        return zzra.zzd(apiClient, true).zzCs();
    }

    @Override
    public String getLocalDeviceId(GoogleApiClient apiClient) {
        return zzra.zzd(apiClient, true).zzCt();
    }

    @Override
    public PendingResult<Connections.StartAdvertisingResult> startAdvertising(GoogleApiClient apiClient, final String name, final AppMetadata appMetadata, final long durationMillis, Connections.ConnectionRequestListener connectionRequestListener) {
        final zzmn zzmn2 = apiClient.zzq((Object)connectionRequestListener);
        return apiClient.zzb((zzlx.zza)new zzb(apiClient){

            protected void zza(zzqz zzqz2) throws RemoteException {
                zzqz2.zza((zzlx.zzb<Connections.StartAdvertisingResult>)this, name, appMetadata, durationMillis, (zzmn<Connections.ConnectionRequestListener>)zzmn2);
            }
        });
    }

    @Override
    public void stopAdvertising(GoogleApiClient apiClient) {
        zzra.zzd(apiClient, false).zzCu();
    }

    @Override
    public PendingResult<Status> startDiscovery(GoogleApiClient apiClient, final String serviceId, final long durationMillis, Connections.EndpointDiscoveryListener listener) {
        final zzmn zzmn2 = apiClient.zzq((Object)listener);
        return apiClient.zzb((zzlx.zza)new zzc(apiClient){

            protected void zza(zzqz zzqz2) throws RemoteException {
                zzqz2.zza((zzlx.zzb<Status>)this, serviceId, durationMillis, (zzmn<Connections.EndpointDiscoveryListener>)zzmn2);
            }
        });
    }

    @Override
    public void stopDiscovery(GoogleApiClient apiClient, String serviceId) {
        zzra.zzd(apiClient, false).zzeL(serviceId);
    }

    @Override
    public PendingResult<Status> sendConnectionRequest(GoogleApiClient apiClient, final String name, final String remoteEndpointId, final byte[] payload, Connections.ConnectionResponseCallback connectionResponseCallback, Connections.MessageListener messageListener) {
        final zzmn zzmn2 = apiClient.zzq((Object)connectionResponseCallback);
        final zzmn zzmn3 = apiClient.zzq((Object)messageListener);
        return apiClient.zzb((zzlx.zza)new zzc(apiClient){

            protected void zza(zzqz zzqz2) throws RemoteException {
                zzqz2.zza((zzlx.zzb<Status>)this, name, remoteEndpointId, payload, (zzmn<Connections.ConnectionResponseCallback>)zzmn2, (zzmn<Connections.MessageListener>)zzmn3);
            }
        });
    }

    @Override
    public PendingResult<Status> acceptConnectionRequest(GoogleApiClient apiClient, final String remoteEndpointId, final byte[] payload, Connections.MessageListener messageListener) {
        final zzmn zzmn2 = apiClient.zzq((Object)messageListener);
        return apiClient.zzb((zzlx.zza)new zzc(apiClient){

            protected void zza(zzqz zzqz2) throws RemoteException {
                zzqz2.zza((zzlx.zzb<Status>)this, remoteEndpointId, payload, (zzmn<Connections.MessageListener>)zzmn2);
            }
        });
    }

    @Override
    public PendingResult<Status> rejectConnectionRequest(GoogleApiClient apiClient, final String remoteEndpointId) {
        return apiClient.zzb((zzlx.zza)new zzc(apiClient){

            protected void zza(zzqz zzqz2) throws RemoteException {
                zzqz2.zzp((zzlx.zzb<Status>)this, remoteEndpointId);
            }
        });
    }

    @Override
    public void sendReliableMessage(GoogleApiClient apiClient, String remoteEndpointId, byte[] payload) {
        zzra.zzd(apiClient, false).zza(new String[]{remoteEndpointId}, payload);
    }

    @Override
    public void sendReliableMessage(GoogleApiClient apiClient, List<String> remoteEndpointIds, byte[] payload) {
        zzra.zzd(apiClient, false).zza(remoteEndpointIds.toArray(new String[remoteEndpointIds.size()]), payload);
    }

    @Override
    public void sendUnreliableMessage(GoogleApiClient apiClient, String remoteEndpointId, byte[] payload) {
        zzra.zzd(apiClient, false).zzb(new String[]{remoteEndpointId}, payload);
    }

    @Override
    public void sendUnreliableMessage(GoogleApiClient apiClient, List<String> remoteEndpointIds, byte[] payload) {
        zzra.zzd(apiClient, false).zzb(remoteEndpointIds.toArray(new String[remoteEndpointIds.size()]), payload);
    }

    @Override
    public void disconnectFromEndpoint(GoogleApiClient apiClient, String remoteEndpointId) {
        zzra.zzd(apiClient, false).zzeM(remoteEndpointId);
    }

    @Override
    public void stopAllEndpoints(GoogleApiClient apiClient) {
        zzra.zzd(apiClient, false).zzCv();
    }

    private static abstract class zzc
    extends zza<Status> {
        private zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Status zzb(Status status) {
            return status;
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzb(status);
        }
    }

    private static abstract class zzb
    extends zza<Connections.StartAdvertisingResult> {
        private zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Connections.StartAdvertisingResult zzaY(final Status status) {
            return new Connections.StartAdvertisingResult(){

                @Override
                public String getLocalEndpointName() {
                    return null;
                }

                public Status getStatus() {
                    return status;
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzaY(status);
        }
    }

    private static abstract class zza<R extends Result>
    extends zzlx.zza<R, zzqz> {
        public zza(GoogleApiClient googleApiClient) {
            super(zzTo, googleApiClient);
        }
    }
}

