/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.nearby.messages.devices.NearbyDevice;
import com.google.android.gms.nearby.messages.zza;
import java.util.Arrays;

public class Message
implements SafeParcelable {
    public static final int MAX_CONTENT_SIZE_BYTES = 102400;
    public static final int MAX_TYPE_LENGTH = 32;
    public static final Parcelable.Creator<Message> CREATOR = new zza();
    private static final NearbyDevice[] zzaWC = new NearbyDevice[]{NearbyDevice.zzaXe};
    final int versionCode;
    private final byte[] content;
    private final String type;
    private final String zzakM;
    private final NearbyDevice[] zzaWD;

    Message(int versionCode, byte[] content, String namespace, String type, NearbyDevice[] devices) {
        this.versionCode = versionCode;
        this.type = (String)zzx.zzy((Object)type);
        String string = this.zzakM = namespace == null ? "" : namespace;
        if (Message.zzO(this.zzakM, this.type)) {
            zzx.zzb((content == null ? 1 : 0) != 0, (Object)"Content must be null for a device presence message.");
        } else {
            zzx.zzy((Object)content);
            zzx.zzb((content.length <= 102400 ? 1 : 0) != 0, (String)"Content length(%d) must not exceed MAX_CONTENT_SIZE_BYTES(%d)", (Object[])new Object[]{content.length, 102400});
        }
        this.content = content;
        if (devices == null || devices.length == 0) {
            devices = zzaWC;
        }
        this.zzaWD = devices;
        zzx.zzb((type.length() <= 32 ? 1 : 0) != 0, (String)"Type length(%d) must not exceed MAX_TYPE_LENGTH(%d)", (Object[])new Object[]{type.length(), 32});
    }

    public static boolean zzO(String string, String string2) {
        return string.equals("__reserved_namespace") && string2.equals("__device_presence");
    }

    public Message(byte[] content) {
        this(content, "", "");
    }

    public Message(byte[] content, String type) {
        this(content, "", type);
    }

    public Message(byte[] content, String namespace, String type) {
        this(content, namespace, type, zzaWC);
    }

    public Message(byte[] content, String namespace, String type, NearbyDevice[] devices) {
        this(2, content, namespace, type, devices);
    }

    public String getType() {
        return this.type;
    }

    public String getNamespace() {
        return this.zzakM;
    }

    public byte[] getContent() {
        return this.content;
    }

    public NearbyDevice[] zzCw() {
        return this.zzaWD;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zza.zza(this, out, flags);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzakM, this.type, Arrays.hashCode(this.content)});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Message)) {
            return false;
        }
        Message message = (Message)object;
        return TextUtils.equals((CharSequence)this.zzakM, (CharSequence)message.zzakM) && TextUtils.equals((CharSequence)this.type, (CharSequence)message.type) && Arrays.equals(this.content, message.content);
    }

    public String toString() {
        return "Message{namespace='" + this.zzakM + "'" + ", type='" + this.type + "'" + ", content=[" + (this.content == null ? 0 : this.content.length) + " bytes]" + ", devices=" + Arrays.toString(this.zzCw()) + "}";
    }
}

