/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.nearby.messages.zzd;
import java.util.ArrayList;

public class Strategy
implements SafeParcelable {
    public static final Parcelable.Creator<Strategy> CREATOR = new zzd();
    public static final int DISCOVERY_MODE_BROADCAST = 1;
    public static final int DISCOVERY_MODE_SCAN = 2;
    public static final int DISCOVERY_MODE_DEFAULT = 3;
    public static final int DISTANCE_TYPE_DEFAULT = 0;
    public static final int DISTANCE_TYPE_EARSHOT = 1;
    public static final int TTL_SECONDS_DEFAULT = 300;
    public static final int TTL_SECONDS_MAX = 86400;
    public static final int TTL_SECONDS_INFINITE = Integer.MAX_VALUE;
    public static final Strategy DEFAULT = new Builder().build();
    public static final Strategy BLE_ONLY;
    @Deprecated
    public static final Strategy zzaWN;
    final int mVersionCode;
    @Deprecated
    final int zzaWO;
    final int zzaWP;
    final int zzaWQ;
    @Deprecated
    final boolean zzaWR;
    final int zzaWS;
    final int zzaWT;

    Strategy(int versionCode, int broadcastScanStrategy, int ttlSeconds, int distanceType, boolean isBleBeaconStrategy, int discoveryMedium, int discoveryMode) {
        this.mVersionCode = versionCode;
        this.zzaWO = broadcastScanStrategy;
        if (broadcastScanStrategy == 0) {
            this.zzaWT = discoveryMode;
        } else {
            switch (broadcastScanStrategy) {
                case 2: {
                    this.zzaWT = 1;
                    break;
                }
                case 3: {
                    this.zzaWT = 2;
                    break;
                }
                default: {
                    this.zzaWT = 3;
                }
            }
        }
        this.zzaWQ = distanceType;
        this.zzaWR = isBleBeaconStrategy;
        if (isBleBeaconStrategy) {
            this.zzaWS = 2;
            this.zzaWP = Integer.MAX_VALUE;
        } else if (discoveryMedium == 0) {
            this.zzaWS = 6;
            this.zzaWP = ttlSeconds;
        } else {
            this.zzaWS = discoveryMedium;
            this.zzaWP = ttlSeconds;
        }
    }

    public int zzCA() {
        return this.zzaWS;
    }

    public int zzCB() {
        return this.zzaWT;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzd.zza(this, out, flags);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Strategy)) {
            return false;
        }
        Strategy strategy = (Strategy)other;
        return this.mVersionCode == strategy.mVersionCode && this.zzaWT == strategy.zzaWT && this.zzaWP == strategy.zzaWP && this.zzaWQ == strategy.zzaWQ && this.zzaWS == strategy.zzaWS;
    }

    public int hashCode() {
        int n = this.mVersionCode;
        n = 31 * n + this.zzaWT;
        n = 31 * n + this.zzaWP;
        n = 31 * n + this.zzaWQ;
        n = 31 * n + this.zzaWS;
        return n;
    }

    public String toString() {
        return "Strategy{ttlSeconds=" + this.zzaWP + ", distanceType=" + Strategy.zziR(this.zzaWQ) + ", discoveryMedium=" + Strategy.zziS(this.zzaWS) + ", discoveryMode=" + Strategy.zziT(this.zzaWT) + '}';
    }

    private static String zziR(int n) {
        switch (n) {
            case 0: {
                return "DEFAULT";
            }
            case 1: {
                return "EARSHOT";
            }
        }
        return "UNKNOWN";
    }

    private static String zziS(int n) {
        if (n == 6) {
            return "DEFAULT";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if ((n & 4) > 0) {
            arrayList.add("AUDIO");
        }
        if ((n & 2) > 0) {
            arrayList.add("BLE");
        }
        return ((Object)arrayList).toString();
    }

    private static String zziT(int n) {
        if (n == 3) {
            return "DEFAULT";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if ((n & 1) > 0) {
            arrayList.add("BROADCAST");
        }
        if ((n & 2) > 0) {
            arrayList.add("SCAN");
        }
        return ((Object)arrayList).toString();
    }

    static {
        zzaWN = BLE_ONLY = new Builder().zziU(2).setTtlSeconds(Integer.MAX_VALUE).build();
    }

    public static class Builder {
        private int zzaWU = 3;
        private int zzaWV = 300;
        private int zzaWW = 0;
        private int zzaWX = 6;

        public Builder setDiscoveryMode(int discoveryMode) {
            this.zzaWU = discoveryMode;
            return this;
        }

        public Builder zziU(int n) {
            this.zzaWX = n;
            return this;
        }

        public Builder setTtlSeconds(int ttlSeconds) {
            zzx.zzb((ttlSeconds == Integer.MAX_VALUE || ttlSeconds > 0 && ttlSeconds <= 86400 ? 1 : 0) != 0, (String)"mTtlSeconds(%d) must either be TTL_SECONDS_INFINITE, or it must be between 1 and TTL_SECONDS_MAX(%d) inclusive", (Object[])new Object[]{ttlSeconds, 86400});
            this.zzaWV = ttlSeconds;
            return this;
        }

        public Builder setDistanceType(int distanceType) {
            this.zzaWW = distanceType;
            return this;
        }

        public Strategy build() {
            if (this.zzaWX == 2 && this.zzaWW == 1) {
                throw new IllegalStateException("Cannot set EARSHOT with BLE only mode.");
            }
            return new Strategy(2, 0, this.zzaWV, this.zzaWW, false, this.zzaWX, this.zzaWU);
        }
    }
}

