/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Looper;
import android.os.RemoteException;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zza;
import com.google.android.gms.common.api.internal.zzq;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzqk;
import com.google.android.gms.nearby.Nearby;
import com.google.android.gms.nearby.connection.AppMetadata;
import com.google.android.gms.nearby.connection.Connections;
import java.util.List;

public final class zzql
implements Connections {
    public static final Api.zzc<zzqk> zzUI = new Api.zzc();
    public static final Api.zza<zzqk, Api.ApiOptions.NoOptions> zzUJ = new Api.zza<zzqk, Api.ApiOptions.NoOptions>(){

        public zzqk zzp(Context context, Looper looper, zzf zzf2, Api.ApiOptions.NoOptions noOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return new zzqk(context, looper, zzf2, connectionCallbacks, onConnectionFailedListener);
        }

        public /* synthetic */ Api.zzb zza(Context context, Looper looper, zzf zzf2, Object object, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return this.zzp(context, looper, zzf2, (Api.ApiOptions.NoOptions)object, connectionCallbacks, onConnectionFailedListener);
        }
    };

    public static zzqk zzd(GoogleApiClient googleApiClient, boolean bl) {
        zzx.zzb((googleApiClient != null ? 1 : 0) != 0, (Object)"GoogleApiClient parameter is required.");
        zzx.zza((boolean)googleApiClient.isConnected(), (Object)"GoogleApiClient must be connected.");
        return zzql.zze(googleApiClient, bl);
    }

    public static zzqk zze(GoogleApiClient googleApiClient, boolean bl) {
        zzx.zza((boolean)googleApiClient.zza(Nearby.CONNECTIONS_API), (Object)"GoogleApiClient is not configured to use the Nearby Connections Api. Pass Nearby.CONNECTIONS_API into GoogleApiClient.Builder#addApi() to use this feature.");
        boolean bl2 = googleApiClient.hasConnectedApi(Nearby.CONNECTIONS_API);
        if (bl && !bl2) {
            throw new IllegalStateException("GoogleApiClient has an optional Nearby.CONNECTIONS_API and is not connected to Nearby Connections. Use GoogleApiClient.hasConnectedApi(Nearby.CONNECTIONS_API) to guard this call.");
        }
        return bl2 ? (zzqk)googleApiClient.zza(zzUI) : null;
    }

    @Override
    public String getLocalEndpointId(GoogleApiClient apiClient) {
        return zzql.zzd(apiClient, true).zzEj();
    }

    @Override
    public String getLocalDeviceId(GoogleApiClient apiClient) {
        return zzql.zzd(apiClient, true).zzEk();
    }

    @Override
    public PendingResult<Connections.StartAdvertisingResult> startAdvertising(GoogleApiClient apiClient, final String name, final AppMetadata appMetadata, final long durationMillis, Connections.ConnectionRequestListener connectionRequestListener) {
        final zzq zzq2 = apiClient.zzr((Object)connectionRequestListener);
        return apiClient.zzb((zza.zza)new zzb(apiClient){

            protected void zza(zzqk zzqk2) throws RemoteException {
                zzqk2.zza((zza.zzb<Connections.StartAdvertisingResult>)this, name, appMetadata, durationMillis, (zzq<Connections.ConnectionRequestListener>)zzq2);
            }
        });
    }

    @Override
    public void stopAdvertising(GoogleApiClient apiClient) {
        zzql.zzd(apiClient, false).zzEl();
    }

    @Override
    public PendingResult<Status> startDiscovery(GoogleApiClient apiClient, final String serviceId, final long durationMillis, Connections.EndpointDiscoveryListener listener) {
        final zzq zzq2 = apiClient.zzr((Object)listener);
        return apiClient.zzb((zza.zza)new zzc(apiClient){

            protected void zza(zzqk zzqk2) throws RemoteException {
                zzqk2.zza((zza.zzb<Status>)this, serviceId, durationMillis, (zzq<Connections.EndpointDiscoveryListener>)zzq2);
            }
        });
    }

    @Override
    public void stopDiscovery(GoogleApiClient apiClient, String serviceId) {
        zzql.zzd(apiClient, false).zzfz(serviceId);
    }

    @Override
    public PendingResult<Status> sendConnectionRequest(GoogleApiClient apiClient, final String name, final String remoteEndpointId, final byte[] payload, Connections.ConnectionResponseCallback connectionResponseCallback, Connections.MessageListener messageListener) {
        final zzq zzq2 = apiClient.zzr((Object)connectionResponseCallback);
        final zzq zzq3 = apiClient.zzr((Object)messageListener);
        return apiClient.zzb((zza.zza)new zzc(apiClient){

            protected void zza(zzqk zzqk2) throws RemoteException {
                zzqk2.zza((zza.zzb<Status>)this, name, remoteEndpointId, payload, (zzq<Connections.ConnectionResponseCallback>)zzq2, (zzq<Connections.MessageListener>)zzq3);
            }
        });
    }

    @Override
    public PendingResult<Status> acceptConnectionRequest(GoogleApiClient apiClient, final String remoteEndpointId, final byte[] payload, Connections.MessageListener messageListener) {
        final zzq zzq2 = apiClient.zzr((Object)messageListener);
        return apiClient.zzb((zza.zza)new zzc(apiClient){

            protected void zza(zzqk zzqk2) throws RemoteException {
                zzqk2.zza((zza.zzb<Status>)this, remoteEndpointId, payload, (zzq<Connections.MessageListener>)zzq2);
            }
        });
    }

    @Override
    public PendingResult<Status> rejectConnectionRequest(GoogleApiClient apiClient, final String remoteEndpointId) {
        return apiClient.zzb((zza.zza)new zzc(apiClient){

            protected void zza(zzqk zzqk2) throws RemoteException {
                zzqk2.zzp((zza.zzb<Status>)this, remoteEndpointId);
            }
        });
    }

    @Override
    public void sendReliableMessage(GoogleApiClient apiClient, String remoteEndpointId, byte[] payload) {
        zzql.zzd(apiClient, false).zza(new String[]{remoteEndpointId}, payload);
    }

    @Override
    public void sendReliableMessage(GoogleApiClient apiClient, List<String> remoteEndpointIds, byte[] payload) {
        zzql.zzd(apiClient, false).zza(remoteEndpointIds.toArray(new String[remoteEndpointIds.size()]), payload);
    }

    @Override
    public void sendUnreliableMessage(GoogleApiClient apiClient, String remoteEndpointId, byte[] payload) {
        zzql.zzd(apiClient, false).zzb(new String[]{remoteEndpointId}, payload);
    }

    @Override
    public void sendUnreliableMessage(GoogleApiClient apiClient, List<String> remoteEndpointIds, byte[] payload) {
        zzql.zzd(apiClient, false).zzb(remoteEndpointIds.toArray(new String[remoteEndpointIds.size()]), payload);
    }

    @Override
    public void disconnectFromEndpoint(GoogleApiClient apiClient, String remoteEndpointId) {
        zzql.zzd(apiClient, false).zzfA(remoteEndpointId);
    }

    @Override
    public void stopAllEndpoints(GoogleApiClient apiClient) {
        zzql.zzd(apiClient, false).zzEm();
    }

    private static abstract class zzc
    extends zza<Status> {
        private zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Status zzb(Status status) {
            return status;
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzb(status);
        }
    }

    private static abstract class zzb
    extends zza<Connections.StartAdvertisingResult> {
        private zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Connections.StartAdvertisingResult zzbc(final Status status) {
            return new Connections.StartAdvertisingResult(){

                @Override
                public String getLocalEndpointName() {
                    return null;
                }

                public Status getStatus() {
                    return status;
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzbc(status);
        }
    }

    private static abstract class zza<R extends Result>
    extends zza.zza<R, zzqk> {
        public zza(GoogleApiClient googleApiClient) {
            super(zzUI, googleApiClient);
        }
    }
}

