/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.nearby.messages.devices.NearbyDeviceFilter;
import com.google.android.gms.nearby.messages.internal.MessageType;
import com.google.android.gms.nearby.messages.zzb;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MessageFilter
implements SafeParcelable {
    public static final Parcelable.Creator<MessageFilter> CREATOR = new zzb();
    public static final MessageFilter INCLUDE_ALL_MY_TYPES = new Builder().includeAllMyTypes().build();
    final int mVersionCode;
    private final List<MessageType> zzbbB;
    private final List<NearbyDeviceFilter> zzbbC;
    private final boolean zzbbD;

    MessageFilter(int versionCode, List<MessageType> messageTypes, List<NearbyDeviceFilter> deviceFilters, boolean includeAllMyTypes) {
        this.mVersionCode = versionCode;
        this.zzbbB = Collections.unmodifiableList((List)zzx.zzz(messageTypes));
        this.zzbbD = includeAllMyTypes;
        if (deviceFilters == null) {
            deviceFilters = Collections.emptyList();
        }
        this.zzbbC = Collections.unmodifiableList(deviceFilters);
    }

    private MessageFilter(List<MessageType> messageTypes, List<NearbyDeviceFilter> deviceFilters, boolean includeAllMyTypes) {
        this(1, messageTypes, deviceFilters, includeAllMyTypes);
    }

    List<MessageType> zzEo() {
        return this.zzbbB;
    }

    boolean zzEp() {
        return this.zzbbD;
    }

    List<NearbyDeviceFilter> zzEq() {
        return this.zzbbC;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzb.zza(this, dest, flags);
    }

    public String toString() {
        return "MessageFilter{includeAllMyTypes=" + this.zzbbD + ", messageTypes=" + this.zzbbB + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MessageFilter)) {
            return false;
        }
        MessageFilter messageFilter = (MessageFilter)o;
        return this.zzbbD == messageFilter.zzbbD && zzw.equal(this.zzbbB, messageFilter.zzbbB) && zzw.equal(this.zzbbC, messageFilter.zzbbC);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzbbB, this.zzbbC, this.zzbbD});
    }

    public static final class Builder {
        private final List<MessageType> zzbbE = new ArrayList<MessageType>();
        private final List<NearbyDeviceFilter> zzbbC = new ArrayList<NearbyDeviceFilter>();
        private boolean zzbbD;

        public Builder includeAllMyTypes() {
            this.zzbbD = true;
            return this;
        }

        public Builder includeNamespacedType(String namespace, String type) {
            zzx.zzb((namespace != null && !namespace.isEmpty() && !namespace.contains("*") ? 1 : 0) != 0, (String)"namespace(%s) cannot be null, empty or contain (*).", (Object[])new Object[]{namespace});
            zzx.zzb((type != null && !type.contains("*") ? 1 : 0) != 0, (String)"type(%s) cannot be null or contain (*).", (Object[])new Object[]{type});
            return this.zzS(namespace, type);
        }

        public Builder includeFilter(MessageFilter filter) {
            this.zzbbE.addAll(filter.zzEo());
            this.zzbbC.addAll(filter.zzEq());
            this.zzbbD |= filter.zzEp();
            return this;
        }

        private Builder zzS(String string, String string2) {
            this.zzbbE.add(new MessageType(string, string2));
            return this;
        }

        public MessageFilter build() {
            zzx.zza((this.zzbbD || !this.zzbbE.isEmpty() ? 1 : 0) != 0, (Object)"At least one of the include methods must be called.");
            return new MessageFilter(this.zzbbE, this.zzbbC, this.zzbbD);
        }
    }
}

