/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.nearby.messages.zzd;
import java.util.ArrayList;

public class Strategy
implements SafeParcelable {
    public static final Parcelable.Creator<Strategy> CREATOR = new zzd();
    public static final int DISCOVERY_MODE_BROADCAST = 1;
    public static final int DISCOVERY_MODE_SCAN = 2;
    public static final int DISCOVERY_MODE_DEFAULT = 3;
    public static final int DISTANCE_TYPE_DEFAULT = 0;
    public static final int DISTANCE_TYPE_EARSHOT = 1;
    public static final int TTL_SECONDS_DEFAULT = 300;
    public static final int TTL_SECONDS_MAX = 86400;
    public static final int TTL_SECONDS_INFINITE = Integer.MAX_VALUE;
    public static final Strategy DEFAULT = new Builder().build();
    public static final Strategy BLE_ONLY;
    @Deprecated
    public static final Strategy zzbbK;
    final int mVersionCode;
    @Deprecated
    final int zzbbL;
    final int zzbbM;
    final int zzbbN;
    @Deprecated
    final boolean zzbbO;
    final int zzbbP;
    final int zzbbQ;

    Strategy(int versionCode, int broadcastScanStrategy, int ttlSeconds, int distanceType, boolean isBleBeaconStrategy, int discoveryMedium, int discoveryMode) {
        this.mVersionCode = versionCode;
        this.zzbbL = broadcastScanStrategy;
        if (broadcastScanStrategy == 0) {
            this.zzbbQ = discoveryMode;
        } else {
            switch (broadcastScanStrategy) {
                case 2: {
                    this.zzbbQ = 1;
                    break;
                }
                case 3: {
                    this.zzbbQ = 2;
                    break;
                }
                default: {
                    this.zzbbQ = 3;
                }
            }
        }
        this.zzbbN = distanceType;
        this.zzbbO = isBleBeaconStrategy;
        if (isBleBeaconStrategy) {
            this.zzbbP = 2;
            this.zzbbM = Integer.MAX_VALUE;
        } else {
            this.zzbbM = ttlSeconds;
            switch (discoveryMedium) {
                case -1: 
                case 0: 
                case 1: 
                case 6: {
                    this.zzbbP = -1;
                    break;
                }
                default: {
                    this.zzbbP = discoveryMedium;
                }
            }
        }
    }

    public int zzEr() {
        return this.zzbbP;
    }

    public int zzEs() {
        return this.zzbbQ;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzd.zza(this, out, flags);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Strategy)) {
            return false;
        }
        Strategy strategy = (Strategy)other;
        return this.mVersionCode == strategy.mVersionCode && this.zzbbQ == strategy.zzbbQ && this.zzbbM == strategy.zzbbM && this.zzbbN == strategy.zzbbN && this.zzbbP == strategy.zzbbP;
    }

    public int hashCode() {
        int n = this.mVersionCode;
        n = 31 * n + this.zzbbQ;
        n = 31 * n + this.zzbbM;
        n = 31 * n + this.zzbbN;
        n = 31 * n + this.zzbbP;
        return n;
    }

    public String toString() {
        return "Strategy{ttlSeconds=" + this.zzbbM + ", distanceType=" + Strategy.zzjd(this.zzbbN) + ", discoveryMedium=" + Strategy.zzje(this.zzbbP) + ", discoveryMode=" + Strategy.zzjf(this.zzbbQ) + '}';
    }

    private static String zzjd(int n) {
        switch (n) {
            case 0: {
                return "DEFAULT";
            }
            case 1: {
                return "EARSHOT";
            }
        }
        return "UNKNOWN:" + n;
    }

    private static String zzje(int n) {
        if (n == -1) {
            return "DEFAULT";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if ((n & 4) > 0) {
            arrayList.add("AUDIO");
        }
        if ((n & 2) > 0) {
            arrayList.add("BLE");
        }
        if (arrayList.isEmpty()) {
            return "UNKNOWN:" + n;
        }
        return ((Object)arrayList).toString();
    }

    private static String zzjf(int n) {
        if (n == 3) {
            return "DEFAULT";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if ((n & 1) > 0) {
            arrayList.add("BROADCAST");
        }
        if ((n & 2) > 0) {
            arrayList.add("SCAN");
        }
        if (arrayList.isEmpty()) {
            return "UNKNOWN:" + n;
        }
        return ((Object)arrayList).toString();
    }

    static {
        zzbbK = BLE_ONLY = new Builder().zzjg(2).setTtlSeconds(Integer.MAX_VALUE).build();
    }

    public static class Builder {
        private int zzbbR = 3;
        private int zzbbS = 300;
        private int zzbbT = 0;
        private int zzbbU = -1;

        public Builder setDiscoveryMode(int discoveryMode) {
            this.zzbbR = discoveryMode;
            return this;
        }

        public Builder zzjg(int n) {
            this.zzbbU = n;
            return this;
        }

        public Builder setTtlSeconds(int ttlSeconds) {
            zzx.zzb((ttlSeconds == Integer.MAX_VALUE || ttlSeconds > 0 && ttlSeconds <= 86400 ? 1 : 0) != 0, (String)"mTtlSeconds(%d) must either be TTL_SECONDS_INFINITE, or it must be between 1 and TTL_SECONDS_MAX(%d) inclusive", (Object[])new Object[]{ttlSeconds, 86400});
            this.zzbbS = ttlSeconds;
            return this;
        }

        public Builder setDistanceType(int distanceType) {
            this.zzbbT = distanceType;
            return this;
        }

        public Strategy build() {
            if (this.zzbbU == 2 && this.zzbbT == 1) {
                throw new IllegalStateException("Cannot set EARSHOT with BLE only mode.");
            }
            return new Strategy(2, 0, this.zzbbS, this.zzbbT, false, this.zzbbU, this.zzbbR);
        }
    }
}

