/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Looper;
import android.os.RemoteException;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.internal.zznt;
import com.google.android.gms.internal.zzou;
import com.google.android.gms.nearby.Nearby;
import com.google.android.gms.nearby.messages.Message;
import com.google.android.gms.nearby.messages.MessageListener;
import com.google.android.gms.nearby.messages.Messages;
import com.google.android.gms.nearby.messages.MessagesOptions;
import com.google.android.gms.nearby.messages.PublishOptions;
import com.google.android.gms.nearby.messages.StatusCallback;
import com.google.android.gms.nearby.messages.SubscribeOptions;
import com.google.android.gms.nearby.messages.internal.MessageWrapper;
import com.google.android.gms.nearby.messages.internal.Update;
import com.google.android.gms.nearby.messages.internal.zzl;
import com.google.android.gms.nearby.messages.internal.zzo;
import java.util.List;

public class zzp
implements Messages {
    public static final Api.zzf<zzo> zzaaz = new Api.zzf();
    public static final Api.zza<zzo, MessagesOptions> zzaaA = new Api.zza<zzo, MessagesOptions>(){

        public zzo zza(Context context, Looper looper, zzg zzg2, MessagesOptions messagesOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return new zzo(context, looper, connectionCallbacks, onConnectionFailedListener, zzg2, messagesOptions);
        }

        public int getPriority() {
            return Integer.MAX_VALUE;
        }
    };

    @Override
    public PendingResult<Status> publish(GoogleApiClient googleApiClient, final Message message, final PublishOptions publishOptions) {
        zzaa.zzz((Object)((Object)message));
        zzaa.zzz((Object)publishOptions);
        return googleApiClient.zzd((zznt.zza)new zza(googleApiClient){

            protected void zza(zzo zzo2) throws RemoteException {
                MessageWrapper messageWrapper = MessageWrapper.zza(message);
                zzo2.zza((zznt.zzb<Status>)this, messageWrapper, publishOptions);
            }
        });
    }

    @Override
    public PendingResult<Status> publish(GoogleApiClient googleApiClient, Message message) {
        return this.publish(googleApiClient, message, PublishOptions.DEFAULT);
    }

    @Override
    public PendingResult<Status> unpublish(GoogleApiClient googleApiClient, final Message message) {
        zzaa.zzz((Object)((Object)message));
        return googleApiClient.zzd((zznt.zza)new zza(googleApiClient){

            protected void zza(zzo zzo2) throws RemoteException {
                MessageWrapper messageWrapper = MessageWrapper.zza(message);
                zzo2.zza((zznt.zzb<Status>)this, messageWrapper);
            }
        });
    }

    @Override
    public PendingResult<Status> subscribe(GoogleApiClient googleApiClient, final MessageListener messageListener, final SubscribeOptions subscribeOptions) {
        zzaa.zzz((Object)messageListener);
        zzaa.zzz((Object)subscribeOptions);
        final zzou<MessageListener> zzou2 = ((zzo)googleApiClient.zza(zzaaz)).zza(googleApiClient, messageListener);
        return googleApiClient.zzd((zznt.zza)new zza(googleApiClient){

            protected void zza(zzo zzo2) throws RemoteException {
                zzo2.zza((zznt.zzb<Status>)this, (zzou<MessageListener>)zzou2, messageListener, subscribeOptions, null);
            }
        });
    }

    @Override
    public PendingResult<Status> subscribe(GoogleApiClient googleApiClient, MessageListener messageListener) {
        return this.subscribe(googleApiClient, messageListener, SubscribeOptions.DEFAULT);
    }

    @Override
    public PendingResult<Status> subscribe(GoogleApiClient googleApiClient, final PendingIntent pendingIntent, final SubscribeOptions subscribeOptions) {
        zzaa.zzz((Object)pendingIntent);
        zzaa.zzz((Object)subscribeOptions);
        return googleApiClient.zzd((zznt.zza)new zza(googleApiClient){

            protected void zza(zzo zzo2) throws RemoteException {
                zzo2.zza((zznt.zzb<Status>)this, pendingIntent, subscribeOptions);
            }
        });
    }

    @Override
    public PendingResult<Status> subscribe(GoogleApiClient googleApiClient, PendingIntent pendingIntent) {
        return this.subscribe(googleApiClient, pendingIntent, SubscribeOptions.DEFAULT);
    }

    @Override
    public PendingResult<Status> unsubscribe(GoogleApiClient googleApiClient, final MessageListener messageListener) {
        zzaa.zzz((Object)messageListener);
        final zzou<MessageListener> zzou2 = ((zzo)googleApiClient.zza(zzaaz)).zza(googleApiClient, messageListener);
        return googleApiClient.zzd((zznt.zza)new zza(googleApiClient){

            protected void zza(zzo zzo2) throws RemoteException {
                zzo2.zza((zznt.zzb<Status>)this, (zzou<MessageListener>)zzou2, messageListener);
            }
        });
    }

    @Override
    public PendingResult<Status> unsubscribe(GoogleApiClient googleApiClient, final PendingIntent pendingIntent) {
        zzaa.zzz((Object)pendingIntent);
        return googleApiClient.zzd((zznt.zza)new zza(googleApiClient){

            protected void zza(zzo zzo2) throws RemoteException {
                zzo2.zza((zznt.zzb<Status>)this, pendingIntent);
            }
        });
    }

    @Override
    public void handleIntent(Intent intent, MessageListener messageListener) {
        zzp.zza(zzp.zzy(intent), messageListener);
    }

    static void zza(Iterable<Update> iterable, MessageListener messageListener) {
        for (Update update : iterable) {
            if (update.zzkl(1)) {
                messageListener.onFound(update.zzbjL);
            }
            if (update.zzkl(2)) {
                messageListener.onLost(update.zzbjL);
            }
            if (update.zzkl(4)) {
                messageListener.zza(update.zzbjL, update.zzbkv);
            }
            if (!update.zzkl(8)) continue;
            messageListener.zza(update.zzbjL, update.zzbkw);
        }
    }

    private static List<Update> zzy(Intent intent) {
        return zzl.zzc(intent, "com.google.android.gms.nearby.messages.UPDATES");
    }

    @Override
    public PendingResult<Status> getPermissionStatus(GoogleApiClient googleApiClient) {
        return googleApiClient.zzd((zznt.zza)new zza(googleApiClient){

            protected void zza(zzo zzo2) throws RemoteException {
                zzo2.zzr((zznt.zzb<Status>)this);
            }
        });
    }

    @Override
    public PendingResult<Status> registerStatusCallback(GoogleApiClient googleApiClient, final StatusCallback statusCallback) {
        zzaa.zzz((Object)statusCallback);
        final zzou<StatusCallback> zzou2 = ((zzo)googleApiClient.zza(zzaaz)).zza(googleApiClient, statusCallback);
        return googleApiClient.zzd((zznt.zza)new zza(googleApiClient){

            protected void zza(zzo zzo2) throws RemoteException {
                zzo2.zza((zznt.zzb<Status>)this, (zzou<StatusCallback>)zzou2, statusCallback);
            }
        });
    }

    @Override
    public PendingResult<Status> unregisterStatusCallback(GoogleApiClient googleApiClient, final StatusCallback statusCallback) {
        final zzou<StatusCallback> zzou2 = ((zzo)googleApiClient.zza(zzaaz)).zza(googleApiClient, statusCallback);
        return googleApiClient.zzd((zznt.zza)new zza(googleApiClient){

            protected void zza(zzo zzo2) throws RemoteException {
                zzo2.zzb((zznt.zzb<Status>)this, (zzou<StatusCallback>)zzou2, statusCallback);
            }
        });
    }

    static abstract class zza
    extends zznt.zza<Status, zzo> {
        public zza(GoogleApiClient googleApiClient) {
            super(Nearby.MESSAGES_API, googleApiClient);
        }

        public Status zzb(Status status) {
            return status;
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzb(status);
        }
    }
}

