/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.SimpleArrayMap;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzk;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zznt;
import com.google.android.gms.internal.zzou;
import com.google.android.gms.nearby.messages.MessageListener;
import com.google.android.gms.nearby.messages.MessagesOptions;
import com.google.android.gms.nearby.messages.PublishCallback;
import com.google.android.gms.nearby.messages.PublishOptions;
import com.google.android.gms.nearby.messages.StatusCallback;
import com.google.android.gms.nearby.messages.SubscribeCallback;
import com.google.android.gms.nearby.messages.SubscribeOptions;
import com.google.android.gms.nearby.messages.internal.ClientAppContext;
import com.google.android.gms.nearby.messages.internal.GetPermissionStatusRequest;
import com.google.android.gms.nearby.messages.internal.HandleClientLifecycleEventRequest;
import com.google.android.gms.nearby.messages.internal.MessageWrapper;
import com.google.android.gms.nearby.messages.internal.PublishRequest;
import com.google.android.gms.nearby.messages.internal.RegisterStatusCallbackRequest;
import com.google.android.gms.nearby.messages.internal.SubscribeRequest;
import com.google.android.gms.nearby.messages.internal.UnpublishRequest;
import com.google.android.gms.nearby.messages.internal.UnsubscribeRequest;
import com.google.android.gms.nearby.messages.internal.Update;
import com.google.android.gms.nearby.messages.internal.zzf;
import com.google.android.gms.nearby.messages.internal.zzh;
import com.google.android.gms.nearby.messages.internal.zzi;
import com.google.android.gms.nearby.messages.internal.zzj;
import com.google.android.gms.nearby.messages.internal.zzk;
import com.google.android.gms.nearby.messages.internal.zzp;
import com.google.android.gms.nearby.messages.internal.zzr;
import java.util.List;

class zzo
extends zzk<com.google.android.gms.nearby.messages.internal.zzh> {
    private final ClientAppContext zzbjM;
    private final int zzbiV;
    private final zzh<StatusCallback, zzf> zzbjN = new zzh<StatusCallback, zzf>(){

        protected zzf zzf(zzou<StatusCallback> zzou2) {
            return new zzf(zzou2);
        }

        @Override
        protected /* synthetic */ zza zzg(zzou zzou2) {
            return this.zzf((zzou<StatusCallback>)zzou2);
        }
    };
    private final zzh<MessageListener, zzc> zzbjO = new zzh<MessageListener, zzc>(){

        protected zzc zzh(zzou<MessageListener> zzou2) {
            return new zzc(zzou2);
        }

        @Override
        protected /* synthetic */ zza zzg(zzou zzou2) {
            return this.zzh((zzou<MessageListener>)zzou2);
        }
    };

    private static int zzbe(Context context) {
        if (context instanceof Activity) {
            return 1;
        }
        if (context instanceof Application) {
            return 2;
        }
        if (context instanceof Service) {
            return 3;
        }
        return 0;
    }

    @TargetApi(value=14)
    zzo(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, com.google.android.gms.common.internal.zzg zzg2, MessagesOptions messagesOptions) {
        super(context, looper, 62, zzg2, connectionCallbacks, onConnectionFailedListener);
        String string = zzg2.zzty();
        int n = zzo.zzbe(context);
        if (messagesOptions != null) {
            this.zzbjM = new ClientAppContext(string, messagesOptions.zzbiR, messagesOptions.zzbiS, messagesOptions.zzbiU, n);
            this.zzbiV = messagesOptions.zzbiT;
        } else {
            this.zzbjM = new ClientAppContext(string, null, false, null, n);
            this.zzbiV = -1;
        }
        if (n == 1 && zzs.zzva()) {
            Activity activity = (Activity)context;
            Log.v((String)"NearbyMessagesClient", (String)String.format("Registering ClientLifecycleSafetyNet's ActivityLifecycleCallbacks for %s", activity.getPackageName()));
            activity.getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new zzb(activity, this));
        }
    }

    @NonNull
    protected Bundle zzoO() {
        Bundle bundle = super.zzoO();
        bundle.putInt("NearbyPermissions", this.zzbiV);
        bundle.putParcelable("ClientAppContext", (Parcelable)this.zzbjM);
        return bundle;
    }

    @NonNull
    protected String zzhT() {
        return "com.google.android.gms.nearby.messages.service.NearbyMessagesService.START";
    }

    @NonNull
    protected String zzhU() {
        return "com.google.android.gms.nearby.messages.internal.INearbyMessagesService";
    }

    protected com.google.android.gms.nearby.messages.internal.zzh zzdM(IBinder iBinder) {
        return zzh.zza.zzdI(iBinder);
    }

    public void disconnect() {
        try {
            this.zzkf(2);
        }
        catch (RemoteException remoteException) {
            Log.v((String)"NearbyMessagesClient", (String)String.format("Failed to emit CLIENT_DISCONNECTED from override of GmsClient#disconnect(): %s", new Object[]{remoteException}));
        }
        super.disconnect();
    }

    void zza(zznt.zzb<Status> zzb2, MessageWrapper messageWrapper, PublishOptions publishOptions) throws RemoteException {
        PublishRequest publishRequest = new PublishRequest(messageWrapper, publishOptions.getStrategy(), (IBinder)zzr.zzs(zzb2), (IBinder)zze.zza(publishOptions.getCallback()));
        ((com.google.android.gms.nearby.messages.internal.zzh)this.zztm()).zza(publishRequest);
    }

    void zza(zznt.zzb<Status> zzb2, MessageWrapper messageWrapper) throws RemoteException {
        UnpublishRequest unpublishRequest = new UnpublishRequest(messageWrapper, (IBinder)zzr.zzs(zzb2), this.zzbjM);
        ((com.google.android.gms.nearby.messages.internal.zzh)this.zztm()).zza(unpublishRequest);
    }

    void zza(zznt.zzb<Status> zzb2, zzou<MessageListener> zzou2, MessageListener messageListener, SubscribeOptions subscribeOptions, @Nullable byte[] byArray) throws RemoteException {
        SubscribeRequest subscribeRequest = new SubscribeRequest((IBinder)this.zzbjO.zza(zzou2, messageListener), subscribeOptions.getStrategy(), (IBinder)zzr.zzs(zzb2), subscribeOptions.getFilter(), null, 0, byArray, (IBinder)zzg.zza(subscribeOptions.getCallback()), subscribeOptions.zzbjk);
        ((com.google.android.gms.nearby.messages.internal.zzh)this.zztm()).zza(subscribeRequest);
    }

    void zza(zznt.zzb<Status> zzb2, PendingIntent pendingIntent, SubscribeOptions subscribeOptions) throws RemoteException {
        SubscribeRequest subscribeRequest = new SubscribeRequest(null, subscribeOptions.getStrategy(), (IBinder)zzr.zzs(zzb2), subscribeOptions.getFilter(), pendingIntent, 0, null, (IBinder)zzg.zza(subscribeOptions.getCallback()), subscribeOptions.zzbjk);
        ((com.google.android.gms.nearby.messages.internal.zzh)this.zztm()).zza(subscribeRequest);
    }

    void zza(zznt.zzb<Status> zzb2, zzou<MessageListener> zzou2, MessageListener messageListener) throws RemoteException {
        if (this.zzbjO.zzG(messageListener) == null) {
            return;
        }
        UnsubscribeRequest unsubscribeRequest = new UnsubscribeRequest((IBinder)this.zzbjO.zza(zzou2, messageListener), (IBinder)zzr.zzs(zzb2), null, 0);
        ((com.google.android.gms.nearby.messages.internal.zzh)this.zztm()).zza(unsubscribeRequest);
        this.zzbjO.zzH(messageListener);
    }

    void zza(zznt.zzb<Status> zzb2, PendingIntent pendingIntent) throws RemoteException {
        UnsubscribeRequest unsubscribeRequest = new UnsubscribeRequest(null, (IBinder)zzr.zzs(zzb2), pendingIntent, 0);
        ((com.google.android.gms.nearby.messages.internal.zzh)this.zztm()).zza(unsubscribeRequest);
    }

    void zzr(zznt.zzb<Status> zzb2) throws RemoteException {
        GetPermissionStatusRequest getPermissionStatusRequest = new GetPermissionStatusRequest((IBinder)zzr.zzs(zzb2));
        ((com.google.android.gms.nearby.messages.internal.zzh)this.zztm()).zza(getPermissionStatusRequest);
    }

    void zza(zznt.zzb<Status> zzb2, zzou<StatusCallback> zzou2, StatusCallback statusCallback) throws RemoteException {
        RegisterStatusCallbackRequest registerStatusCallbackRequest = new RegisterStatusCallbackRequest((IBinder)zzr.zzs(zzb2), (IBinder)this.zzbjN.zza(zzou2, statusCallback));
        registerStatusCallbackRequest.zzbkn = true;
        ((com.google.android.gms.nearby.messages.internal.zzh)this.zztm()).zza(registerStatusCallbackRequest);
    }

    void zzb(zznt.zzb<Status> zzb2, zzou<StatusCallback> zzou2, StatusCallback statusCallback) throws RemoteException {
        if (this.zzbjN.zzG(statusCallback) == null) {
            return;
        }
        RegisterStatusCallbackRequest registerStatusCallbackRequest = new RegisterStatusCallbackRequest((IBinder)zzr.zzs(zzb2), (IBinder)this.zzbjN.zza(zzou2, statusCallback));
        registerStatusCallbackRequest.zzbkn = false;
        ((com.google.android.gms.nearby.messages.internal.zzh)this.zztm()).zza(registerStatusCallbackRequest);
        this.zzbjN.zzH(statusCallback);
    }

    void zzkf(int n) throws RemoteException {
        String string;
        switch (n) {
            case 1: {
                string = "ACTIVITY_STOPPED";
                break;
            }
            case 2: {
                string = "CLIENT_DISCONNECTED";
                break;
            }
            default: {
                Log.w((String)"NearbyMessagesClient", (String)String.format("Received unknown/unforeseen client lifecycle event %d, can't do anything with it.", n));
                return;
            }
        }
        if (this.isConnected()) {
            HandleClientLifecycleEventRequest handleClientLifecycleEventRequest = new HandleClientLifecycleEventRequest(n);
            Log.d((String)"NearbyMessagesClient", (String)String.format("Emitting client lifecycle event %s", string));
            ((com.google.android.gms.nearby.messages.internal.zzh)this.zztm()).zza(handleClientLifecycleEventRequest);
        } else {
            Log.d((String)"NearbyMessagesClient", (String)String.format("Failed to emit client lifecycle event %s due to GmsClient being disconnected", string));
        }
    }

    zzou<MessageListener> zza(GoogleApiClient googleApiClient, MessageListener messageListener) {
        return zzo.zza(googleApiClient, messageListener, this.zzbjO);
    }

    zzou<StatusCallback> zza(GoogleApiClient googleApiClient, StatusCallback statusCallback) {
        return zzo.zza(googleApiClient, statusCallback, this.zzbjN);
    }

    private static <C> zzou<C> zza(GoogleApiClient googleApiClient, C c, zzh<C, ? extends zza<C>> zzh2) {
        zza<C> zza2 = zzh2.zzG(c);
        if (zza2 != null) {
            return zza2.zzHX();
        }
        return googleApiClient.zzs(c);
    }

    protected /* synthetic */ IInterface zzab(IBinder iBinder) {
        return this.zzdM(iBinder);
    }

    private static abstract class zzh<C, W extends zza<C>> {
        private final SimpleArrayMap<C, W> zzatN = new SimpleArrayMap(1);

        private zzh() {
        }

        @Nullable
        W zzG(C c) {
            return (W)((zza)this.zzatN.get(c));
        }

        W zza(zzou<C> zzou2, C c) {
            zza<Object> zza2 = (zza)this.zzatN.get(c);
            if (zza2 != null) {
                zzou2.clear();
                return (W)zza2;
            }
            zza2 = this.zzg(zzou2);
            this.zzatN.put(c, (Object)zza2);
            return (W)zza2;
        }

        @Nullable
        W zzH(C c) {
            zza zza2 = (zza)this.zzatN.remove(c);
            if (zza2 != null) {
                zza2.zzHX().clear();
            }
            return (W)zza2;
        }

        protected abstract W zzg(zzou<C> var1);
    }

    @TargetApi(value=14)
    private static class zzb
    implements Application.ActivityLifecycleCallbacks {
        private final Activity zzbjQ;
        private final zzo zzbjR;

        private zzb(Activity activity, zzo zzo2) {
            this.zzbjQ = activity;
            this.zzbjR = zzo2;
        }

        public void onActivityCreated(Activity activity, Bundle bundle) {
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
            if (activity == this.zzbjQ) {
                try {
                    this.zzbjR.zzkf(1);
                }
                catch (RemoteException remoteException) {
                    Log.v((String)"NearbyMessagesClient", (String)String.format("Failed to emit ACTIVITY_STOPPED from ClientLifecycleSafetyNet for Activity %s: %s", new Object[]{activity.getPackageName(), remoteException}));
                }
            }
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }

        public void onActivityDestroyed(Activity activity) {
            if (activity == this.zzbjQ) {
                Log.v((String)"NearbyMessagesClient", (String)String.format("Unregistering ClientLifecycleSafetyNet's ActivityLifecycleCallbacks for %s", activity.getPackageName()));
                activity.getApplication().unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            }
        }
    }

    private static class zze
    extends zzi.zza {
        private final PublishCallback zzbjU;

        private zze(PublishCallback publishCallback) {
            this.zzbjU = publishCallback;
        }

        @Nullable
        private static zze zza(@Nullable PublishCallback publishCallback) {
            return publishCallback == null ? null : new zze(publishCallback);
        }

        @Override
        public void onExpired() {
            this.zzbjU.onExpired();
        }
    }

    private static class zzg
    extends zzk.zza {
        private final SubscribeCallback zzbjY;

        private zzg(SubscribeCallback subscribeCallback) {
            this.zzbjY = subscribeCallback;
        }

        @Nullable
        private static zzg zza(@Nullable SubscribeCallback subscribeCallback) {
            return subscribeCallback == null ? null : new zzg(subscribeCallback);
        }

        @Override
        public void onExpired() {
            this.zzbjY.onExpired();
        }
    }

    private static class zzf
    extends zzj.zza
    implements zza<StatusCallback> {
        private final zzou<StatusCallback> zzbjV;

        private zzf(zzou<StatusCallback> zzou2) {
            this.zzbjV = zzou2;
        }

        @Override
        public void onPermissionChanged(final boolean bl) {
            this.zzbjV.zza((zzou.zzb)new zzd<StatusCallback>(){

                public void zza(StatusCallback statusCallback) {
                    statusCallback.onPermissionChanged(bl);
                }

                public /* synthetic */ void zzt(Object object) {
                    this.zza((StatusCallback)object);
                }
            });
        }

        @Override
        public zzou<StatusCallback> zzHX() {
            return this.zzbjV;
        }
    }

    private static class zzc
    extends zzf.zza
    implements zza<MessageListener> {
        private final zzou<MessageListener> zzbin;

        private zzc(zzou<MessageListener> zzou2) {
            this.zzbin = zzou2;
        }

        @Override
        public void zza(MessageWrapper messageWrapper) {
        }

        @Override
        public void zzb(MessageWrapper messageWrapper) {
        }

        @Override
        public void zzE(final List<Update> list) throws RemoteException {
            this.zzbin.zza((zzou.zzb)new zzd<MessageListener>(){

                public void zza(MessageListener messageListener) {
                    zzp.zza(list, messageListener);
                }

                public /* synthetic */ void zzt(Object object) {
                    this.zza((MessageListener)object);
                }
            });
        }

        @Override
        public zzou<MessageListener> zzHX() {
            return this.zzbin;
        }
    }

    private static abstract class zzd<T>
    implements zzou.zzb<T> {
        private zzd() {
        }

        public void zzrV() {
        }
    }

    private static interface zza<C> {
        public zzou<C> zzHX();
    }
}

