/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.internal.connection;

import android.content.Context;
import android.os.Looper;
import android.os.RemoteException;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.internal.zznt;
import com.google.android.gms.internal.zzou;
import com.google.android.gms.nearby.Nearby;
import com.google.android.gms.nearby.connection.AdvertisingOptions;
import com.google.android.gms.nearby.connection.AppMetadata;
import com.google.android.gms.nearby.connection.Connections;
import com.google.android.gms.nearby.connection.DiscoveryOptions;
import com.google.android.gms.nearby.connection.Strategy;
import com.google.android.gms.nearby.internal.connection.zzd;
import java.util.List;

public final class zze
implements Connections {
    public static final Api.zzf<zzd> zzaaz = new Api.zzf();
    public static final Api.zza<zzd, Api.ApiOptions.NoOptions> zzaaA = new Api.zza<zzd, Api.ApiOptions.NoOptions>(){

        public zzd zzp(Context context, Looper looper, zzg zzg2, Api.ApiOptions.NoOptions noOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return new zzd(context, looper, zzg2, connectionCallbacks, onConnectionFailedListener);
        }

        public /* synthetic */ Api.zze zza(Context context, Looper looper, zzg zzg2, Object object, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return this.zzp(context, looper, zzg2, (Api.ApiOptions.NoOptions)object, connectionCallbacks, onConnectionFailedListener);
        }
    };

    public static zzd zzd(GoogleApiClient googleApiClient, boolean bl) {
        zzaa.zzb((googleApiClient != null ? 1 : 0) != 0, (Object)"GoogleApiClient parameter is required.");
        zzaa.zza((boolean)googleApiClient.isConnected(), (Object)"GoogleApiClient must be connected.");
        return zze.zze(googleApiClient, bl);
    }

    public static zzd zze(GoogleApiClient googleApiClient, boolean bl) {
        zzaa.zza((boolean)googleApiClient.zza(Nearby.CONNECTIONS_API), (Object)"GoogleApiClient is not configured to use the Nearby Connections Api. Pass Nearby.CONNECTIONS_API into GoogleApiClient.Builder#addApi() to use this feature.");
        boolean bl2 = googleApiClient.hasConnectedApi(Nearby.CONNECTIONS_API);
        if (bl && !bl2) {
            throw new IllegalStateException("GoogleApiClient has an optional Nearby.CONNECTIONS_API and is not connected to Nearby Connections. Use GoogleApiClient.hasConnectedApi(Nearby.CONNECTIONS_API) to guard this call.");
        }
        return bl2 ? (zzd)googleApiClient.zza(zzaaz) : null;
    }

    @Override
    public String getLocalEndpointId(GoogleApiClient googleApiClient) {
        return zze.zzd(googleApiClient, true).zzHB();
    }

    @Override
    public String getLocalDeviceId(GoogleApiClient googleApiClient) {
        return zze.zzd(googleApiClient, true).zzHC();
    }

    public PendingResult<Connections.StartAdvertisingResult> zza(GoogleApiClient googleApiClient, final String string, final AppMetadata appMetadata, final long l, Connections.ConnectionRequestListener connectionRequestListener, final AdvertisingOptions advertisingOptions) {
        final zzou zzou2 = googleApiClient.zzs((Object)connectionRequestListener);
        return googleApiClient.zzd((zznt.zza)new zzb(googleApiClient){

            protected void zza(zzd zzd2) throws RemoteException {
                zzd2.zza((zznt.zzb<Connections.StartAdvertisingResult>)this, string, appMetadata, l, advertisingOptions.zzHw(), (zzou<Connections.ConnectionRequestListener>)zzou2);
            }
        });
    }

    @Override
    public PendingResult<Connections.StartAdvertisingResult> startAdvertising(GoogleApiClient googleApiClient, String string, AppMetadata appMetadata, long l, Connections.ConnectionRequestListener connectionRequestListener) {
        return this.zza(googleApiClient, string, appMetadata, l, connectionRequestListener, new AdvertisingOptions(Strategy.zzbhW));
    }

    @Override
    public void stopAdvertising(GoogleApiClient googleApiClient) {
        zze.zzd(googleApiClient, false).zzHD();
    }

    public PendingResult<Status> zza(GoogleApiClient googleApiClient, final String string, final long l, Connections.EndpointDiscoveryListener endpointDiscoveryListener, final DiscoveryOptions discoveryOptions) {
        final zzou zzou2 = googleApiClient.zzs((Object)endpointDiscoveryListener);
        return googleApiClient.zzd((zznt.zza)new zzc(googleApiClient){

            protected void zza(zzd zzd2) throws RemoteException {
                zzd2.zza((zznt.zzb<Status>)this, string, l, discoveryOptions.zzHw(), (zzou<Connections.EndpointDiscoveryListener>)zzou2);
            }
        });
    }

    @Override
    public PendingResult<Status> startDiscovery(GoogleApiClient googleApiClient, String string, long l, Connections.EndpointDiscoveryListener endpointDiscoveryListener) {
        return this.zza(googleApiClient, string, l, endpointDiscoveryListener, new DiscoveryOptions(Strategy.zzbhW));
    }

    @Override
    public void stopDiscovery(GoogleApiClient googleApiClient, String string) {
        zze.zzd(googleApiClient, false).zzfU(string);
    }

    @Override
    public PendingResult<Status> sendConnectionRequest(GoogleApiClient googleApiClient, final String string, final String string2, final byte[] byArray, Connections.ConnectionResponseCallback connectionResponseCallback, Connections.MessageListener messageListener) {
        final zzou zzou2 = googleApiClient.zzs((Object)connectionResponseCallback);
        final zzou zzou3 = googleApiClient.zzs((Object)messageListener);
        return googleApiClient.zzd((zznt.zza)new zzc(googleApiClient){

            protected void zza(zzd zzd2) throws RemoteException {
                zzd2.zza((zznt.zzb<Status>)this, string, string2, byArray, (zzou<Connections.ConnectionResponseCallback>)zzou2, (zzou<Connections.MessageListener>)zzou3);
            }
        });
    }

    @Override
    public PendingResult<Status> acceptConnectionRequest(GoogleApiClient googleApiClient, final String string, final byte[] byArray, Connections.MessageListener messageListener) {
        final zzou zzou2 = googleApiClient.zzs((Object)messageListener);
        return googleApiClient.zzd((zznt.zza)new zzc(googleApiClient){

            protected void zza(zzd zzd2) throws RemoteException {
                zzd2.zza((zznt.zzb<Status>)this, string, byArray, (zzou<Connections.MessageListener>)zzou2);
            }
        });
    }

    @Override
    public PendingResult<Status> rejectConnectionRequest(GoogleApiClient googleApiClient, final String string) {
        return googleApiClient.zzd((zznt.zza)new zzc(googleApiClient){

            protected void zza(zzd zzd2) throws RemoteException {
                zzd2.zzt((zznt.zzb<Status>)this, string);
            }
        });
    }

    @Override
    public void sendReliableMessage(GoogleApiClient googleApiClient, String string, byte[] byArray) {
        zze.zzd(googleApiClient, false).zza(new String[]{string}, byArray);
    }

    @Override
    public void sendReliableMessage(GoogleApiClient googleApiClient, List<String> list, byte[] byArray) {
        zze.zzd(googleApiClient, false).zza(list.toArray(new String[list.size()]), byArray);
    }

    @Override
    public void sendUnreliableMessage(GoogleApiClient googleApiClient, String string, byte[] byArray) {
        zze.zzd(googleApiClient, false).zzb(new String[]{string}, byArray);
    }

    @Override
    public void sendUnreliableMessage(GoogleApiClient googleApiClient, List<String> list, byte[] byArray) {
        zze.zzd(googleApiClient, false).zzb(list.toArray(new String[list.size()]), byArray);
    }

    @Override
    public void disconnectFromEndpoint(GoogleApiClient googleApiClient, String string) {
        zze.zzd(googleApiClient, false).zzfV(string);
    }

    @Override
    public void stopAllEndpoints(GoogleApiClient googleApiClient) {
        zze.zzd(googleApiClient, false).zzHE();
    }

    private static abstract class zzc
    extends zza<Status> {
        private zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Status zzb(Status status) {
            return status;
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzb(status);
        }
    }

    private static abstract class zzb
    extends zza<Connections.StartAdvertisingResult> {
        private zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Connections.StartAdvertisingResult zzbn(final Status status) {
            return new Connections.StartAdvertisingResult(){

                @Override
                public String getLocalEndpointName() {
                    return null;
                }

                public Status getStatus() {
                    return status;
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzbn(status);
        }
    }

    private static abstract class zza<R extends Result>
    extends zznt.zza<R, zzd> {
        public zza(GoogleApiClient googleApiClient) {
            super(Nearby.CONNECTIONS_API, googleApiClient);
        }
    }
}

