/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.nearby.messages.zzf;
import java.util.ArrayList;

public class Strategy
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<Strategy> CREATOR = new zzf();
    public static final int DISCOVERY_MODE_BROADCAST = 1;
    public static final int DISCOVERY_MODE_SCAN = 2;
    public static final int DISCOVERY_MODE_DEFAULT = 3;
    public static final int DISTANCE_TYPE_DEFAULT = 0;
    public static final int DISTANCE_TYPE_EARSHOT = 1;
    public static final int TTL_SECONDS_DEFAULT = 300;
    public static final int TTL_SECONDS_MAX = 86400;
    public static final int TTL_SECONDS_INFINITE = Integer.MAX_VALUE;
    public static final Strategy DEFAULT = new Builder().build();
    public static final Strategy BLE_ONLY;
    @Deprecated
    public static final Strategy zzbiY;
    final int mVersionCode;
    @Deprecated
    final int zzbiZ;
    final int zzbja;
    final int zzbjb;
    @Deprecated
    final boolean zzbjc;
    final int zzbjd;
    final int zzbje;

    Strategy(int n, int n2, int n3, int n4, boolean bl, int n5, int n6) {
        this.mVersionCode = n;
        this.zzbiZ = n2;
        if (n2 == 0) {
            this.zzbje = n6;
        } else {
            switch (n2) {
                case 2: {
                    this.zzbje = 1;
                    break;
                }
                case 3: {
                    this.zzbje = 2;
                    break;
                }
                default: {
                    this.zzbje = 3;
                }
            }
        }
        this.zzbjb = n4;
        this.zzbjc = bl;
        if (bl) {
            this.zzbjd = 2;
            this.zzbja = Integer.MAX_VALUE;
        } else {
            this.zzbja = n3;
            switch (n5) {
                case -1: 
                case 0: 
                case 1: 
                case 6: {
                    this.zzbjd = -1;
                    break;
                }
                default: {
                    this.zzbjd = n5;
                }
            }
        }
    }

    public int zzHP() {
        return this.zzbjd;
    }

    public int zzHx() {
        return this.zzbje;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzf.zza(this, parcel, n);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Strategy)) {
            return false;
        }
        Strategy strategy = (Strategy)((Object)object);
        return this.mVersionCode == strategy.mVersionCode && this.zzbje == strategy.zzbje && this.zzbja == strategy.zzbja && this.zzbjb == strategy.zzbjb && this.zzbjd == strategy.zzbjd;
    }

    public int hashCode() {
        int n = this.mVersionCode;
        n = 31 * n + this.zzbje;
        n = 31 * n + this.zzbja;
        n = 31 * n + this.zzbjb;
        n = 31 * n + this.zzbjd;
        return n;
    }

    public String toString() {
        int n = this.zzbja;
        String string = String.valueOf(Strategy.zzjP(this.zzbjb));
        String string2 = String.valueOf(Strategy.zzjQ(this.zzbjd));
        String string3 = String.valueOf(Strategy.zzjR(this.zzbje));
        return new StringBuilder(81 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Strategy{ttlSeconds=").append(n).append(", distanceType=").append(string).append(", discoveryMedium=").append(string2).append(", discoveryMode=").append(string3).append("}").toString();
    }

    private static String zzjP(int n) {
        switch (n) {
            case 0: {
                return "DEFAULT";
            }
            case 1: {
                return "EARSHOT";
            }
        }
        return new StringBuilder(19).append("UNKNOWN:").append(n).toString();
    }

    private static String zzjQ(int n) {
        if (n == -1) {
            return "DEFAULT";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if ((n & 4) > 0) {
            arrayList.add("ULTRASOUND");
        }
        if ((n & 2) > 0) {
            arrayList.add("BLE");
        }
        if (arrayList.isEmpty()) {
            return new StringBuilder(19).append("UNKNOWN:").append(n).toString();
        }
        return ((Object)arrayList).toString();
    }

    private static String zzjR(int n) {
        if (n == 3) {
            return "DEFAULT";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if ((n & 1) > 0) {
            arrayList.add("BROADCAST");
        }
        if ((n & 2) > 0) {
            arrayList.add("SCAN");
        }
        if (arrayList.isEmpty()) {
            return new StringBuilder(19).append("UNKNOWN:").append(n).toString();
        }
        return ((Object)arrayList).toString();
    }

    static {
        zzbiY = BLE_ONLY = new Builder().zzjS(2).setTtlSeconds(Integer.MAX_VALUE).build();
    }

    public static class Builder {
        private int zzbhZ = 3;
        private int zzbjf = 300;
        private int zzbjg = 0;
        private int zzbjh = -1;

        public Builder setDiscoveryMode(int n) {
            this.zzbhZ = n;
            return this;
        }

        public Builder zzjS(int n) {
            this.zzbjh = n;
            return this;
        }

        public Builder setTtlSeconds(int n) {
            zzaa.zzb((n == Integer.MAX_VALUE || n > 0 && n <= 86400 ? 1 : 0) != 0, (String)"mTtlSeconds(%d) must either be TTL_SECONDS_INFINITE, or it must be between 1 and TTL_SECONDS_MAX(%d) inclusive", (Object[])new Object[]{n, 86400});
            this.zzbjf = n;
            return this;
        }

        public Builder setDistanceType(int n) {
            this.zzbjg = n;
            return this;
        }

        public Strategy build() {
            if (this.zzbjh == 2 && this.zzbjg == 1) {
                throw new IllegalStateException("Cannot set EARSHOT with BLE only mode.");
            }
            return new Strategy(2, 0, this.zzbjf, this.zzbjg, false, this.zzbjh, this.zzbhZ);
        }
    }
}

