/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.nearby.messages.devices.NearbyDevice;
import com.google.android.gms.nearby.messages.zza;
import java.util.Arrays;

public class Message
extends AbstractSafeParcelable {
    public static final int MAX_CONTENT_SIZE_BYTES = 102400;
    public static final int MAX_TYPE_LENGTH = 32;
    public static final Parcelable.Creator<Message> CREATOR = new zza();
    private static final NearbyDevice[] aqj = new NearbyDevice[]{NearbyDevice.aqM};
    public static final String MESSAGE_NAMESPACE_RESERVED = "__reserved_namespace";
    public static final String MESSAGE_TYPE_EDDYSTONE_UID = "__eddystone_uid";
    public static final String MESSAGE_TYPE_I_BEACON_ID = "__i_beacon_id";
    final int versionCode;
    private final byte[] content;
    private final String type;
    private final String zl;
    private final NearbyDevice[] aqk;

    Message(int n, byte[] byArray, String string, String string2, NearbyDevice[] nearbyDeviceArray) {
        this.versionCode = n;
        this.type = (String)zzab.zzaa((Object)string2);
        String string3 = this.zl = string == null ? "" : string;
        if (Message.zzbc(this.zl, this.type)) {
            zzab.zzb((byArray == null ? 1 : 0) != 0, (Object)"Content must be null for a device presence message.");
        } else {
            zzab.zzaa((Object)byArray);
            zzab.zzb((byArray.length <= 102400 ? 1 : 0) != 0, (String)"Content length(%d) must not exceed MAX_CONTENT_SIZE_BYTES(%d)", (Object[])new Object[]{byArray.length, 102400});
        }
        this.content = byArray;
        if (nearbyDeviceArray == null || nearbyDeviceArray.length == 0) {
            nearbyDeviceArray = aqj;
        }
        this.aqk = nearbyDeviceArray;
        zzab.zzb((string2.length() <= 32 ? 1 : 0) != 0, (String)"Type length(%d) must not exceed MAX_TYPE_LENGTH(%d)", (Object[])new Object[]{string2.length(), 32});
    }

    public boolean zzbxn() {
        return MESSAGE_NAMESPACE_RESERVED.equals(this.getNamespace());
    }

    public boolean zzmz(String string) {
        return this.zzbxn() && string.equals(this.getType());
    }

    @Deprecated
    public static boolean zzbc(String string, String string2) {
        return string.equals(MESSAGE_NAMESPACE_RESERVED) && string2.equals("__device_presence");
    }

    public Message(byte[] byArray) {
        this(byArray, "", "");
    }

    public Message(byte[] byArray, String string) {
        this(byArray, "", string);
    }

    public Message(byte[] byArray, String string, String string2) {
        this(byArray, string, string2, aqj);
    }

    public Message(byte[] byArray, String string, String string2, NearbyDevice[] nearbyDeviceArray) {
        this(2, byArray, string, string2, nearbyDeviceArray);
    }

    public String getType() {
        return this.type;
    }

    public String getNamespace() {
        return this.zl;
    }

    public byte[] getContent() {
        return this.content;
    }

    public NearbyDevice[] zzbxo() {
        return this.aqk;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zza.zza(this, parcel, n);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zl, this.type, Arrays.hashCode(this.content)});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Message)) {
            return false;
        }
        Message message = (Message)((Object)object);
        return TextUtils.equals((CharSequence)this.zl, (CharSequence)message.zl) && TextUtils.equals((CharSequence)this.type, (CharSequence)message.type) && Arrays.equals(this.content, message.content);
    }

    public String toString() {
        String string = this.zl;
        String string2 = this.type;
        int n = this.content == null ? 0 : this.content.length;
        String string3 = String.valueOf(Arrays.toString((Object[])this.zzbxo()));
        return new StringBuilder(69 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Message{namespace='").append(string).append("', type='").append(string2).append("', content=[").append(n).append(" bytes], devices=").append(string3).append("}").toString();
    }
}

