/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.nearby.messages.zzd;
import java.util.ArrayList;

public class Strategy
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<Strategy> CREATOR = new zzd();
    public static final int DISCOVERY_MODE_BROADCAST = 1;
    public static final int DISCOVERY_MODE_SCAN = 2;
    public static final int DISCOVERY_MODE_DEFAULT = 3;
    public static final int DISTANCE_TYPE_DEFAULT = 0;
    public static final int DISTANCE_TYPE_EARSHOT = 1;
    public static final int TTL_SECONDS_DEFAULT = 300;
    public static final int TTL_SECONDS_MAX = 86400;
    public static final int TTL_SECONDS_INFINITE = Integer.MAX_VALUE;
    public static final Strategy DEFAULT = new Builder().build();
    public static final Strategy BLE_ONLY;
    @Deprecated
    public static final Strategy aqw;
    final int mVersionCode;
    @Deprecated
    final int aqx;
    final int aqy;
    final int aqz;
    @Deprecated
    final boolean aqA;
    final int aqB;
    final int aqC;

    Strategy(int n, int n2, int n3, int n4, boolean bl, int n5, int n6) {
        this.mVersionCode = n;
        this.aqx = n2;
        if (n2 == 0) {
            this.aqC = n6;
        } else {
            switch (n2) {
                case 2: {
                    this.aqC = 1;
                    break;
                }
                case 3: {
                    this.aqC = 2;
                    break;
                }
                default: {
                    this.aqC = 3;
                }
            }
        }
        this.aqz = n4;
        this.aqA = bl;
        if (bl) {
            this.aqB = 2;
            this.aqy = Integer.MAX_VALUE;
        } else {
            this.aqy = n3;
            switch (n5) {
                case -1: 
                case 0: 
                case 1: 
                case 6: {
                    this.aqB = -1;
                    break;
                }
                default: {
                    this.aqB = n5;
                }
            }
        }
    }

    public int zzbxs() {
        return this.aqB;
    }

    public int zzbxt() {
        return this.aqC;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzd.zza(this, parcel, n);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Strategy)) {
            return false;
        }
        Strategy strategy = (Strategy)((Object)object);
        return this.mVersionCode == strategy.mVersionCode && this.aqC == strategy.aqC && this.aqy == strategy.aqy && this.aqz == strategy.aqz && this.aqB == strategy.aqB;
    }

    public int hashCode() {
        int n = this.mVersionCode;
        n = 31 * n + this.aqC;
        n = 31 * n + this.aqy;
        n = 31 * n + this.aqz;
        n = 31 * n + this.aqB;
        return n;
    }

    public String toString() {
        int n = this.aqy;
        String string = String.valueOf(Strategy.zzvz(this.aqz));
        String string2 = String.valueOf(Strategy.zzwa(this.aqB));
        String string3 = String.valueOf(Strategy.zzwb(this.aqC));
        return new StringBuilder(81 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Strategy{ttlSeconds=").append(n).append(", distanceType=").append(string).append(", discoveryMedium=").append(string2).append(", discoveryMode=").append(string3).append("}").toString();
    }

    private static String zzvz(int n) {
        switch (n) {
            case 0: {
                return "DEFAULT";
            }
            case 1: {
                return "EARSHOT";
            }
        }
        return new StringBuilder(19).append("UNKNOWN:").append(n).toString();
    }

    private static String zzwa(int n) {
        if (n == -1) {
            return "DEFAULT";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if ((n & 4) > 0) {
            arrayList.add("ULTRASOUND");
        }
        if ((n & 2) > 0) {
            arrayList.add("BLE");
        }
        if (arrayList.isEmpty()) {
            return new StringBuilder(19).append("UNKNOWN:").append(n).toString();
        }
        return ((Object)arrayList).toString();
    }

    private static String zzwb(int n) {
        if (n == 3) {
            return "DEFAULT";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if ((n & 1) > 0) {
            arrayList.add("BROADCAST");
        }
        if ((n & 2) > 0) {
            arrayList.add("SCAN");
        }
        if (arrayList.isEmpty()) {
            return new StringBuilder(19).append("UNKNOWN:").append(n).toString();
        }
        return ((Object)arrayList).toString();
    }

    static {
        aqw = BLE_ONLY = new Builder().zzwc(2).setTtlSeconds(Integer.MAX_VALUE).build();
    }

    public static class Builder {
        private int aqD = 3;
        private int aqE = 300;
        private int aqF = 0;
        private int aqG = -1;

        public Builder setDiscoveryMode(int n) {
            this.aqD = n;
            return this;
        }

        public Builder zzwc(int n) {
            this.aqG = n;
            return this;
        }

        public Builder setTtlSeconds(int n) {
            zzab.zzb((n == Integer.MAX_VALUE || n > 0 && n <= 86400 ? 1 : 0) != 0, (String)"mTtlSeconds(%d) must either be TTL_SECONDS_INFINITE, or it must be between 1 and TTL_SECONDS_MAX(%d) inclusive", (Object[])new Object[]{n, 86400});
            this.aqE = n;
            return this;
        }

        public Builder setDistanceType(int n) {
            this.aqF = n;
            return this;
        }

        public Strategy build() {
            if (this.aqG == 2 && this.aqF == 1) {
                throw new IllegalStateException("Cannot set EARSHOT with BLE only mode.");
            }
            return new Strategy(2, 0, this.aqE, this.aqF, false, this.aqG, this.aqD);
        }
    }
}

