/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.nearby.messages.devices.NearbyDeviceFilter;
import com.google.android.gms.nearby.messages.internal.MessageType;
import com.google.android.gms.nearby.messages.zzb;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class MessageFilter
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<MessageFilter> CREATOR = new zzb();
    public static final MessageFilter INCLUDE_ALL_MY_TYPES = new Builder().includeAllMyTypes().build();
    final int mVersionCode;
    private final List<MessageType> aql;
    private final List<NearbyDeviceFilter> aqm;
    private final boolean aqn;

    MessageFilter(int n, List<MessageType> list, List<NearbyDeviceFilter> list2, boolean bl) {
        this.mVersionCode = n;
        this.aql = Collections.unmodifiableList((List)zzab.zzaa(list));
        this.aqn = bl;
        if (list2 == null) {
            list2 = Collections.emptyList();
        }
        this.aqm = Collections.unmodifiableList(list2);
    }

    private MessageFilter(List<MessageType> list, List<NearbyDeviceFilter> list2, boolean bl) {
        this(1, list, list2, bl);
    }

    List<MessageType> zzbxp() {
        return this.aql;
    }

    boolean zzbxq() {
        return this.aqn;
    }

    List<NearbyDeviceFilter> zzbxr() {
        return this.aqm;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzb.zza(this, parcel, n);
    }

    public String toString() {
        boolean bl = this.aqn;
        String string = String.valueOf(this.aql);
        return new StringBuilder(53 + String.valueOf(string).length()).append("MessageFilter{includeAllMyTypes=").append(bl).append(", messageTypes=").append(string).append("}").toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MessageFilter)) {
            return false;
        }
        MessageFilter messageFilter = (MessageFilter)((Object)object);
        return this.aqn == messageFilter.aqn && zzaa.equal(this.aql, messageFilter.aql) && zzaa.equal(this.aqm, messageFilter.aqm);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.aql, this.aqm, this.aqn});
    }

    public static final class Builder {
        private final List<MessageType> aqo = new ArrayList<MessageType>();
        private final List<NearbyDeviceFilter> aqm = new ArrayList<NearbyDeviceFilter>();
        private boolean aqn;

        public Builder includeAllMyTypes() {
            this.aqn = true;
            return this;
        }

        public Builder includeNamespacedType(String string, String string2) {
            zzab.zzb((string != null && !string.isEmpty() && !string.contains("*") ? 1 : 0) != 0, (String)"namespace(%s) cannot be null, empty or contain (*).", (Object[])new Object[]{string});
            zzab.zzb((string2 != null && !string2.contains("*") ? 1 : 0) != 0, (String)"type(%s) cannot be null or contain (*).", (Object[])new Object[]{string2});
            return this.zzbd(string, string2);
        }

        public Builder includeFilter(MessageFilter messageFilter) {
            this.aqo.addAll(messageFilter.zzbxp());
            this.aqm.addAll(messageFilter.zzbxr());
            this.aqn |= messageFilter.zzbxq();
            return this;
        }

        public Builder includeEddystoneUids(String string, @Nullable String string2) {
            this.zzbd("__reserved_namespace", "__eddystone_uid");
            this.aqm.add(NearbyDeviceFilter.zzbe(string, string2));
            return this;
        }

        public Builder includeIBeaconIds(UUID uUID, @Nullable Short s, @Nullable Short s2) {
            this.zzbd("__reserved_namespace", "__i_beacon_id");
            this.aqm.add(NearbyDeviceFilter.zza(uUID, s, s2));
            return this;
        }

        private Builder zzbd(String string, String string2) {
            this.aqo.add(new MessageType(string, string2));
            return this;
        }

        public MessageFilter build() {
            zzab.zza((this.aqn || !this.aqo.isEmpty() ? 1 : 0) != 0, (Object)"At least one of the include methods must be called.");
            return new MessageFilter(this.aqo, this.aqm, this.aqn);
        }
    }
}

