/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.SimpleArrayMap;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzpr;
import com.google.android.gms.internal.zzqs;
import com.google.android.gms.nearby.messages.MessageListener;
import com.google.android.gms.nearby.messages.MessagesOptions;
import com.google.android.gms.nearby.messages.PublishCallback;
import com.google.android.gms.nearby.messages.PublishOptions;
import com.google.android.gms.nearby.messages.StatusCallback;
import com.google.android.gms.nearby.messages.SubscribeCallback;
import com.google.android.gms.nearby.messages.SubscribeOptions;
import com.google.android.gms.nearby.messages.internal.ClientAppContext;
import com.google.android.gms.nearby.messages.internal.GetPermissionStatusRequest;
import com.google.android.gms.nearby.messages.internal.HandleClientLifecycleEventRequest;
import com.google.android.gms.nearby.messages.internal.MessageWrapper;
import com.google.android.gms.nearby.messages.internal.PublishRequest;
import com.google.android.gms.nearby.messages.internal.RegisterStatusCallbackRequest;
import com.google.android.gms.nearby.messages.internal.SubscribeRequest;
import com.google.android.gms.nearby.messages.internal.UnpublishRequest;
import com.google.android.gms.nearby.messages.internal.UnsubscribeRequest;
import com.google.android.gms.nearby.messages.internal.Update;
import com.google.android.gms.nearby.messages.internal.zzi;
import com.google.android.gms.nearby.messages.internal.zzk;
import com.google.android.gms.nearby.messages.internal.zzl;
import com.google.android.gms.nearby.messages.internal.zzm;
import com.google.android.gms.nearby.messages.internal.zzn;
import com.google.android.gms.nearby.messages.internal.zzs;
import com.google.android.gms.nearby.messages.internal.zzu;
import java.util.List;

class zzr
extends com.google.android.gms.common.internal.zzk<zzk> {
    private final ClientAppContext arj;
    private final int aqt;
    private final zzh<StatusCallback, zzf> ark = new zzh<StatusCallback, zzf>(){

        protected zzf zzf(zzqs<StatusCallback> zzqs2) {
            return new zzf(zzqs2);
        }

        @Override
        protected /* synthetic */ zza zzg(zzqs zzqs2) {
            return this.zzf((zzqs<StatusCallback>)zzqs2);
        }
    };
    private final zzh<MessageListener, zzc> arl = new zzh<MessageListener, zzc>(){

        protected zzc zzh(zzqs<MessageListener> zzqs2) {
            return new zzc(zzqs2);
        }

        @Override
        protected /* synthetic */ zza zzg(zzqs zzqs2) {
            return this.zzh((zzqs<MessageListener>)zzqs2);
        }
    };

    private static int zzdp(Context context) {
        if (context instanceof Activity) {
            return 1;
        }
        if (context instanceof Application) {
            return 2;
        }
        if (context instanceof Service) {
            return 3;
        }
        return 0;
    }

    @TargetApi(value=14)
    zzr(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, com.google.android.gms.common.internal.zzg zzg2, MessagesOptions messagesOptions) {
        super(context, looper, 62, zzg2, connectionCallbacks, onConnectionFailedListener);
        String string = zzg2.zzasi();
        int n = zzr.zzdp(context);
        if (messagesOptions != null) {
            this.arj = new ClientAppContext(string, messagesOptions.aqp, messagesOptions.aqq, messagesOptions.aqs, n);
            this.aqt = messagesOptions.aqr;
        } else {
            this.arj = new ClientAppContext(string, null, false, null, n);
            this.aqt = -1;
        }
        if (n == 1 && com.google.android.gms.common.util.zzs.zzavm()) {
            Activity activity = (Activity)context;
            Log.v((String)"NearbyMessagesClient", (String)String.format("Registering ClientLifecycleSafetyNet's ActivityLifecycleCallbacks for %s", activity.getPackageName()));
            activity.getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new zzb(activity, this));
        }
    }

    @NonNull
    protected Bundle zzaeu() {
        Bundle bundle = super.zzaeu();
        bundle.putInt("NearbyPermissions", this.aqt);
        bundle.putParcelable("ClientAppContext", (Parcelable)this.arj);
        return bundle;
    }

    @NonNull
    protected String zzra() {
        return "com.google.android.gms.nearby.messages.service.NearbyMessagesService.START";
    }

    @NonNull
    protected String zzrb() {
        return "com.google.android.gms.nearby.messages.internal.INearbyMessagesService";
    }

    protected zzk zzjs(IBinder iBinder) {
        return zzk.zza.zzjo(iBinder);
    }

    public void disconnect() {
        try {
            this.zzwp(2);
        }
        catch (RemoteException remoteException) {
            Log.v((String)"NearbyMessagesClient", (String)String.format("Failed to emit CLIENT_DISCONNECTED from override of GmsClient#disconnect(): %s", new Object[]{remoteException}));
        }
        super.disconnect();
    }

    void zza(zzpr.zzb<Status> zzb2, MessageWrapper messageWrapper, PublishOptions publishOptions) throws RemoteException {
        PublishRequest publishRequest = new PublishRequest(messageWrapper, publishOptions.getStrategy(), (IBinder)zzu.zzu(zzb2), (IBinder)zze.zza(publishOptions.getCallback()));
        ((zzk)this.zzarw()).zza(publishRequest);
    }

    void zza(zzpr.zzb<Status> zzb2, MessageWrapper messageWrapper) throws RemoteException {
        UnpublishRequest unpublishRequest = new UnpublishRequest(messageWrapper, (IBinder)zzu.zzu(zzb2), this.arj);
        ((zzk)this.zzarw()).zza(unpublishRequest);
    }

    void zza(zzpr.zzb<Status> zzb2, zzqs<MessageListener> zzqs2, MessageListener messageListener, SubscribeOptions subscribeOptions, @Nullable byte[] byArray) throws RemoteException {
        SubscribeRequest subscribeRequest = new SubscribeRequest((IBinder)this.arl.zza(zzqs2, messageListener), subscribeOptions.getStrategy(), (IBinder)zzu.zzu(zzb2), subscribeOptions.getFilter(), null, 0, byArray, (IBinder)zzg.zza(subscribeOptions.getCallback()), subscribeOptions.aqJ);
        ((zzk)this.zzarw()).zza(subscribeRequest);
    }

    void zza(zzpr.zzb<Status> zzb2, PendingIntent pendingIntent, SubscribeOptions subscribeOptions) throws RemoteException {
        SubscribeRequest subscribeRequest = new SubscribeRequest(null, subscribeOptions.getStrategy(), (IBinder)zzu.zzu(zzb2), subscribeOptions.getFilter(), pendingIntent, 0, null, (IBinder)zzg.zza(subscribeOptions.getCallback()), subscribeOptions.aqJ);
        ((zzk)this.zzarw()).zza(subscribeRequest);
    }

    void zza(zzpr.zzb<Status> zzb2, zzqs<MessageListener> zzqs2, MessageListener messageListener) throws RemoteException {
        if (this.arl.zzah(messageListener) == null) {
            return;
        }
        UnsubscribeRequest unsubscribeRequest = new UnsubscribeRequest((IBinder)this.arl.zza(zzqs2, messageListener), (IBinder)zzu.zzu(zzb2), null, 0);
        ((zzk)this.zzarw()).zza(unsubscribeRequest);
        this.arl.zzai(messageListener);
    }

    void zza(zzpr.zzb<Status> zzb2, PendingIntent pendingIntent) throws RemoteException {
        UnsubscribeRequest unsubscribeRequest = new UnsubscribeRequest(null, (IBinder)zzu.zzu(zzb2), pendingIntent, 0);
        ((zzk)this.zzarw()).zza(unsubscribeRequest);
    }

    void zzt(zzpr.zzb<Status> zzb2) throws RemoteException {
        GetPermissionStatusRequest getPermissionStatusRequest = new GetPermissionStatusRequest((IBinder)zzu.zzu(zzb2));
        ((zzk)this.zzarw()).zza(getPermissionStatusRequest);
    }

    void zza(zzpr.zzb<Status> zzb2, zzqs<StatusCallback> zzqs2, StatusCallback statusCallback) throws RemoteException {
        RegisterStatusCallbackRequest registerStatusCallbackRequest = new RegisterStatusCallbackRequest((IBinder)zzu.zzu(zzb2), (IBinder)this.ark.zza(zzqs2, statusCallback));
        registerStatusCallbackRequest.arK = true;
        ((zzk)this.zzarw()).zza(registerStatusCallbackRequest);
    }

    void zzb(zzpr.zzb<Status> zzb2, zzqs<StatusCallback> zzqs2, StatusCallback statusCallback) throws RemoteException {
        if (this.ark.zzah(statusCallback) == null) {
            return;
        }
        RegisterStatusCallbackRequest registerStatusCallbackRequest = new RegisterStatusCallbackRequest((IBinder)zzu.zzu(zzb2), (IBinder)this.ark.zza(zzqs2, statusCallback));
        registerStatusCallbackRequest.arK = false;
        ((zzk)this.zzarw()).zza(registerStatusCallbackRequest);
        this.ark.zzai(statusCallback);
    }

    void zzwp(int n) throws RemoteException {
        String string;
        switch (n) {
            case 1: {
                string = "ACTIVITY_STOPPED";
                break;
            }
            case 2: {
                string = "CLIENT_DISCONNECTED";
                break;
            }
            default: {
                Log.w((String)"NearbyMessagesClient", (String)String.format("Received unknown/unforeseen client lifecycle event %d, can't do anything with it.", n));
                return;
            }
        }
        if (this.isConnected()) {
            HandleClientLifecycleEventRequest handleClientLifecycleEventRequest = new HandleClientLifecycleEventRequest(n);
            Log.d((String)"NearbyMessagesClient", (String)String.format("Emitting client lifecycle event %s", string));
            ((zzk)this.zzarw()).zza(handleClientLifecycleEventRequest);
        } else {
            Log.d((String)"NearbyMessagesClient", (String)String.format("Failed to emit client lifecycle event %s due to GmsClient being disconnected", string));
        }
    }

    zzqs<MessageListener> zza(GoogleApiClient googleApiClient, MessageListener messageListener) {
        return zzr.zza(googleApiClient, messageListener, this.arl);
    }

    zzqs<StatusCallback> zza(GoogleApiClient googleApiClient, StatusCallback statusCallback) {
        return zzr.zza(googleApiClient, statusCallback, this.ark);
    }

    private static <C> zzqs<C> zza(GoogleApiClient googleApiClient, C c, zzh<C, ? extends zza<C>> zzh2) {
        zza<C> zza2 = zzh2.zzah(c);
        if (zza2 != null) {
            return zza2.zzbxy();
        }
        return googleApiClient.zzt(c);
    }

    protected /* synthetic */ IInterface zzbb(IBinder iBinder) {
        return this.zzjs(iBinder);
    }

    private static abstract class zzh<C, W extends zza<C>> {
        private final SimpleArrayMap<C, W> Ax = new SimpleArrayMap(1);

        private zzh() {
        }

        @Nullable
        W zzah(C c) {
            return (W)((zza)this.Ax.get(c));
        }

        W zza(zzqs<C> zzqs2, C c) {
            zza<Object> zza2 = (zza)this.Ax.get(c);
            if (zza2 != null) {
                zzqs2.clear();
                return (W)zza2;
            }
            zza2 = this.zzg(zzqs2);
            this.Ax.put(c, (Object)zza2);
            return (W)zza2;
        }

        @Nullable
        W zzai(C c) {
            zza zza2 = (zza)this.Ax.remove(c);
            if (zza2 != null) {
                zza2.zzbxy().clear();
            }
            return (W)zza2;
        }

        protected abstract W zzg(zzqs<C> var1);
    }

    @TargetApi(value=14)
    private static class zzb
    implements Application.ActivityLifecycleCallbacks {
        private final Activity arn;
        private final zzr aro;

        private zzb(Activity activity, zzr zzr2) {
            this.arn = activity;
            this.aro = zzr2;
        }

        public void onActivityCreated(Activity activity, Bundle bundle) {
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
            if (activity == this.arn) {
                try {
                    this.aro.zzwp(1);
                }
                catch (RemoteException remoteException) {
                    Log.v((String)"NearbyMessagesClient", (String)String.format("Failed to emit ACTIVITY_STOPPED from ClientLifecycleSafetyNet for Activity %s: %s", new Object[]{activity.getPackageName(), remoteException}));
                }
            }
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }

        public void onActivityDestroyed(Activity activity) {
            if (activity == this.arn) {
                Log.v((String)"NearbyMessagesClient", (String)String.format("Unregistering ClientLifecycleSafetyNet's ActivityLifecycleCallbacks for %s", activity.getPackageName()));
                activity.getApplication().unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            }
        }
    }

    private static class zze
    extends zzl.zza {
        private final PublishCallback arr;

        private zze(PublishCallback publishCallback) {
            this.arr = publishCallback;
        }

        @Nullable
        private static zze zza(@Nullable PublishCallback publishCallback) {
            return publishCallback == null ? null : new zze(publishCallback);
        }

        @Override
        public void onExpired() {
            this.arr.onExpired();
        }
    }

    private static class zzg
    extends zzn.zza {
        private final SubscribeCallback arv;

        private zzg(SubscribeCallback subscribeCallback) {
            this.arv = subscribeCallback;
        }

        @Nullable
        private static zzg zza(@Nullable SubscribeCallback subscribeCallback) {
            return subscribeCallback == null ? null : new zzg(subscribeCallback);
        }

        @Override
        public void onExpired() {
            this.arv.onExpired();
        }
    }

    private static class zzf
    extends zzm.zza
    implements zza<StatusCallback> {
        private final zzqs<StatusCallback> ars;

        private zzf(zzqs<StatusCallback> zzqs2) {
            this.ars = zzqs2;
        }

        @Override
        public void onPermissionChanged(final boolean bl) {
            this.ars.zza((zzqs.zzb)new zzd<StatusCallback>(){

                public void zza(StatusCallback statusCallback) {
                    statusCallback.onPermissionChanged(bl);
                }

                public /* synthetic */ void zzu(Object object) {
                    this.zza((StatusCallback)object);
                }
            });
        }

        @Override
        public zzqs<StatusCallback> zzbxy() {
            return this.ars;
        }
    }

    private static class zzc
    extends zzi.zza
    implements zza<MessageListener> {
        private final zzqs<MessageListener> apQ;

        private zzc(zzqs<MessageListener> zzqs2) {
            this.apQ = zzqs2;
        }

        @Override
        public void zza(MessageWrapper messageWrapper) {
        }

        @Override
        public void zzb(MessageWrapper messageWrapper) {
        }

        @Override
        public void zzae(final List<Update> list) throws RemoteException {
            this.apQ.zza((zzqs.zzb)new zzd<MessageListener>(){

                public void zza(MessageListener messageListener) {
                    zzs.zza(list, messageListener);
                }

                public /* synthetic */ void zzu(Object object) {
                    this.zza((MessageListener)object);
                }
            });
        }

        @Override
        public zzqs<MessageListener> zzbxy() {
            return this.apQ;
        }
    }

    private static abstract class zzd<T>
    implements zzqs.zzb<T> {
        private zzd() {
        }

        public void zzapg() {
        }
    }

    private static interface zza<C> {
        public zzqs<C> zzbxy();
    }
}

