/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.nearby.messages.zzd;
import java.util.ArrayList;

public class Strategy
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<Strategy> CREATOR = new zzd();
    public static final int DISCOVERY_MODE_BROADCAST = 1;
    public static final int DISCOVERY_MODE_SCAN = 2;
    public static final int DISCOVERY_MODE_DEFAULT = 3;
    public static final int DISTANCE_TYPE_DEFAULT = 0;
    public static final int DISTANCE_TYPE_EARSHOT = 1;
    public static final int TTL_SECONDS_DEFAULT = 300;
    public static final int TTL_SECONDS_MAX = 86400;
    public static final int TTL_SECONDS_INFINITE = Integer.MAX_VALUE;
    public static final Strategy DEFAULT = new Builder().build();
    public static final Strategy BLE_ONLY;
    @Deprecated
    public static final Strategy apG;
    final int mVersionCode;
    @Deprecated
    final int apH;
    final int apI;
    final int apJ;
    @Deprecated
    final boolean apK;
    final int apL;
    final int apM;

    Strategy(int n, int n2, int n3, int n4, boolean bl, int n5, int n6) {
        this.mVersionCode = n;
        this.apH = n2;
        if (n2 == 0) {
            this.apM = n6;
        } else {
            switch (n2) {
                case 2: {
                    this.apM = 1;
                    break;
                }
                case 3: {
                    this.apM = 2;
                    break;
                }
                default: {
                    this.apM = 3;
                }
            }
        }
        this.apJ = n4;
        this.apK = bl;
        if (bl) {
            this.apL = 2;
            this.apI = Integer.MAX_VALUE;
        } else {
            this.apI = n3;
            switch (n5) {
                case -1: 
                case 0: 
                case 1: 
                case 6: {
                    this.apL = -1;
                    break;
                }
                default: {
                    this.apL = n5;
                }
            }
        }
    }

    public int zzbxq() {
        return this.apL;
    }

    public int zzbwp() {
        return this.apM;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzd.zza(this, parcel, n);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Strategy)) {
            return false;
        }
        Strategy strategy = (Strategy)((Object)object);
        return this.mVersionCode == strategy.mVersionCode && this.apM == strategy.apM && this.apI == strategy.apI && this.apJ == strategy.apJ && this.apL == strategy.apL;
    }

    public int hashCode() {
        int n = this.mVersionCode;
        n = 31 * n + this.apM;
        n = 31 * n + this.apI;
        n = 31 * n + this.apJ;
        n = 31 * n + this.apL;
        return n;
    }

    public String toString() {
        int n = this.apI;
        String string = String.valueOf(Strategy.zzxg(this.apJ));
        String string2 = String.valueOf(Strategy.zzxh(this.apL));
        String string3 = String.valueOf(Strategy.zzxi(this.apM));
        return new StringBuilder(81 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Strategy{ttlSeconds=").append(n).append(", distanceType=").append(string).append(", discoveryMedium=").append(string2).append(", discoveryMode=").append(string3).append("}").toString();
    }

    private static String zzxg(int n) {
        switch (n) {
            case 0: {
                return "DEFAULT";
            }
            case 1: {
                return "EARSHOT";
            }
        }
        return new StringBuilder(19).append("UNKNOWN:").append(n).toString();
    }

    private static String zzxh(int n) {
        if (n == -1) {
            return "DEFAULT";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if ((n & 4) > 0) {
            arrayList.add("ULTRASOUND");
        }
        if ((n & 2) > 0) {
            arrayList.add("BLE");
        }
        if (arrayList.isEmpty()) {
            return new StringBuilder(19).append("UNKNOWN:").append(n).toString();
        }
        return ((Object)arrayList).toString();
    }

    private static String zzxi(int n) {
        if (n == 3) {
            return "DEFAULT";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if ((n & 1) > 0) {
            arrayList.add("BROADCAST");
        }
        if ((n & 2) > 0) {
            arrayList.add("SCAN");
        }
        if (arrayList.isEmpty()) {
            return new StringBuilder(19).append("UNKNOWN:").append(n).toString();
        }
        return ((Object)arrayList).toString();
    }

    static {
        apG = BLE_ONLY = new Builder().zzxj(2).setTtlSeconds(Integer.MAX_VALUE).build();
    }

    public static class Builder {
        private int aos = 3;
        private int apN = 300;
        private int apO = 0;
        private int apP = -1;

        public Builder setDiscoveryMode(int n) {
            this.aos = n;
            return this;
        }

        public Builder zzxj(int n) {
            this.apP = n;
            return this;
        }

        public Builder setTtlSeconds(int n) {
            zzab.zzb((n == Integer.MAX_VALUE || n > 0 && n <= 86400 ? 1 : 0) != 0, (String)"mTtlSeconds(%d) must either be TTL_SECONDS_INFINITE, or it must be between 1 and TTL_SECONDS_MAX(%d) inclusive", (Object[])new Object[]{n, 86400});
            this.apN = n;
            return this;
        }

        public Builder setDistanceType(int n) {
            this.apO = n;
            return this;
        }

        public Strategy build() {
            if (this.apP == 2 && this.apO == 1) {
                throw new IllegalStateException("Cannot set EARSHOT with BLE only mode.");
            }
            return new Strategy(2, 0, this.apN, this.apO, false, this.apP, this.aos);
        }
    }
}

