/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.nearby.messages.zzd;
import java.util.ArrayList;

public class Strategy
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<Strategy> CREATOR = new zzd();
    public static final int DISCOVERY_MODE_BROADCAST = 1;
    public static final int DISCOVERY_MODE_SCAN = 2;
    public static final int DISCOVERY_MODE_DEFAULT = 3;
    public static final int DISTANCE_TYPE_DEFAULT = 0;
    public static final int DISTANCE_TYPE_EARSHOT = 1;
    public static final int TTL_SECONDS_DEFAULT = 300;
    public static final int TTL_SECONDS_MAX = 86400;
    public static final int TTL_SECONDS_INFINITE = Integer.MAX_VALUE;
    public static final Strategy DEFAULT = new Builder().build();
    public static final Strategy BLE_ONLY;
    @Deprecated
    public static final Strategy avK;
    final int mVersionCode;
    @Deprecated
    final int avL;
    final int avM;
    final int avN;
    @Deprecated
    final boolean avO;
    final int avP;
    final int avQ;

    Strategy(int n, int n2, int n3, int n4, boolean bl, int n5, int n6) {
        this.mVersionCode = n;
        this.avL = n2;
        if (n2 == 0) {
            this.avQ = n6;
        } else {
            switch (n2) {
                case 2: {
                    this.avQ = 1;
                    break;
                }
                case 3: {
                    this.avQ = 2;
                    break;
                }
                default: {
                    this.avQ = 3;
                }
            }
        }
        this.avN = n4;
        this.avO = bl;
        if (bl) {
            this.avP = 2;
            this.avM = Integer.MAX_VALUE;
        } else {
            this.avM = n3;
            switch (n5) {
                case -1: 
                case 0: 
                case 1: 
                case 6: {
                    this.avP = -1;
                    break;
                }
                default: {
                    this.avP = n5;
                }
            }
        }
    }

    public int zzcbb() {
        return this.avP;
    }

    public int zzbzz() {
        return this.avQ;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzd.zza(this, parcel, n);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Strategy)) {
            return false;
        }
        Strategy strategy = (Strategy)((Object)object);
        return this.mVersionCode == strategy.mVersionCode && this.avQ == strategy.avQ && this.avM == strategy.avM && this.avN == strategy.avN && this.avP == strategy.avP;
    }

    public int hashCode() {
        int n = this.mVersionCode;
        n = 31 * n + this.avQ;
        n = 31 * n + this.avM;
        n = 31 * n + this.avN;
        n = 31 * n + this.avP;
        return n;
    }

    public String toString() {
        int n = this.avM;
        String string = String.valueOf(Strategy.zzyk(this.avN));
        String string2 = String.valueOf(Strategy.zzyl(this.avP));
        String string3 = String.valueOf(Strategy.zzym(this.avQ));
        return new StringBuilder(81 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Strategy{ttlSeconds=").append(n).append(", distanceType=").append(string).append(", discoveryMedium=").append(string2).append(", discoveryMode=").append(string3).append("}").toString();
    }

    private static String zzyk(int n) {
        switch (n) {
            case 0: {
                return "DEFAULT";
            }
            case 1: {
                return "EARSHOT";
            }
        }
        return new StringBuilder(19).append("UNKNOWN:").append(n).toString();
    }

    private static String zzyl(int n) {
        if (n == -1) {
            return "DEFAULT";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if ((n & 4) > 0) {
            arrayList.add("ULTRASOUND");
        }
        if ((n & 2) > 0) {
            arrayList.add("BLE");
        }
        if (arrayList.isEmpty()) {
            return new StringBuilder(19).append("UNKNOWN:").append(n).toString();
        }
        return ((Object)arrayList).toString();
    }

    private static String zzym(int n) {
        if (n == 3) {
            return "DEFAULT";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if ((n & 1) > 0) {
            arrayList.add("BROADCAST");
        }
        if ((n & 2) > 0) {
            arrayList.add("SCAN");
        }
        if (arrayList.isEmpty()) {
            return new StringBuilder(19).append("UNKNOWN:").append(n).toString();
        }
        return ((Object)arrayList).toString();
    }

    static {
        avK = BLE_ONLY = new Builder().zzyn(2).setTtlSeconds(Integer.MAX_VALUE).build();
    }

    public static class Builder {
        private int auw = 3;
        private int avR = 300;
        private int avS = 0;
        private int avT = -1;

        public Builder setDiscoveryMode(int n) {
            this.auw = n;
            return this;
        }

        public Builder zzyn(int n) {
            this.avT = n;
            return this;
        }

        public Builder setTtlSeconds(int n) {
            zzac.zzb((n == Integer.MAX_VALUE || n > 0 && n <= 86400 ? 1 : 0) != 0, (String)"mTtlSeconds(%d) must either be TTL_SECONDS_INFINITE, or it must be between 1 and TTL_SECONDS_MAX(%d) inclusive", (Object[])new Object[]{n, 86400});
            this.avR = n;
            return this;
        }

        public Builder setDistanceType(int n) {
            this.avS = n;
            return this;
        }

        public Strategy build() {
            if (this.avT == 2 && this.avS == 1) {
                throw new IllegalStateException("Cannot set EARSHOT with BLE only mode.");
            }
            return new Strategy(2, 0, this.avR, this.avS, false, this.avT, this.auw);
        }
    }
}

