/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Looper;
import android.os.RemoteException;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzh;
import com.google.android.gms.internal.zzqc;
import com.google.android.gms.internal.zzrd;
import com.google.android.gms.internal.zzvv;
import com.google.android.gms.nearby.Nearby;
import com.google.android.gms.nearby.connection.AppMetadata;
import com.google.android.gms.nearby.connection.Connections;
import java.util.List;

public final class zzvw
implements Connections {
    public static final Api.zzf<zzvv> fa = new Api.zzf();
    public static final Api.zza<zzvv, Api.ApiOptions.NoOptions> fb = new Api.zza<zzvv, Api.ApiOptions.NoOptions>(){

        public zzvv zzr(Context context, Looper looper, zzh zzh2, Api.ApiOptions.NoOptions noOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return new zzvv(context, looper, zzh2, connectionCallbacks, onConnectionFailedListener);
        }

        public /* synthetic */ Api.zze zza(Context context, Looper looper, zzh zzh2, Object object, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return this.zzr(context, looper, zzh2, (Api.ApiOptions.NoOptions)object, connectionCallbacks, onConnectionFailedListener);
        }
    };

    public static zzvv zzd(GoogleApiClient googleApiClient, boolean bl) {
        zzac.zzb((googleApiClient != null ? 1 : 0) != 0, (Object)"GoogleApiClient parameter is required.");
        zzac.zza((boolean)googleApiClient.isConnected(), (Object)"GoogleApiClient must be connected.");
        return zzvw.zze(googleApiClient, bl);
    }

    public static zzvv zze(GoogleApiClient googleApiClient, boolean bl) {
        zzac.zza((boolean)googleApiClient.zza(Nearby.CONNECTIONS_API), (Object)"GoogleApiClient is not configured to use the Nearby Connections Api. Pass Nearby.CONNECTIONS_API into GoogleApiClient.Builder#addApi() to use this feature.");
        boolean bl2 = googleApiClient.hasConnectedApi(Nearby.CONNECTIONS_API);
        if (bl && !bl2) {
            throw new IllegalStateException("GoogleApiClient has an optional Nearby.CONNECTIONS_API and is not connected to Nearby Connections. Use GoogleApiClient.hasConnectedApi(Nearby.CONNECTIONS_API) to guard this call.");
        }
        return bl2 ? (zzvv)googleApiClient.zza(fa) : null;
    }

    @Override
    public String getLocalEndpointId(GoogleApiClient googleApiClient) {
        return zzvw.zzd(googleApiClient, true).zzcaa();
    }

    @Override
    public String getLocalDeviceId(GoogleApiClient googleApiClient) {
        return zzvw.zzd(googleApiClient, true).zzcab();
    }

    @Override
    public PendingResult<Connections.StartAdvertisingResult> startAdvertising(GoogleApiClient googleApiClient, final String string, final AppMetadata appMetadata, final long l, Connections.ConnectionRequestListener connectionRequestListener) {
        final zzrd zzrd2 = googleApiClient.zzs((Object)connectionRequestListener);
        return googleApiClient.zzd((zzqc.zza)new zzb(googleApiClient){

            protected void zza(zzvv zzvv2) throws RemoteException {
                zzvv2.zza((zzqc.zzb<Connections.StartAdvertisingResult>)this, string, appMetadata, l, (zzrd<Connections.ConnectionRequestListener>)zzrd2);
            }
        });
    }

    @Override
    public void stopAdvertising(GoogleApiClient googleApiClient) {
        zzvv zzvv2 = zzvw.zzd(googleApiClient, false);
        if (zzvv2 != null) {
            zzvv2.zzcac();
        }
    }

    @Override
    public PendingResult<Status> startDiscovery(GoogleApiClient googleApiClient, final String string, final long l, Connections.EndpointDiscoveryListener endpointDiscoveryListener) {
        final zzrd zzrd2 = googleApiClient.zzs((Object)endpointDiscoveryListener);
        return googleApiClient.zzd((zzqc.zza)new zzc(googleApiClient){

            protected void zza(zzvv zzvv2) throws RemoteException {
                zzvv2.zza((zzqc.zzb<Status>)this, string, l, (zzrd<Connections.EndpointDiscoveryListener>)zzrd2);
            }
        });
    }

    @Override
    public void stopDiscovery(GoogleApiClient googleApiClient, String string) {
        zzvv zzvv2 = zzvw.zzd(googleApiClient, false);
        if (zzvv2 != null) {
            zzvv2.zznm(string);
        }
    }

    @Override
    public PendingResult<Status> sendConnectionRequest(GoogleApiClient googleApiClient, final String string, final String string2, final byte[] byArray, Connections.ConnectionResponseCallback connectionResponseCallback, Connections.MessageListener messageListener) {
        final zzrd zzrd2 = googleApiClient.zzs((Object)connectionResponseCallback);
        final zzrd zzrd3 = googleApiClient.zzs((Object)messageListener);
        return googleApiClient.zzd((zzqc.zza)new zzc(googleApiClient){

            protected void zza(zzvv zzvv2) throws RemoteException {
                zzvv2.zza((zzqc.zzb<Status>)this, string, string2, byArray, (zzrd<Connections.ConnectionResponseCallback>)zzrd2, (zzrd<Connections.MessageListener>)zzrd3);
            }
        });
    }

    @Override
    public PendingResult<Status> acceptConnectionRequest(GoogleApiClient googleApiClient, final String string, final byte[] byArray, Connections.MessageListener messageListener) {
        final zzrd zzrd2 = googleApiClient.zzs((Object)messageListener);
        return googleApiClient.zzd((zzqc.zza)new zzc(googleApiClient){

            protected void zza(zzvv zzvv2) throws RemoteException {
                zzvv2.zza((zzqc.zzb<Status>)this, string, byArray, (zzrd<Connections.MessageListener>)zzrd2);
            }
        });
    }

    @Override
    public PendingResult<Status> rejectConnectionRequest(GoogleApiClient googleApiClient, final String string) {
        return googleApiClient.zzd((zzqc.zza)new zzc(googleApiClient){

            protected void zza(zzvv zzvv2) throws RemoteException {
                zzvv2.zzt((zzqc.zzb<Status>)this, string);
            }
        });
    }

    @Override
    public void sendReliableMessage(GoogleApiClient googleApiClient, String string, byte[] byArray) {
        zzvv zzvv2 = zzvw.zzd(googleApiClient, false);
        if (zzvv2 != null) {
            zzvv2.zza(new String[]{string}, byArray);
        }
    }

    @Override
    public void sendReliableMessage(GoogleApiClient googleApiClient, List<String> list, byte[] byArray) {
        zzvv zzvv2 = zzvw.zzd(googleApiClient, false);
        if (zzvv2 != null) {
            zzvv2.zza(list.toArray(new String[0]), byArray);
        }
    }

    @Override
    public void sendUnreliableMessage(GoogleApiClient googleApiClient, String string, byte[] byArray) {
        zzvv zzvv2 = zzvw.zzd(googleApiClient, false);
        if (zzvv2 != null) {
            zzvv2.zzb(new String[]{string}, byArray);
        }
    }

    @Override
    public void sendUnreliableMessage(GoogleApiClient googleApiClient, List<String> list, byte[] byArray) {
        zzvv zzvv2 = zzvw.zzd(googleApiClient, false);
        if (zzvv2 != null) {
            zzvv2.zzb(list.toArray(new String[0]), byArray);
        }
    }

    @Override
    public void disconnectFromEndpoint(GoogleApiClient googleApiClient, String string) {
        zzvv zzvv2 = zzvw.zzd(googleApiClient, false);
        if (zzvv2 != null) {
            zzvv2.zznn(string);
        }
    }

    @Override
    public void stopAllEndpoints(GoogleApiClient googleApiClient) {
        zzvv zzvv2 = zzvw.zzd(googleApiClient, false);
        if (zzvv2 != null) {
            zzvv2.zzcad();
        }
    }

    private static abstract class zzc
    extends zza<Status> {
        private zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Status zzb(Status status) {
            return status;
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzb(status);
        }
    }

    private static abstract class zzb
    extends zza<Connections.StartAdvertisingResult> {
        private zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Connections.StartAdvertisingResult zzdt(final Status status) {
            return new Connections.StartAdvertisingResult(){

                @Override
                public String getLocalEndpointName() {
                    return null;
                }

                public Status getStatus() {
                    return status;
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzdt(status);
        }
    }

    private static abstract class zza<R extends Result>
    extends zzqc.zza<R, zzvv> {
        public zza(GoogleApiClient googleApiClient) {
            super(Nearby.CONNECTIONS_API, googleApiClient);
        }
    }
}

