/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Looper;
import android.os.RemoteException;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.internal.zzqo;
import com.google.android.gms.internal.zzrr;
import com.google.android.gms.internal.zzwl;
import com.google.android.gms.nearby.Nearby;
import com.google.android.gms.nearby.connection.AppMetadata;
import com.google.android.gms.nearby.connection.Connections;
import java.util.List;

public final class zzwm
implements Connections {
    public static final Api.zzf<zzwl> hg = new Api.zzf();
    public static final Api.zza<zzwl, Api.ApiOptions.NoOptions> hh = new Api.zza<zzwl, Api.ApiOptions.NoOptions>(){

        public zzwl zzs(Context context, Looper looper, zzf zzf2, Api.ApiOptions.NoOptions noOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return new zzwl(context, looper, zzf2, connectionCallbacks, onConnectionFailedListener);
        }

        public /* synthetic */ Api.zze zza(Context context, Looper looper, zzf zzf2, Object object, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return this.zzs(context, looper, zzf2, (Api.ApiOptions.NoOptions)object, connectionCallbacks, onConnectionFailedListener);
        }
    };

    public static zzwl zzd(GoogleApiClient googleApiClient, boolean bl) {
        zzaa.zzb((googleApiClient != null ? 1 : 0) != 0, (Object)"GoogleApiClient parameter is required.");
        zzaa.zza((boolean)googleApiClient.isConnected(), (Object)"GoogleApiClient must be connected.");
        return zzwm.zze(googleApiClient, bl);
    }

    public static zzwl zze(GoogleApiClient googleApiClient, boolean bl) {
        zzaa.zza((boolean)googleApiClient.zza(Nearby.CONNECTIONS_API), (Object)"GoogleApiClient is not configured to use the Nearby Connections Api. Pass Nearby.CONNECTIONS_API into GoogleApiClient.Builder#addApi() to use this feature.");
        boolean bl2 = googleApiClient.hasConnectedApi(Nearby.CONNECTIONS_API);
        if (bl && !bl2) {
            throw new IllegalStateException("GoogleApiClient has an optional Nearby.CONNECTIONS_API and is not connected to Nearby Connections. Use GoogleApiClient.hasConnectedApi(Nearby.CONNECTIONS_API) to guard this call.");
        }
        return bl2 ? (zzwl)googleApiClient.zza(hg) : null;
    }

    @Override
    public String getLocalEndpointId(GoogleApiClient googleApiClient) {
        return zzwm.zzd(googleApiClient, true).zzcar();
    }

    @Override
    public String getLocalDeviceId(GoogleApiClient googleApiClient) {
        return zzwm.zzd(googleApiClient, true).zzcas();
    }

    @Override
    public PendingResult<Connections.StartAdvertisingResult> startAdvertising(GoogleApiClient googleApiClient, final String string, final AppMetadata appMetadata, final long l, Connections.ConnectionRequestListener connectionRequestListener) {
        final zzrr zzrr2 = googleApiClient.zzs((Object)connectionRequestListener);
        return googleApiClient.zzb((zzqo.zza)new zzb(googleApiClient){

            protected void zza(zzwl zzwl2) throws RemoteException {
                zzwl2.zza((zzqo.zzb<Connections.StartAdvertisingResult>)this, string, appMetadata, l, (zzrr<Connections.ConnectionRequestListener>)zzrr2);
            }
        });
    }

    @Override
    public void stopAdvertising(GoogleApiClient googleApiClient) {
        zzwl zzwl2 = zzwm.zzd(googleApiClient, false);
        if (zzwl2 != null) {
            zzwl2.zzcat();
        }
    }

    @Override
    public PendingResult<Status> startDiscovery(GoogleApiClient googleApiClient, final String string, final long l, Connections.EndpointDiscoveryListener endpointDiscoveryListener) {
        final zzrr zzrr2 = googleApiClient.zzs((Object)endpointDiscoveryListener);
        return googleApiClient.zzb((zzqo.zza)new zzc(googleApiClient){

            protected void zza(zzwl zzwl2) throws RemoteException {
                zzwl2.zza((zzqo.zzb<Status>)this, string, l, (zzrr<Connections.EndpointDiscoveryListener>)zzrr2);
            }
        });
    }

    @Override
    public void stopDiscovery(GoogleApiClient googleApiClient, String string) {
        zzwl zzwl2 = zzwm.zzd(googleApiClient, false);
        if (zzwl2 != null) {
            zzwl2.zznl(string);
        }
    }

    @Override
    public PendingResult<Status> sendConnectionRequest(GoogleApiClient googleApiClient, final String string, final String string2, final byte[] byArray, Connections.ConnectionResponseCallback connectionResponseCallback, Connections.MessageListener messageListener) {
        final zzrr zzrr2 = googleApiClient.zzs((Object)connectionResponseCallback);
        final zzrr zzrr3 = googleApiClient.zzs((Object)messageListener);
        return googleApiClient.zzb((zzqo.zza)new zzc(googleApiClient){

            protected void zza(zzwl zzwl2) throws RemoteException {
                zzwl2.zza((zzqo.zzb<Status>)this, string, string2, byArray, (zzrr<Connections.ConnectionResponseCallback>)zzrr2, (zzrr<Connections.MessageListener>)zzrr3);
            }
        });
    }

    @Override
    public PendingResult<Status> acceptConnectionRequest(GoogleApiClient googleApiClient, final String string, final byte[] byArray, Connections.MessageListener messageListener) {
        final zzrr zzrr2 = googleApiClient.zzs((Object)messageListener);
        return googleApiClient.zzb((zzqo.zza)new zzc(googleApiClient){

            protected void zza(zzwl zzwl2) throws RemoteException {
                zzwl2.zza((zzqo.zzb<Status>)this, string, byArray, (zzrr<Connections.MessageListener>)zzrr2);
            }
        });
    }

    @Override
    public PendingResult<Status> rejectConnectionRequest(GoogleApiClient googleApiClient, final String string) {
        return googleApiClient.zzb((zzqo.zza)new zzc(googleApiClient){

            protected void zza(zzwl zzwl2) throws RemoteException {
                zzwl2.zzt((zzqo.zzb<Status>)this, string);
            }
        });
    }

    @Override
    public void sendReliableMessage(GoogleApiClient googleApiClient, String string, byte[] byArray) {
        zzwl zzwl2 = zzwm.zzd(googleApiClient, false);
        if (zzwl2 != null) {
            zzwl2.zza(new String[]{string}, byArray);
        }
    }

    @Override
    public void sendReliableMessage(GoogleApiClient googleApiClient, List<String> list, byte[] byArray) {
        zzwl zzwl2 = zzwm.zzd(googleApiClient, false);
        if (zzwl2 != null) {
            zzwl2.zza(list.toArray(new String[0]), byArray);
        }
    }

    @Override
    public void sendUnreliableMessage(GoogleApiClient googleApiClient, String string, byte[] byArray) {
        zzwl zzwl2 = zzwm.zzd(googleApiClient, false);
        if (zzwl2 != null) {
            zzwl2.zzb(new String[]{string}, byArray);
        }
    }

    @Override
    public void sendUnreliableMessage(GoogleApiClient googleApiClient, List<String> list, byte[] byArray) {
        zzwl zzwl2 = zzwm.zzd(googleApiClient, false);
        if (zzwl2 != null) {
            zzwl2.zzb(list.toArray(new String[0]), byArray);
        }
    }

    @Override
    public void disconnectFromEndpoint(GoogleApiClient googleApiClient, String string) {
        zzwl zzwl2 = zzwm.zzd(googleApiClient, false);
        if (zzwl2 != null) {
            zzwl2.zznm(string);
        }
    }

    @Override
    public void stopAllEndpoints(GoogleApiClient googleApiClient) {
        zzwl zzwl2 = zzwm.zzd(googleApiClient, false);
        if (zzwl2 != null) {
            zzwl2.zzcau();
        }
    }

    private static abstract class zzc
    extends zza<Status> {
        private zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Status zzb(Status status) {
            return status;
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzb(status);
        }
    }

    private static abstract class zzb
    extends zza<Connections.StartAdvertisingResult> {
        private zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Connections.StartAdvertisingResult zzdy(final Status status) {
            return new Connections.StartAdvertisingResult(){

                @Override
                public String getLocalEndpointName() {
                    return null;
                }

                public Status getStatus() {
                    return status;
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzdy(status);
        }
    }

    private static abstract class zza<R extends Result>
    extends zzqo.zza<R, zzwl> {
        public zza(GoogleApiClient googleApiClient) {
            super(Nearby.CONNECTIONS_API, googleApiClient);
        }
    }
}

