/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.nearby.messages.devices.NearbyDevice;
import com.google.android.gms.nearby.messages.zza;
import java.util.Arrays;

public class Message
extends AbstractSafeParcelable {
    public static final int MAX_CONTENT_SIZE_BYTES = 102400;
    public static final int MAX_TYPE_LENGTH = 32;
    public static final Parcelable.Creator<Message> CREATOR = new zza();
    private static final NearbyDevice[] aym = new NearbyDevice[]{NearbyDevice.azd};
    public static final String MESSAGE_NAMESPACE_RESERVED = "__reserved_namespace";
    public static final String MESSAGE_TYPE_EDDYSTONE_UID = "__eddystone_uid";
    public static final String MESSAGE_TYPE_I_BEACON_ID = "__i_beacon_id";
    final int versionCode;
    private final byte[] content;
    private final String type;
    private final String EY;
    @Deprecated
    final NearbyDevice[] ayn;
    private final long ayo;

    Message(int n, @Nullable byte[] byArray, @Nullable String string, String string2, @Nullable NearbyDevice[] nearbyDeviceArray, long l) {
        this.versionCode = n;
        this.type = (String)zzaa.zzy((Object)string2);
        this.EY = string == null ? "" : string;
        this.ayo = 0L;
        if (Message.zzbc(this.EY, this.type)) {
            zzaa.zzb((byArray == null ? 1 : 0) != 0, (Object)"Content must be null for a device presence message.");
        } else {
            zzaa.zzy((Object)byArray);
            zzaa.zzb((byArray.length <= 102400 ? 1 : 0) != 0, (String)"Content length(%d) must not exceed MAX_CONTENT_SIZE_BYTES(%d)", (Object[])new Object[]{byArray.length, 102400});
        }
        this.content = byArray;
        if (nearbyDeviceArray == null || nearbyDeviceArray.length == 0) {
            nearbyDeviceArray = aym;
        }
        this.ayn = nearbyDeviceArray;
        zzaa.zzb((string2.length() <= 32 ? 1 : 0) != 0, (String)"Type length(%d) must not exceed MAX_TYPE_LENGTH(%d)", (Object[])new Object[]{string2.length(), 32});
    }

    public boolean zzcav() {
        return MESSAGE_NAMESPACE_RESERVED.equals(this.getNamespace());
    }

    public boolean zznn(String string) {
        return this.zzcav() && string.equals(this.getType());
    }

    @Deprecated
    public static boolean zzbc(String string, String string2) {
        return string.equals(MESSAGE_NAMESPACE_RESERVED) && string2.equals("__device_presence");
    }

    public Message(byte[] byArray) {
        this(byArray, "", "");
    }

    public Message(byte[] byArray, String string) {
        this(byArray, "", string);
    }

    public Message(byte[] byArray, String string, String string2) {
        this(byArray, string, string2, aym);
    }

    public Message(byte[] byArray, String string, String string2, NearbyDevice[] nearbyDeviceArray) {
        this(byArray, string, string2, nearbyDeviceArray, 0L);
    }

    public Message(byte[] byArray, String string, String string2, NearbyDevice[] nearbyDeviceArray, long l) {
        this(2, byArray, string, string2, nearbyDeviceArray, l);
    }

    public String getType() {
        return this.type;
    }

    public String getNamespace() {
        return this.EY;
    }

    public byte[] getContent() {
        return this.content;
    }

    public long zzcaw() {
        return 0L;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zza.zza(this, parcel, n);
    }

    public int hashCode() {
        Object[] objectArray = new Object[4];
        objectArray[0] = this.EY;
        objectArray[1] = this.type;
        objectArray[2] = Arrays.hashCode(this.content);
        objectArray[3] = 0L;
        return zzz.hashCode((Object[])objectArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Message)) {
            return false;
        }
        Message message = (Message)((Object)object);
        if (!TextUtils.equals((CharSequence)this.EY, (CharSequence)message.EY)) return false;
        if (!TextUtils.equals((CharSequence)this.type, (CharSequence)message.type)) return false;
        if (!Arrays.equals(this.content, message.content)) return false;
        if (0L != 0L) return false;
        return true;
    }

    public String toString() {
        String string = this.EY;
        String string2 = this.type;
        int n = this.content == null ? 0 : this.content.length;
        return new StringBuilder(59 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Message{namespace='").append(string).append("', type='").append(string2).append("', content=[").append(n).append(" bytes]}").toString();
    }
}

