/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.nearby.messages.ble.BleFilter;
import com.google.android.gms.nearby.messages.devices.NearbyDeviceFilter;
import com.google.android.gms.nearby.messages.internal.MessageType;
import com.google.android.gms.nearby.messages.zzb;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class MessageFilter
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<MessageFilter> CREATOR = new zzb();
    public static final MessageFilter INCLUDE_ALL_MY_TYPES = new Builder().includeAllMyTypes().build();
    final int mVersionCode;
    private final List<MessageType> ayp;
    private final List<NearbyDeviceFilter> ayq;
    private final boolean ayr;
    private final List<BleFilter> ays;

    MessageFilter(int n, List<MessageType> list, List<NearbyDeviceFilter> list2, boolean bl, List<BleFilter> list3) {
        this.mVersionCode = n;
        this.ayp = Collections.unmodifiableList((List)zzaa.zzy(list));
        this.ayr = bl;
        if (list2 == null) {
            list2 = Collections.emptyList();
        }
        this.ayq = Collections.unmodifiableList(list2);
        if (list3 == null) {
            list3 = Collections.emptyList();
        }
        this.ays = Collections.unmodifiableList(list3);
    }

    private MessageFilter(List<MessageType> list, List<NearbyDeviceFilter> list2, boolean bl, List<BleFilter> list3) {
        this(2, list, list2, bl, list3);
    }

    List<MessageType> zzcax() {
        return this.ayp;
    }

    boolean zzcay() {
        return this.ayr;
    }

    List<NearbyDeviceFilter> zzcaz() {
        return this.ayq;
    }

    List<BleFilter> zzcba() {
        return this.ays;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzb.zza(this, parcel, n);
    }

    public String toString() {
        boolean bl = this.ayr;
        String string = String.valueOf(this.ayp);
        return new StringBuilder(53 + String.valueOf(string).length()).append("MessageFilter{includeAllMyTypes=").append(bl).append(", messageTypes=").append(string).append("}").toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MessageFilter)) {
            return false;
        }
        MessageFilter messageFilter = (MessageFilter)((Object)object);
        return this.ayr == messageFilter.ayr && zzz.equal(this.ayp, messageFilter.ayp) && zzz.equal(this.ayq, messageFilter.ayq) && zzz.equal(this.ays, messageFilter.ays);
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{this.ayp, this.ayq, this.ayr, this.ays});
    }

    public static final class Builder {
        private final List<MessageType> ayt = new ArrayList<MessageType>();
        private final List<NearbyDeviceFilter> ayq = new ArrayList<NearbyDeviceFilter>();
        private final Set<BleFilter> ayu = new HashSet<BleFilter>();
        private boolean ayr;

        public Builder includeAllMyTypes() {
            this.ayr = true;
            return this;
        }

        public Builder includeNamespacedType(String string, String string2) {
            zzaa.zzb((string != null && !string.isEmpty() && !string.contains("*") ? 1 : 0) != 0, (String)"namespace(%s) cannot be null, empty or contain (*).", (Object[])new Object[]{string});
            zzaa.zzb((string2 != null && !string2.contains("*") ? 1 : 0) != 0, (String)"type(%s) cannot be null or contain (*).", (Object[])new Object[]{string2});
            return this.zzbd(string, string2);
        }

        public Builder includeFilter(MessageFilter messageFilter) {
            this.ayt.addAll(messageFilter.zzcax());
            this.ayq.addAll(messageFilter.zzcaz());
            this.ayr |= messageFilter.zzcay();
            return this;
        }

        public Builder includeEddystoneUids(String string, @Nullable String string2) {
            this.zzbd("__reserved_namespace", "__eddystone_uid");
            this.ayq.add(NearbyDeviceFilter.zzbe(string, string2));
            return this;
        }

        public Builder includeIBeaconIds(UUID uUID, @Nullable Short s, @Nullable Short s2) {
            this.zzbd("__reserved_namespace", "__i_beacon_id");
            this.ayq.add(NearbyDeviceFilter.zza(uUID, s, s2));
            return this;
        }

        private Builder zzbd(String string, String string2) {
            this.ayt.add(new MessageType(string, string2));
            return this;
        }

        public MessageFilter build() {
            zzaa.zza((this.ayr || !this.ayt.isEmpty() ? 1 : 0) != 0, (Object)"At least one of the include methods must be called.");
            return new MessageFilter(this.ayt, this.ayq, this.ayr, new ArrayList<BleFilter>(this.ayu));
        }
    }
}

