/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.SimpleArrayMap;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.internal.zzqo;
import com.google.android.gms.internal.zzrr;
import com.google.android.gms.nearby.messages.MessageListener;
import com.google.android.gms.nearby.messages.MessagesOptions;
import com.google.android.gms.nearby.messages.PublishCallback;
import com.google.android.gms.nearby.messages.PublishOptions;
import com.google.android.gms.nearby.messages.StatusCallback;
import com.google.android.gms.nearby.messages.SubscribeCallback;
import com.google.android.gms.nearby.messages.SubscribeOptions;
import com.google.android.gms.nearby.messages.internal.ClientAppContext;
import com.google.android.gms.nearby.messages.internal.GetPermissionStatusRequest;
import com.google.android.gms.nearby.messages.internal.HandleClientLifecycleEventRequest;
import com.google.android.gms.nearby.messages.internal.MessageWrapper;
import com.google.android.gms.nearby.messages.internal.PublishRequest;
import com.google.android.gms.nearby.messages.internal.RegisterStatusCallbackRequest;
import com.google.android.gms.nearby.messages.internal.SubscribeRequest;
import com.google.android.gms.nearby.messages.internal.UnpublishRequest;
import com.google.android.gms.nearby.messages.internal.UnsubscribeRequest;
import com.google.android.gms.nearby.messages.internal.Update;
import com.google.android.gms.nearby.messages.internal.zzi;
import com.google.android.gms.nearby.messages.internal.zzk;
import com.google.android.gms.nearby.messages.internal.zzl;
import com.google.android.gms.nearby.messages.internal.zzm;
import com.google.android.gms.nearby.messages.internal.zzn;
import com.google.android.gms.nearby.messages.internal.zzs;
import com.google.android.gms.nearby.messages.internal.zzu;
import java.util.List;

class zzr
extends zzj<zzk> {
    private final ClientAppContext azB;
    private final int ayz;
    private final zzh<StatusCallback, zzf> azC = new zzh<StatusCallback, zzf>(){

        protected zzf zzf(zzrr<StatusCallback> zzrr2) {
            return new zzf(zzrr2);
        }

        @Override
        protected /* synthetic */ zza zzg(zzrr zzrr2) {
            return this.zzf((zzrr<StatusCallback>)zzrr2);
        }
    };
    private final zzh<MessageListener, zzc> azD = new zzh<MessageListener, zzc>(){

        protected zzc zzh(zzrr<MessageListener> zzrr2) {
            return new zzc(zzrr2);
        }

        @Override
        protected /* synthetic */ zza zzg(zzrr zzrr2) {
            return this.zzh((zzrr<MessageListener>)zzrr2);
        }
    };
    private final zzh<SubscribeCallback, zzg> azE = new zzh<SubscribeCallback, zzg>(){

        protected zzg zzi(zzrr<SubscribeCallback> zzrr2) {
            return new zzg(zzrr2);
        }

        @Override
        protected /* synthetic */ zza zzg(zzrr zzrr2) {
            return this.zzi((zzrr<SubscribeCallback>)zzrr2);
        }
    };
    private final zzh<PublishCallback, zze> azF = new zzh<PublishCallback, zze>(){

        protected zze zzj(zzrr<PublishCallback> zzrr2) {
            return new zze(zzrr2);
        }

        @Override
        protected /* synthetic */ zza zzg(zzrr zzrr2) {
            return this.zzj((zzrr<PublishCallback>)zzrr2);
        }
    };

    private static int zzdr(Context context) {
        if (context instanceof Activity) {
            return 1;
        }
        if (context instanceof Application) {
            return 2;
        }
        if (context instanceof Service) {
            return 3;
        }
        return 0;
    }

    @TargetApi(value=14)
    zzr(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, com.google.android.gms.common.internal.zzf zzf2, MessagesOptions messagesOptions) {
        super(context, looper, 62, zzf2, connectionCallbacks, onConnectionFailedListener);
        String string = zzf2.zzavs();
        int n = zzr.zzdr(context);
        if (messagesOptions != null) {
            this.azB = new ClientAppContext(string, messagesOptions.ayv, messagesOptions.ayw, messagesOptions.ayy, n);
            this.ayz = messagesOptions.ayx;
        } else {
            this.azB = new ClientAppContext(string, null, false, null, n);
            this.ayz = -1;
        }
        if (n == 1 && com.google.android.gms.common.util.zzs.zzayq()) {
            Activity activity = (Activity)context;
            Log.v((String)"NearbyMessagesClient", (String)String.format("Registering ClientLifecycleSafetyNet's ActivityLifecycleCallbacks for %s", activity.getPackageName()));
            activity.getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new zzb(activity, this));
        }
    }

    @NonNull
    protected Bundle zzahv() {
        Bundle bundle = super.zzahv();
        bundle.putInt("NearbyPermissions", this.ayz);
        bundle.putParcelable("ClientAppContext", (Parcelable)this.azB);
        return bundle;
    }

    @NonNull
    protected String zzjx() {
        return "com.google.android.gms.nearby.messages.service.NearbyMessagesService.START";
    }

    @NonNull
    protected String zzjy() {
        return "com.google.android.gms.nearby.messages.internal.INearbyMessagesService";
    }

    protected zzk zzkg(IBinder iBinder) {
        return zzk.zza.zzkc(iBinder);
    }

    public void disconnect() {
        try {
            this.zzyp(2);
        }
        catch (RemoteException remoteException) {
            Log.v((String)"NearbyMessagesClient", (String)String.format("Failed to emit CLIENT_DISCONNECTED from override of GmsClient#disconnect(): %s", new Object[]{remoteException}));
        }
        super.disconnect();
    }

    void zza(zzqo.zzb<Status> zzb2, MessageWrapper messageWrapper, @Nullable zzrr<PublishCallback> zzrr2, PublishOptions publishOptions) throws RemoteException {
        PublishRequest publishRequest = new PublishRequest(messageWrapper, publishOptions.getStrategy(), (IBinder)zzu.zzu(zzb2), (IBinder)zze.zzk((zzrr<PublishCallback>)zzrr2));
        ((zzk)this.zzavg()).zza(publishRequest);
    }

    void zza(zzqo.zzb<Status> zzb2, MessageWrapper messageWrapper) throws RemoteException {
        UnpublishRequest unpublishRequest = new UnpublishRequest(messageWrapper, (IBinder)zzu.zzu(zzb2), this.azB);
        ((zzk)this.zzavg()).zza(unpublishRequest);
    }

    void zza(zzqo.zzb<Status> zzb2, zzrr<MessageListener> zzrr2, MessageListener messageListener, @Nullable zzrr<SubscribeCallback> zzrr3, SubscribeOptions subscribeOptions, @Nullable byte[] byArray) throws RemoteException {
        SubscribeRequest subscribeRequest = new SubscribeRequest((IBinder)this.azD.zza(zzrr2, messageListener), subscribeOptions.getStrategy(), (IBinder)zzu.zzu(zzb2), subscribeOptions.getFilter(), null, 0, byArray, (IBinder)zzg.zzm((zzrr<SubscribeCallback>)zzrr3), subscribeOptions.ayR);
        ((zzk)this.zzavg()).zza(subscribeRequest);
    }

    void zza(zzqo.zzb<Status> zzb2, PendingIntent pendingIntent, @Nullable zzrr<SubscribeCallback> zzrr2, SubscribeOptions subscribeOptions) throws RemoteException {
        SubscribeRequest subscribeRequest = new SubscribeRequest(null, subscribeOptions.getStrategy(), (IBinder)zzu.zzu(zzb2), subscribeOptions.getFilter(), pendingIntent, 0, null, (IBinder)zzg.zzm((zzrr<SubscribeCallback>)zzrr2), subscribeOptions.ayR);
        ((zzk)this.zzavg()).zza(subscribeRequest);
    }

    void zza(zzqo.zzb<Status> zzb2, MessageListener messageListener) throws RemoteException {
        if (this.azD.zzaj(messageListener) == null) {
            return;
        }
        UnsubscribeRequest unsubscribeRequest = new UnsubscribeRequest((IBinder)this.azD.zzaj(messageListener), (IBinder)zzu.zzu(zzb2), null, 0);
        ((zzk)this.zzavg()).zza(unsubscribeRequest);
        this.azD.zzak(messageListener);
    }

    void zza(zzqo.zzb<Status> zzb2, PendingIntent pendingIntent) throws RemoteException {
        UnsubscribeRequest unsubscribeRequest = new UnsubscribeRequest(null, (IBinder)zzu.zzu(zzb2), pendingIntent, 0);
        ((zzk)this.zzavg()).zza(unsubscribeRequest);
    }

    void zzt(zzqo.zzb<Status> zzb2) throws RemoteException {
        GetPermissionStatusRequest getPermissionStatusRequest = new GetPermissionStatusRequest((IBinder)zzu.zzu(zzb2));
        ((zzk)this.zzavg()).zza(getPermissionStatusRequest);
    }

    void zza(zzqo.zzb<Status> zzb2, zzrr<StatusCallback> zzrr2, StatusCallback statusCallback) throws RemoteException {
        RegisterStatusCallbackRequest registerStatusCallbackRequest = new RegisterStatusCallbackRequest((IBinder)zzu.zzu(zzb2), (IBinder)this.azC.zza(zzrr2, statusCallback));
        registerStatusCallbackRequest.aAe = true;
        ((zzk)this.zzavg()).zza(registerStatusCallbackRequest);
    }

    void zza(zzqo.zzb<Status> zzb2, StatusCallback statusCallback) throws RemoteException {
        if (this.azC.zzaj(statusCallback) == null) {
            return;
        }
        RegisterStatusCallbackRequest registerStatusCallbackRequest = new RegisterStatusCallbackRequest((IBinder)zzu.zzu(zzb2), (IBinder)this.azC.zzaj(statusCallback));
        registerStatusCallbackRequest.aAe = false;
        ((zzk)this.zzavg()).zza(registerStatusCallbackRequest);
        this.azC.zzak(statusCallback);
    }

    void zzyp(int n) throws RemoteException {
        String string;
        switch (n) {
            case 1: {
                string = "ACTIVITY_STOPPED";
                break;
            }
            case 2: {
                string = "CLIENT_DISCONNECTED";
                break;
            }
            default: {
                Log.w((String)"NearbyMessagesClient", (String)String.format("Received unknown/unforeseen client lifecycle event %d, can't do anything with it.", n));
                return;
            }
        }
        if (this.isConnected()) {
            HandleClientLifecycleEventRequest handleClientLifecycleEventRequest = new HandleClientLifecycleEventRequest(n);
            Log.d((String)"NearbyMessagesClient", (String)String.format("Emitting client lifecycle event %s", string));
            ((zzk)this.zzavg()).zza(handleClientLifecycleEventRequest);
        } else {
            Log.d((String)"NearbyMessagesClient", (String)String.format("Failed to emit client lifecycle event %s due to GmsClient being disconnected", string));
        }
    }

    @Nullable
    zzrr<MessageListener> zza(GoogleApiClient googleApiClient, MessageListener messageListener) {
        return zzr.zza(googleApiClient, messageListener, this.azD);
    }

    @Nullable
    zzrr<StatusCallback> zza(GoogleApiClient googleApiClient, StatusCallback statusCallback) {
        return zzr.zza(googleApiClient, statusCallback, this.azC);
    }

    @Nullable
    zzrr<SubscribeCallback> zza(GoogleApiClient googleApiClient, SubscribeCallback subscribeCallback) {
        return zzr.zza(googleApiClient, subscribeCallback, this.azE);
    }

    @Nullable
    zzrr<PublishCallback> zza(GoogleApiClient googleApiClient, PublishCallback publishCallback) {
        return zzr.zza(googleApiClient, publishCallback, this.azF);
    }

    @Nullable
    private static <C> zzrr<C> zza(GoogleApiClient googleApiClient, C c, zzh<C, ? extends zza<C>> zzh2) {
        if (c == null) {
            return null;
        }
        zza<C> zza2 = zzh2.zzaj(c);
        if (zza2 != null) {
            return zza2.zzcbj();
        }
        return googleApiClient.zzs(c);
    }

    protected /* synthetic */ IInterface zzh(IBinder iBinder) {
        return this.zzkg(iBinder);
    }

    private static abstract class zzh<C, W extends zza<C>> {
        private final SimpleArrayMap<C, W> FZ = new SimpleArrayMap(1);

        private zzh() {
        }

        @Nullable
        W zzaj(C c) {
            return (W)((zza)this.FZ.get(c));
        }

        W zza(zzrr<C> zzrr2, C c) {
            zza<Object> zza2 = (zza)this.FZ.get(c);
            if (zza2 != null) {
                zzrr2.clear();
                return (W)zza2;
            }
            zza2 = this.zzg(zzrr2);
            this.FZ.put(c, (Object)zza2);
            return (W)zza2;
        }

        @Nullable
        W zzak(C c) {
            zza zza2 = (zza)this.FZ.remove(c);
            if (zza2 != null) {
                zza2.zzcbj().clear();
            }
            return (W)zza2;
        }

        protected abstract W zzg(zzrr<C> var1);
    }

    @TargetApi(value=14)
    private static class zzb
    implements Application.ActivityLifecycleCallbacks {
        private final Activity azH;
        private final zzr azI;

        private zzb(Activity activity, zzr zzr2) {
            this.azH = activity;
            this.azI = zzr2;
        }

        public void onActivityCreated(Activity activity, Bundle bundle) {
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
            if (activity == this.azH) {
                try {
                    this.azI.zzyp(1);
                }
                catch (RemoteException remoteException) {
                    Log.v((String)"NearbyMessagesClient", (String)String.format("Failed to emit ACTIVITY_STOPPED from ClientLifecycleSafetyNet for Activity %s: %s", new Object[]{activity.getPackageName(), remoteException}));
                }
            }
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }

        public void onActivityDestroyed(Activity activity) {
            if (activity == this.azH) {
                Log.v((String)"NearbyMessagesClient", (String)String.format("Unregistering ClientLifecycleSafetyNet's ActivityLifecycleCallbacks for %s", activity.getPackageName()));
                activity.getApplication().unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            }
        }
    }

    private static class zze
    extends zzl.zza
    implements zza<PublishCallback> {
        private static final zzd<PublishCallback> azL = new zzd<PublishCallback>(){

            public void zza(PublishCallback publishCallback) {
                publishCallback.onExpired();
            }

            public /* synthetic */ void zzt(Object object) {
                this.zza((PublishCallback)object);
            }
        };
        private final zzrr<PublishCallback> azM;

        private zze(zzrr<PublishCallback> zzrr2) {
            this.azM = zzrr2;
        }

        @Nullable
        private static zze zzk(@Nullable zzrr<PublishCallback> zzrr2) {
            return zzrr2 == null ? null : new zze(zzrr2);
        }

        @Override
        public void onExpired() {
            this.azM.zza(azL);
        }

        @Override
        public zzrr<PublishCallback> zzcbj() {
            return this.azM;
        }
    }

    private static class zzg
    extends zzn.zza
    implements zza<SubscribeCallback> {
        private static final zzd<SubscribeCallback> azL = new zzd<SubscribeCallback>(){

            public void zza(SubscribeCallback subscribeCallback) {
                subscribeCallback.onExpired();
            }

            public /* synthetic */ void zzt(Object object) {
                this.zza((SubscribeCallback)object);
            }
        };
        private final zzrr<SubscribeCallback> azM;

        private zzg(zzrr<SubscribeCallback> zzrr2) {
            this.azM = zzrr2;
        }

        @Nullable
        private static zzg zzm(@Nullable zzrr<SubscribeCallback> zzrr2) {
            return zzrr2 == null ? null : new zzg(zzrr2);
        }

        @Override
        public void onExpired() {
            this.azM.zza(azL);
        }

        @Override
        public zzrr<SubscribeCallback> zzcbj() {
            return this.azM;
        }
    }

    private static class zzf
    extends zzm.zza
    implements zza<StatusCallback> {
        private final zzrr<StatusCallback> azM;

        private zzf(zzrr<StatusCallback> zzrr2) {
            this.azM = zzrr2;
        }

        @Override
        public void onPermissionChanged(final boolean bl) {
            this.azM.zza((zzrr.zzc)new zzd<StatusCallback>(){

                public void zza(StatusCallback statusCallback) {
                    statusCallback.onPermissionChanged(bl);
                }

                public /* synthetic */ void zzt(Object object) {
                    this.zza((StatusCallback)object);
                }
            });
        }

        @Override
        public zzrr<StatusCallback> zzcbj() {
            return this.azM;
        }
    }

    private static class zzc
    extends zzi.zza
    implements zza<MessageListener> {
        private final zzrr<MessageListener> Bt;

        private zzc(zzrr<MessageListener> zzrr2) {
            this.Bt = zzrr2;
        }

        @Override
        public void zza(MessageWrapper messageWrapper) {
        }

        @Override
        public void zzb(MessageWrapper messageWrapper) {
        }

        @Override
        public void zzah(final List<Update> list) throws RemoteException {
            this.Bt.zza((zzrr.zzc)new zzd<MessageListener>(){

                public void zza(MessageListener messageListener) {
                    zzs.zza(list, messageListener);
                }

                public /* synthetic */ void zzt(Object object) {
                    this.zza((MessageListener)object);
                }
            });
        }

        @Override
        public zzrr<MessageListener> zzcbj() {
            return this.Bt;
        }
    }

    private static abstract class zzd<T>
    implements zzrr.zzc<T> {
        private zzd() {
        }

        public void zzasm() {
        }
    }

    private static interface zza<C> {
        public zzrr<C> zzcbj();
    }
}

