/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.places;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.location.places.zza;

@SafeParcelable.Class(creator="PlaceReportCreator")
public class PlaceReport
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final Parcelable.Creator<PlaceReport> CREATOR = new zza();
    @SafeParcelable.VersionField(id=1)
    private final int versionCode;
    @SafeParcelable.Field(id=2, getter="getPlaceId")
    private final String zza;
    @SafeParcelable.Field(id=3, getter="getTag")
    private final String tag;
    @SafeParcelable.Field(id=4, getter="getSource")
    private final String zzb;

    @VisibleForTesting
    public static PlaceReport create(String string, String string2) {
        boolean bl;
        String string3 = "unknown";
        String string4 = string2;
        String string5 = string;
        Preconditions.checkNotNull((Object)string5);
        Preconditions.checkNotEmpty((String)string4);
        Preconditions.checkNotEmpty((String)string3);
        switch (string3) {
            case "unknown": 
            case "userReported": 
            case "inferredGeofencing": 
            case "inferredRadioSignals": 
            case "inferredReverseGeocoding": 
            case "inferredSnappedToRoad": {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        Preconditions.checkArgument((boolean)bl, (Object)"Invalid source");
        return new PlaceReport(1, string5, string4, string3);
    }

    @SafeParcelable.Constructor
    PlaceReport(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) String string2, @SafeParcelable.Param(id=4) String string3) {
        this.versionCode = n;
        this.zza = string;
        this.tag = string2;
        this.zzb = string3;
    }

    public String getPlaceId() {
        return this.zza;
    }

    public String getTag() {
        return this.tag;
    }

    public String toString() {
        Objects.ToStringHelper toStringHelper = Objects.toStringHelper((Object)((Object)this));
        toStringHelper.add("placeId", (Object)this.zza);
        toStringHelper.add("tag", (Object)this.tag);
        if (!"unknown".equals(this.zzb)) {
            toStringHelper.add("source", (Object)this.zzb);
        }
        return toStringHelper.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof PlaceReport)) {
            return false;
        }
        PlaceReport placeReport = (PlaceReport)((Object)object);
        return Objects.equal((Object)this.zza, (Object)placeReport.zza) && Objects.equal((Object)this.tag, (Object)placeReport.tag) && Objects.equal((Object)this.zzb, (Object)placeReport.zzb);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zza, this.tag, this.zzb});
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PlaceReport placeReport = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1, (int)placeReport.versionCode);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)placeReport.getPlaceId(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)placeReport.getTag(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)4, (String)placeReport.zzb, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }
}

