/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.places.ui;

import android.annotation.TargetApi;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import com.google.android.gms.R;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.places.AutocompleteFilter;
import com.google.android.gms.location.places.Place;
import com.google.android.gms.location.places.ui.PlaceAutocomplete;
import com.google.android.gms.location.places.ui.PlaceSelectionListener;
import com.google.android.gms.maps.model.LatLngBounds;

@TargetApi(value=12)
public class PlaceAutocompleteFragment
extends Fragment {
    private View zzbmN;
    private View zzbmO;
    private EditText zzbmP;
    private boolean zzbmQ;
    @Nullable
    private LatLngBounds zzbmR;
    @Nullable
    private AutocompleteFilter zzbmS;
    @Nullable
    private PlaceSelectionListener zzbmT;

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        View view = layoutInflater.inflate(R.layout.place_autocomplete_fragment, viewGroup, false);
        this.zzbmN = view.findViewById(R.id.place_autocomplete_search_button);
        this.zzbmO = view.findViewById(R.id.place_autocomplete_clear_button);
        this.zzbmP = (EditText)view.findViewById(R.id.place_autocomplete_search_input);
        View.OnClickListener onClickListener = new View.OnClickListener(){

            public void onClick(View view) {
                if (!PlaceAutocompleteFragment.this.zzbmQ) {
                    PlaceAutocompleteFragment.this.zzIw();
                }
            }
        };
        this.zzbmN.setOnClickListener(onClickListener);
        this.zzbmP.setOnClickListener(onClickListener);
        this.zzbmO.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                PlaceAutocompleteFragment.this.setText("");
            }
        });
        this.zzIv();
        return view;
    }

    public void onDestroyView() {
        this.zzbmN = null;
        this.zzbmO = null;
        this.zzbmP = null;
        super.onDestroyView();
    }

    public void setBoundsBias(@Nullable LatLngBounds latLngBounds) {
        this.zzbmR = latLngBounds;
    }

    public void setFilter(@Nullable AutocompleteFilter autocompleteFilter) {
        this.zzbmS = autocompleteFilter;
    }

    public void setText(CharSequence charSequence) {
        this.zzbmP.setText(charSequence);
        this.zzIv();
    }

    public void setHint(CharSequence charSequence) {
        this.zzbmP.setHint(charSequence);
        this.zzbmN.setContentDescription(charSequence);
    }

    public void setOnPlaceSelectedListener(PlaceSelectionListener placeSelectionListener) {
        this.zzbmT = placeSelectionListener;
    }

    private void zzIv() {
        boolean bl = !this.zzbmP.getText().toString().isEmpty();
        this.zzbmO.setVisibility(bl ? 0 : 8);
    }

    private void zzIw() {
        GoogleApiAvailability googleApiAvailability;
        int n = -1;
        try {
            googleApiAvailability = new PlaceAutocomplete.IntentBuilder(2).setBoundsBias(this.zzbmR).setFilter(this.zzbmS).zzfd(this.zzbmP.getText().toString()).zzkU(1).build(this.getActivity());
            this.zzbmQ = true;
            this.startActivityForResult((Intent)googleApiAvailability, 30421);
        }
        catch (GooglePlayServicesRepairableException googlePlayServicesRepairableException) {
            n = googlePlayServicesRepairableException.getConnectionStatusCode();
            Log.e((String)"Places", (String)"Could not open autocomplete activity", (Throwable)googlePlayServicesRepairableException);
        }
        catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
            n = googlePlayServicesNotAvailableException.errorCode;
            Log.e((String)"Places", (String)"Could not open autocomplete activity", (Throwable)googlePlayServicesNotAvailableException);
        }
        if (n != -1) {
            googleApiAvailability = GoogleApiAvailability.getInstance();
            googleApiAvailability.showErrorDialogFragment(this.getActivity(), n, 30422);
        }
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        this.zzbmQ = false;
        if (n == 30421) {
            if (n2 == -1) {
                Place place = PlaceAutocomplete.getPlace((Context)this.getActivity(), intent);
                if (this.zzbmT != null) {
                    this.zzbmT.onPlaceSelected(place);
                }
                this.setText(place.getName().toString());
            } else if (n2 == 2) {
                Status status = PlaceAutocomplete.getStatus((Context)this.getActivity(), intent);
                if (this.zzbmT != null) {
                    this.zzbmT.onError(status);
                }
            }
        }
        super.onActivityResult(n, n2, intent);
    }
}

