/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.places.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import com.google.android.gms.R;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.places.AutocompleteFilter;
import com.google.android.gms.location.places.Place;
import com.google.android.gms.location.places.ui.PlaceAutocomplete;
import com.google.android.gms.location.places.ui.PlaceSelectionListener;
import com.google.android.gms.location.places.ui.zze;
import com.google.android.gms.location.places.ui.zzf;
import com.google.android.gms.maps.model.LatLngBounds;

public class SupportPlaceAutocompleteFragment
extends Fragment {
    private View zzblq;
    private View zzblr;
    private EditText zzbls;
    private boolean zzblt;
    @Nullable
    private LatLngBounds zzblu;
    @Nullable
    private AutocompleteFilter zzblv;
    @Nullable
    private PlaceSelectionListener zzblw;

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        View view = layoutInflater.inflate(R.layout.place_autocomplete_fragment, viewGroup, false);
        this.zzblq = view.findViewById(R.id.place_autocomplete_search_button);
        this.zzblr = view.findViewById(R.id.place_autocomplete_clear_button);
        this.zzbls = (EditText)view.findViewById(R.id.place_autocomplete_search_input);
        zze zze2 = new zze(this);
        this.zzblq.setOnClickListener((View.OnClickListener)zze2);
        this.zzbls.setOnClickListener((View.OnClickListener)zze2);
        this.zzblr.setOnClickListener((View.OnClickListener)new zzf(this));
        this.zzwa();
        return view;
    }

    public void onDestroyView() {
        this.zzblq = null;
        this.zzblr = null;
        this.zzbls = null;
        super.onDestroyView();
    }

    public void setBoundsBias(@Nullable LatLngBounds latLngBounds) {
        this.zzblu = latLngBounds;
    }

    public void setFilter(@Nullable AutocompleteFilter autocompleteFilter) {
        this.zzblv = autocompleteFilter;
    }

    public void setText(CharSequence charSequence) {
        this.zzbls.setText(charSequence);
        this.zzwa();
    }

    public void setHint(CharSequence charSequence) {
        this.zzbls.setHint(charSequence);
        this.zzblq.setContentDescription(charSequence);
    }

    public void setOnPlaceSelectedListener(PlaceSelectionListener placeSelectionListener) {
        this.zzblw = placeSelectionListener;
    }

    private final void zzwa() {
        boolean bl = !this.zzbls.getText().toString().isEmpty();
        this.zzblr.setVisibility(bl ? 0 : 8);
    }

    private final void zzwb() {
        int n = -1;
        try {
            Intent intent = new PlaceAutocomplete.IntentBuilder(2).setBoundsBias(this.zzblu).setFilter(this.zzblv).zzdC(this.zzbls.getText().toString()).zzbm(1).build((Activity)this.getActivity());
            this.zzblt = true;
            this.startActivityForResult(intent, 30421);
        }
        catch (GooglePlayServicesRepairableException googlePlayServicesRepairableException) {
            GooglePlayServicesRepairableException googlePlayServicesRepairableException2 = googlePlayServicesRepairableException;
            n = googlePlayServicesRepairableException.getConnectionStatusCode();
            Log.e((String)"Places", (String)"Could not open autocomplete activity", (Throwable)googlePlayServicesRepairableException2);
        }
        catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
            GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException2 = googlePlayServicesNotAvailableException;
            n = googlePlayServicesNotAvailableException.errorCode;
            Log.e((String)"Places", (String)"Could not open autocomplete activity", (Throwable)googlePlayServicesNotAvailableException2);
        }
        if (n != -1) {
            GoogleApiAvailability.getInstance().showErrorDialogFragment((Activity)this.getActivity(), n, 30422);
        }
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        this.zzblt = false;
        if (n == 30421) {
            if (n2 == -1) {
                Place place = PlaceAutocomplete.getPlace((Context)this.getActivity(), intent);
                if (this.zzblw != null) {
                    this.zzblw.onPlaceSelected(place);
                }
                this.setText(place.getName().toString());
            } else if (n2 == 2) {
                Status status = PlaceAutocomplete.getStatus((Context)this.getActivity(), intent);
                if (this.zzblw != null) {
                    this.zzblw.onError(status);
                }
            }
        }
        super.onActivityResult(n, n2, intent);
    }

    static /* synthetic */ boolean zza(SupportPlaceAutocompleteFragment supportPlaceAutocompleteFragment) {
        return supportPlaceAutocompleteFragment.zzblt;
    }

    static /* synthetic */ void zzb(SupportPlaceAutocompleteFragment supportPlaceAutocompleteFragment) {
        supportPlaceAutocompleteFragment.zzwb();
    }
}

