/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.places.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import com.google.android.gms.R;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.places.AutocompleteFilter;
import com.google.android.gms.location.places.Place;
import com.google.android.gms.location.places.ui.PlaceAutocomplete;
import com.google.android.gms.location.places.ui.PlaceSelectionListener;
import com.google.android.gms.location.places.ui.zze;
import com.google.android.gms.location.places.ui.zzf;
import com.google.android.gms.maps.model.LatLngBounds;

public class SupportPlaceAutocompleteFragment
extends Fragment {
    private View zzblm;
    private View zzbln;
    private EditText zzblo;
    private boolean zzblp;
    @Nullable
    private LatLngBounds zzblq;
    @Nullable
    private AutocompleteFilter zzblr;
    @Nullable
    private PlaceSelectionListener zzbls;

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        View view = layoutInflater.inflate(R.layout.place_autocomplete_fragment, viewGroup, false);
        this.zzblm = view.findViewById(R.id.place_autocomplete_search_button);
        this.zzbln = view.findViewById(R.id.place_autocomplete_clear_button);
        this.zzblo = (EditText)view.findViewById(R.id.place_autocomplete_search_input);
        zze zze2 = new zze(this);
        this.zzblm.setOnClickListener((View.OnClickListener)zze2);
        this.zzblo.setOnClickListener((View.OnClickListener)zze2);
        this.zzbln.setOnClickListener((View.OnClickListener)new zzf(this));
        this.zzwb();
        return view;
    }

    public void onDestroyView() {
        this.zzblm = null;
        this.zzbln = null;
        this.zzblo = null;
        super.onDestroyView();
    }

    public void setBoundsBias(@Nullable LatLngBounds latLngBounds) {
        this.zzblq = latLngBounds;
    }

    public void setFilter(@Nullable AutocompleteFilter autocompleteFilter) {
        this.zzblr = autocompleteFilter;
    }

    public void setText(CharSequence charSequence) {
        this.zzblo.setText(charSequence);
        this.zzwb();
    }

    public void setHint(CharSequence charSequence) {
        this.zzblo.setHint(charSequence);
        this.zzblm.setContentDescription(charSequence);
    }

    public void setOnPlaceSelectedListener(PlaceSelectionListener placeSelectionListener) {
        this.zzbls = placeSelectionListener;
    }

    private final void zzwb() {
        boolean bl = !this.zzblo.getText().toString().isEmpty();
        this.zzbln.setVisibility(bl ? 0 : 8);
    }

    private final void zzwc() {
        int n = -1;
        try {
            Intent intent = new PlaceAutocomplete.IntentBuilder(2).setBoundsBias(this.zzblq).setFilter(this.zzblr).zzdB(this.zzblo.getText().toString()).zzbn(1).build((Activity)this.getActivity());
            this.zzblp = true;
            this.startActivityForResult(intent, 30421);
        }
        catch (GooglePlayServicesRepairableException googlePlayServicesRepairableException) {
            GooglePlayServicesRepairableException googlePlayServicesRepairableException2 = googlePlayServicesRepairableException;
            n = googlePlayServicesRepairableException.getConnectionStatusCode();
            Log.e((String)"Places", (String)"Could not open autocomplete activity", (Throwable)googlePlayServicesRepairableException2);
        }
        catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
            GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException2 = googlePlayServicesNotAvailableException;
            n = googlePlayServicesNotAvailableException.errorCode;
            Log.e((String)"Places", (String)"Could not open autocomplete activity", (Throwable)googlePlayServicesNotAvailableException2);
        }
        if (n != -1) {
            GoogleApiAvailability.getInstance().showErrorDialogFragment((Activity)this.getActivity(), n, 30422);
        }
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        this.zzblp = false;
        if (n == 30421) {
            if (n2 == -1) {
                Place place = PlaceAutocomplete.getPlace((Context)this.getActivity(), intent);
                if (this.zzbls != null) {
                    this.zzbls.onPlaceSelected(place);
                }
                this.setText(place.getName().toString());
            } else if (n2 == 2) {
                Status status = PlaceAutocomplete.getStatus((Context)this.getActivity(), intent);
                if (this.zzbls != null) {
                    this.zzbls.onError(status);
                }
            }
        }
        super.onActivityResult(n, n2, intent);
    }

    static /* synthetic */ boolean zza(SupportPlaceAutocompleteFragment supportPlaceAutocompleteFragment) {
        return supportPlaceAutocompleteFragment.zzblp;
    }

    static /* synthetic */ void zzb(SupportPlaceAutocompleteFragment supportPlaceAutocompleteFragment) {
        supportPlaceAutocompleteFragment.zzwc();
    }
}

