/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.places.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import com.google.android.gms.R;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.places.AutocompleteFilter;
import com.google.android.gms.location.places.Place;
import com.google.android.gms.location.places.ui.PlaceAutocomplete;
import com.google.android.gms.location.places.ui.PlaceSelectionListener;
import com.google.android.gms.location.places.ui.zzb;
import com.google.android.gms.location.places.ui.zze;
import com.google.android.gms.location.places.ui.zzf;
import com.google.android.gms.maps.model.LatLngBounds;

public class SupportPlaceAutocompleteFragment
extends Fragment {
    private View zziej;
    private View zziek;
    private EditText zziel;
    private boolean zziem;
    @Nullable
    private LatLngBounds zzien;
    @Nullable
    private AutocompleteFilter zzieo;
    @Nullable
    private PlaceSelectionListener zziep;

    public SupportPlaceAutocompleteFragment() {
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        View view = layoutInflater.inflate(R.layout.place_autocomplete_fragment, viewGroup, false);
        this.zziej = view.findViewById(R.id.place_autocomplete_search_button);
        this.zziek = view.findViewById(R.id.place_autocomplete_clear_button);
        this.zziel = (EditText)view.findViewById(R.id.place_autocomplete_search_input);
        zze zze2 = new zze(this);
        this.zziej.setOnClickListener((View.OnClickListener)zze2);
        this.zziel.setOnClickListener((View.OnClickListener)zze2);
        this.zziek.setOnClickListener((View.OnClickListener)new zzf(this));
        this.zzath();
        return view;
    }

    public void onDestroyView() {
        this.zziej = null;
        this.zziek = null;
        this.zziel = null;
        super.onDestroyView();
    }

    public void setBoundsBias(@Nullable LatLngBounds latLngBounds) {
        this.zzien = latLngBounds;
    }

    public void setFilter(@Nullable AutocompleteFilter autocompleteFilter) {
        this.zzieo = autocompleteFilter;
    }

    public void setText(CharSequence charSequence) {
        this.zziel.setText(charSequence);
        this.zzath();
    }

    public void setHint(CharSequence charSequence) {
        this.zziel.setHint(charSequence);
        this.zziej.setContentDescription(charSequence);
    }

    public void setOnPlaceSelectedListener(PlaceSelectionListener placeSelectionListener) {
        this.zziep = placeSelectionListener;
    }

    private final void zzath() {
        boolean bl = !this.zziel.getText().toString().isEmpty();
        this.zziek.setVisibility(bl ? 0 : 8);
    }

    private final void zzati() {
        int n = -1;
        try {
            Intent intent = ((zzb)new PlaceAutocomplete.IntentBuilder(2).setBoundsBias(this.zzien).setFilter(this.zzieo).zzih(this.zziel.getText().toString()).zzdt(1)).build((Activity)this.getActivity());
            this.zziem = true;
            this.startActivityForResult(intent, 30421);
        }
        catch (GooglePlayServicesRepairableException googlePlayServicesRepairableException) {
            GooglePlayServicesRepairableException googlePlayServicesRepairableException2 = googlePlayServicesRepairableException;
            n = googlePlayServicesRepairableException.getConnectionStatusCode();
            Log.e((String)"Places", (String)"Could not open autocomplete activity", (Throwable)googlePlayServicesRepairableException2);
        }
        catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
            GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException2 = googlePlayServicesNotAvailableException;
            n = googlePlayServicesNotAvailableException.errorCode;
            Log.e((String)"Places", (String)"Could not open autocomplete activity", (Throwable)googlePlayServicesNotAvailableException2);
        }
        if (n != -1) {
            GoogleApiAvailability.getInstance().showErrorDialogFragment((Activity)this.getActivity(), n, 30422);
        }
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        this.zziem = false;
        if (n == 30421) {
            if (n2 == -1) {
                Place place = PlaceAutocomplete.getPlace((Context)this.getActivity(), intent);
                if (this.zziep != null) {
                    this.zziep.onPlaceSelected(place);
                }
                this.setText(place.getName().toString());
            } else if (n2 == 2) {
                Status status = PlaceAutocomplete.getStatus((Context)this.getActivity(), intent);
                if (this.zziep != null) {
                    this.zziep.onError(status);
                }
            }
        }
        super.onActivityResult(n, n2, intent);
    }

    static /* synthetic */ boolean zza(SupportPlaceAutocompleteFragment supportPlaceAutocompleteFragment) {
        return supportPlaceAutocompleteFragment.zziem;
    }

    static /* synthetic */ void zzb(SupportPlaceAutocompleteFragment supportPlaceAutocompleteFragment) {
        supportPlaceAutocompleteFragment.zzati();
    }
}

