/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.places.ui;

import android.annotation.TargetApi;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import com.google.android.gms.R;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.location.places.AutocompleteFilter;
import com.google.android.gms.location.places.Place;
import com.google.android.gms.location.places.ui.PlaceAutocomplete;
import com.google.android.gms.location.places.ui.PlaceSelectionListener;
import com.google.android.gms.location.places.ui.zzb;
import com.google.android.gms.location.places.ui.zzc;
import com.google.android.gms.location.places.ui.zzd;
import com.google.android.gms.maps.model.LatLngBounds;

@TargetApi(value=12)
public class PlaceAutocompleteFragment
extends Fragment {
    private View zza;
    private View zzb;
    private EditText zzc;
    private boolean zzd;
    @Nullable
    private LatLngBounds zze;
    @Nullable
    private AutocompleteFilter zzf;
    @Nullable
    private PlaceSelectionListener zzg;

    public PlaceAutocompleteFragment() {
    }

    @Hide
    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        View view = layoutInflater.inflate(R.layout.place_autocomplete_fragment, viewGroup, false);
        this.zza = view.findViewById(R.id.place_autocomplete_search_button);
        this.zzb = view.findViewById(R.id.place_autocomplete_clear_button);
        this.zzc = (EditText)view.findViewById(R.id.place_autocomplete_search_input);
        zzc zzc2 = new zzc(this);
        this.zza.setOnClickListener((View.OnClickListener)zzc2);
        this.zzc.setOnClickListener((View.OnClickListener)zzc2);
        this.zzb.setOnClickListener((View.OnClickListener)new zzd(this));
        this.zza();
        return view;
    }

    @Hide
    public void onDestroyView() {
        this.zza = null;
        this.zzb = null;
        this.zzc = null;
        super.onDestroyView();
    }

    public void setBoundsBias(@Nullable LatLngBounds latLngBounds) {
        this.zze = latLngBounds;
    }

    public void setFilter(@Nullable AutocompleteFilter autocompleteFilter) {
        this.zzf = autocompleteFilter;
    }

    public void setText(CharSequence charSequence) {
        this.zzc.setText(charSequence);
        this.zza();
    }

    public void setHint(CharSequence charSequence) {
        this.zzc.setHint(charSequence);
        this.zza.setContentDescription(charSequence);
    }

    public void setOnPlaceSelectedListener(PlaceSelectionListener placeSelectionListener) {
        this.zzg = placeSelectionListener;
    }

    private final void zza() {
        boolean bl = !this.zzc.getText().toString().isEmpty();
        this.zzb.setVisibility(bl ? 0 : 8);
    }

    private final void zzb() {
        int n = -1;
        try {
            Intent intent = ((zzb)new PlaceAutocomplete.IntentBuilder(2).setBoundsBias(this.zze).setFilter(this.zzf).zza(this.zzc.getText().toString()).zza(1)).build(this.getActivity());
            this.zzd = true;
            this.startActivityForResult(intent, 30421);
        }
        catch (GooglePlayServicesRepairableException googlePlayServicesRepairableException) {
            GooglePlayServicesRepairableException googlePlayServicesRepairableException2 = googlePlayServicesRepairableException;
            n = googlePlayServicesRepairableException.getConnectionStatusCode();
            Log.e((String)"Places", (String)"Could not open autocomplete activity", (Throwable)googlePlayServicesRepairableException2);
        }
        catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
            GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException2 = googlePlayServicesNotAvailableException;
            n = googlePlayServicesNotAvailableException.errorCode;
            Log.e((String)"Places", (String)"Could not open autocomplete activity", (Throwable)googlePlayServicesNotAvailableException2);
        }
        if (n != -1) {
            GoogleApiAvailability.getInstance().showErrorDialogFragment(this.getActivity(), n, 30422);
        }
    }

    @Hide
    public void onActivityResult(int n, int n2, Intent intent) {
        this.zzd = false;
        if (n == 30421) {
            if (n2 == -1) {
                Place place = PlaceAutocomplete.getPlace((Context)this.getActivity(), intent);
                if (this.zzg != null) {
                    this.zzg.onPlaceSelected(place);
                }
                this.setText(place.getName().toString());
            } else if (n2 == 2) {
                Status status = PlaceAutocomplete.getStatus((Context)this.getActivity(), intent);
                if (this.zzg != null) {
                    this.zzg.onError(status);
                }
            }
        }
        super.onActivityResult(n, n2, intent);
    }

    static /* synthetic */ boolean zza(PlaceAutocompleteFragment placeAutocompleteFragment) {
        return placeAutocompleteFragment.zzd;
    }

    static /* synthetic */ void zzb(PlaceAutocompleteFragment placeAutocompleteFragment) {
        placeAutocompleteFragment.zzb();
    }
}

